<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseWorkshopSiGroupStudentFeedbackAnswer is autogenerate by UniModel generator
 *
 * This is the model class for table "workshop_si_group_student_feedback_answer".
 *
 * The followings are the available columns in table 'workshop_si_group_student_feedback_answer':
 * @property string $workshop_si_group_student_feedback_answer_id
 * @property string $workshop_si_group_student_feedback_ref_id
 * @property integer $feedback_question_ref_id
 * @property integer $feedback_answer_ref_id
 * @property string $added_on
 * @property integer $added_by
 *
 * The followings are the available model relations:
 * @property LookupFeedbackAnswer $feedbackAnswerRef
 * @property LookupFeedbackQuestion $feedbackQuestionRef
 * @property WorkshopSiGroupStudentFeedback $workshopSiGroupStudentFeedbackRef
 */
class BaseWorkshopSiGroupStudentFeedbackAnswer extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WorkshopSiGroupStudentFeedbackAnswer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'workshop_si_group_student_feedback_answer';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('workshop_si_group_student_feedback_ref_id, added_on', 'required'),
			array('feedback_question_ref_id, feedback_answer_ref_id, added_by', 'numerical', 'integerOnly'=>true),
			array('workshop_si_group_student_feedback_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('workshop_si_group_student_feedback_answer_id, workshop_si_group_student_feedback_ref_id, feedback_question_ref_id, feedback_answer_ref_id, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'feedbackAnswerRef' => array(self::BELONGS_TO, 'LookupFeedbackAnswer', 'feedback_answer_ref_id'),
			'feedbackQuestionRef' => array(self::BELONGS_TO, 'LookupFeedbackQuestion', 'feedback_question_ref_id'),
			'workshopSiGroupStudentFeedbackRef' => array(self::BELONGS_TO, 'WorkshopSiGroupStudentFeedback', 'workshop_si_group_student_feedback_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'workshop_si_group_student_feedback_answer_id' => 'Workshop Si Group Student Feedback Answer',
			'workshop_si_group_student_feedback_ref_id' => 'Workshop Si Group Student Feedback Ref',
			'feedback_question_ref_id' => 'Feedback Question Ref',
			'feedback_answer_ref_id' => 'Feedback Answer Ref',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('workshop_si_group_student_feedback_answer_id',$this->workshop_si_group_student_feedback_answer_id,true);
		$criteria->compare('workshop_si_group_student_feedback_ref_id',$this->workshop_si_group_student_feedback_ref_id,true);
		$criteria->compare('feedback_question_ref_id',$this->feedback_question_ref_id);
		$criteria->compare('feedback_answer_ref_id',$this->feedback_answer_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}