<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorExpertAwards is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_expert_awards".
 *
 * The followings are the available columns in table 'vendor_expert_awards':
 * @property string $vendor_expert_awards_id
 * @property integer $vendor_contact_ref_id
 * @property string $file_name
 *
 * The followings are the available model relations:
 * @property VendorContact $vendorContactRef
 */
class BaseVendorExpertAwards extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorExpertAwards the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_expert_awards';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_contact_ref_id', 'numerical', 'integerOnly'=>true),
			array('file_name', 'length', 'max'=>250),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_expert_awards_id, vendor_contact_ref_id, file_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorContactRef' => array(self::BELONGS_TO, 'VendorContact', 'vendor_contact_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_expert_awards_id' => 'Vendor Expert Awards',
			'vendor_contact_ref_id' => 'Vendor Contact Ref',
			'file_name' => 'File Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_expert_awards_id',$this->vendor_expert_awards_id,true);
		$criteria->compare('vendor_contact_ref_id',$this->vendor_contact_ref_id);
		$criteria->compare('file_name',$this->file_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}