<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCourseEntranceExam is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_course_entrance_exam".
 *
 * The followings are the available columns in table 'vendor_course_entrance_exam':
 * @property string $vendor_course_entrance_exam_id
 * @property integer $vendor_course_ref_id
 * @property integer $entrance_exam_ref_id
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property EntranceExam $entranceExamRef
 * @property VendorCourse $vendorCourseRef
 */
class BaseVendorCourseEntranceExam extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCourseEntranceExam the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_course_entrance_exam';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_course_ref_id, entrance_exam_ref_id, added_by, added_on', 'required'),
			array('vendor_course_ref_id, entrance_exam_ref_id', 'numerical', 'integerOnly'=>true),
			array('added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_course_entrance_exam_id, vendor_course_ref_id, entrance_exam_ref_id, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'vendorCourseRef' => array(self::BELONGS_TO, 'VendorCourse', 'vendor_course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_course_entrance_exam_id' => 'Vendor Course Entrance Exam',
			'vendor_course_ref_id' => 'Vendor Course Ref',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_course_entrance_exam_id',$this->vendor_course_entrance_exam_id,true);
		$criteria->compare('vendor_course_ref_id',$this->vendor_course_ref_id);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}