<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreFaculty is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_faculty".
 *
 * The followings are the available columns in table 'vendor_centre_faculty':
 * @property integer $vendor_centre_faculty_id
 * @property string $vendor_centre_ref_id
 * @property string $salutation
 * @property string $first_name
 * @property string $last_name
 * @property string $background
 * @property string $faculty_picture
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property VendorCentre $vendorCentreRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property VendorCentreFacultyCourses[] $vendorCentreFacultyCourses
 * @property VendorCentreFacultyTests[] $vendorCentreFacultyTests
 */
class BaseVendorCentreFaculty extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreFaculty the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_faculty';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('vendor_centre_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('salutation', 'length', 'max'=>5),
			array('first_name, last_name, background, faculty_picture', 'length', 'max'=>255),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_faculty_id, vendor_centre_ref_id, salutation, first_name, last_name, background, faculty_picture, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreRef' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_centre_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'vendorCentreFacultyCourses' => array(self::HAS_MANY, 'VendorCentreFacultyCourses', 'vendor_centre_faculty_ref_id'),
			'vendorCentreFacultyTests' => array(self::HAS_MANY, 'VendorCentreFacultyTests', 'vendor_centre_faculty_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_faculty_id' => 'Vendor Centre Faculty',
			'vendor_centre_ref_id' => 'Vendor Centre Ref',
			'salutation' => 'Salutation',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'background' => 'Background',
			'faculty_picture' => 'Faculty Picture',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_faculty_id',$this->vendor_centre_faculty_id);
		$criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
		$criteria->compare('salutation',$this->salutation,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('background',$this->background,true);
		$criteria->compare('faculty_picture',$this->faculty_picture,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}