<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreContact is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_contact".
 *
 * The followings are the available columns in table 'vendor_centre_contact':
 * @property integer $vendor_centre_contact_id
 * @property string $vendor_centre_ref_id
 * @property string $salutation
 * @property string $first_name
 * @property string $last_name
 * @property integer $user_type_ref_id
 * @property string $login_ref_id
 *
 * The followings are the available model relations:
 * @property LoginMaster $loginRef
 * @property LookupUserType $userTypeRef
 * @property VendorCentre $vendorCentreRef
 * @property VendorCentreContactNumber[] $vendorCentreContactNumbers
 */
class BaseVendorCentreContact extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreContact the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_contact';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_type_ref_id', 'numerical', 'integerOnly'=>true),
			array('vendor_centre_ref_id, login_ref_id', 'length', 'max'=>10),
			array('salutation', 'length', 'max'=>5),
			array('first_name, last_name', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_contact_id, vendor_centre_ref_id, salutation, first_name, last_name, user_type_ref_id, login_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
			'userTypeRef' => array(self::BELONGS_TO, 'LookupUserType', 'user_type_ref_id'),
			'vendorCentreRef' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_centre_ref_id'),
			'vendorCentreContactNumbers' => array(self::HAS_MANY, 'VendorCentreContactNumber', 'vendor_centre_contact_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_contact_id' => 'Vendor Centre Contact',
			'vendor_centre_ref_id' => 'Vendor Centre Ref',
			'salutation' => 'Salutation',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'user_type_ref_id' => 'User Type Ref',
			'login_ref_id' => 'Login Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_contact_id',$this->vendor_centre_contact_id);
		$criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
		$criteria->compare('salutation',$this->salutation,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('user_type_ref_id',$this->user_type_ref_id);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}