<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreBatches is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_batches".
 *
 * The followings are the available columns in table 'vendor_centre_batches':
 * @property integer $vendor_centre_barches_id
 * @property string $vendor_centre_course_ref_id
 * @property string $batch_day_timing
 * @property string $batch_descrption
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property VendorCentreCourse $vendorCentreCourseRef
 */
class BaseVendorCentreBatches extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreBatches the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_batches';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('vendor_centre_course_ref_id', 'length', 'max'=>10),
			array('batch_day_timing, batch_descrption', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_barches_id, vendor_centre_course_ref_id, batch_day_timing, batch_descrption, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreCourseRef' => array(self::BELONGS_TO, 'VendorCentreCourse', 'vendor_centre_course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_barches_id' => 'Vendor Centre Barches',
			'vendor_centre_course_ref_id' => 'Vendor Centre Course Ref',
			'batch_day_timing' => 'Batch Day Timing',
			'batch_descrption' => 'Batch Descrption',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_barches_id',$this->vendor_centre_barches_id);
		$criteria->compare('vendor_centre_course_ref_id',$this->vendor_centre_course_ref_id,true);
		$criteria->compare('batch_day_timing',$this->batch_day_timing,true);
		$criteria->compare('batch_descrption',$this->batch_descrption,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}