<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorBranch is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_branch".
 *
 * The followings are the available columns in table 'vendor_branch':
 * @property string $vendor_branch_id
 * @property string $vendor_ref_id
 * @property string $branch_name
 * @property string $address
 * @property string $contact_number
 * @property string $email_id
 * @property string $url
 * @property integer $state_ref_id
 * @property integer $city_ref_id
 * @property integer $country_ref_id
 * @property string $post_code
 *
 * The followings are the available model relations:
 * @property EntranceExam[] $entranceExams
 * @property StudentEntranceExamVendorBranch[] $studentEntranceExamVendorBranches
 * @property TblCityMaster $cityRef
 * @property TblCountryMaster $countryRef
 * @property TblState $stateRef
 * @property Vendor $vendorRef
 */
class BaseVendorBranch extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorBranch the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_branch';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_ref_id, city_ref_id, country_ref_id', 'required'),
			array('state_ref_id, city_ref_id, country_ref_id', 'numerical', 'integerOnly'=>true),
			array('vendor_ref_id', 'length', 'max'=>10),
			array('branch_name, url', 'length', 'max'=>255),
			array('contact_number, post_code', 'length', 'max'=>45),
			array('email_id', 'length', 'max'=>150),
			array('address', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_branch_id, vendor_ref_id, branch_name, address, contact_number, email_id, url, state_ref_id, city_ref_id, country_ref_id, post_code', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceExams' => array(self::MANY_MANY, 'EntranceExam', 'entrance_exam_vendor_branch(vendor_branch_ref_id, entrance_exam_ref_id)'),
			'studentEntranceExamVendorBranches' => array(self::HAS_MANY, 'StudentEntranceExamVendorBranch', 'vendor_branch_ref_id'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'stateRef' => array(self::BELONGS_TO, 'TblState', 'state_ref_id'),
			'vendorRef' => array(self::BELONGS_TO, 'Vendor', 'vendor_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_branch_id' => 'Vendor Branch',
			'vendor_ref_id' => 'Vendor Ref',
			'branch_name' => 'Branch Name',
			'address' => 'Address',
			'contact_number' => 'Contact Number',
			'email_id' => 'Email',
			'url' => 'Url',
			'state_ref_id' => 'State Ref',
			'city_ref_id' => 'City Ref',
			'country_ref_id' => 'Country Ref',
			'post_code' => 'Post Code',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_branch_id',$this->vendor_branch_id,true);
		$criteria->compare('vendor_ref_id',$this->vendor_ref_id,true);
		$criteria->compare('branch_name',$this->branch_name,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('contact_number',$this->contact_number,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('url',$this->url,true);
		$criteria->compare('state_ref_id',$this->state_ref_id);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('post_code',$this->post_code,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}