<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTrainingModuleSlide is autogenerate by UniModel generator
 *
 * This is the model class for table "training_module_slide".
 *
 * The followings are the available columns in table 'training_module_slide':
 * @property string $training_module_slide_id
 * @property integer $training_module_ref_id
 * @property string $parent_ref_id
 * @property integer $slide_ref_id
 * @property integer $duration
 * @property integer $display_order
 * @property integer $is_active
 * @property integer $is_visible
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LookupSlide $slideRef
 * @property TrainingModule $trainingModuleRef
 * @property TrainingModuleSlideAssessment[] $trainingModuleSlideAssessments
 * @property TrainingModuleSlideAssessmentQuestion[] $trainingModuleSlideAssessmentQuestions
 * @property TrainingModuleSlidePhotoCaption[] $trainingModuleSlidePhotoCaptions
 * @property TrainingModuleSlideText[] $trainingModuleSlideTexts
 * @property TrainingModuleSlideTitle[] $trainingModuleSlideTitles
 */
class BaseTrainingModuleSlide extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TrainingModuleSlide the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'training_module_slide';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('training_module_ref_id, slide_ref_id', 'required'),
			array('training_module_ref_id, slide_ref_id, duration, display_order, is_active, is_visible', 'numerical', 'integerOnly'=>true),
			array('parent_ref_id, added_by', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('training_module_slide_id, training_module_ref_id, parent_ref_id, slide_ref_id, duration, display_order, is_active, is_visible, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'slideRef' => array(self::BELONGS_TO, 'LookupSlide', 'slide_ref_id'),
			'trainingModuleRef' => array(self::BELONGS_TO, 'TrainingModule', 'training_module_ref_id'),
			'trainingModuleSlideAssessments' => array(self::HAS_MANY, 'TrainingModuleSlideAssessment', 'training_module_slide_ref_id'),
			'trainingModuleSlideAssessmentQuestions' => array(self::HAS_MANY, 'TrainingModuleSlideAssessmentQuestion', 'training_module_slide_ref_id'),
			'trainingModuleSlidePhotoCaptions' => array(self::HAS_MANY, 'TrainingModuleSlidePhotoCaption', 'training_module_slide_ref_id'),
			'trainingModuleSlideTexts' => array(self::HAS_MANY, 'TrainingModuleSlideText', 'training_module_slide_ref_id'),
			'trainingModuleSlideTitles' => array(self::HAS_MANY, 'TrainingModuleSlideTitle', 'training_module_slide_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'training_module_slide_id' => 'Training Module Slide',
			'training_module_ref_id' => 'Training Module Ref',
			'parent_ref_id' => 'Parent Ref',
			'slide_ref_id' => 'Slide Ref',
			'duration' => 'Duration',
			'display_order' => 'Display Order',
			'is_active' => 'Is Active',
			'is_visible' => 'Is Visible',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('training_module_slide_id',$this->training_module_slide_id,true);
		$criteria->compare('training_module_ref_id',$this->training_module_ref_id);
		$criteria->compare('parent_ref_id',$this->parent_ref_id,true);
		$criteria->compare('slide_ref_id',$this->slide_ref_id);
		$criteria->compare('duration',$this->duration);
		$criteria->compare('display_order',$this->display_order);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('is_visible',$this->is_visible);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}