<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblUniWeather is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_uni_weather".
 *
 * The followings are the available columns in table 'tbl_uni_weather':
 * @property integer $temp_id
 * @property integer $uni_ref_id
 * @property string $min_temp
 * @property string $winter_day_temp
 * @property string $winter_night_temp
 * @property string $spring_day_temp
 * @property string $spring_night_temp
 * @property string $summer_day_temp
 * @property string $summer_night_temp
 * @property string $autumn_day_temp
 * @property string $autumn_night_temp
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 */
class BaseTblUniWeather extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblUniWeather the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_uni_weather';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('min_temp, winter_day_temp, winter_night_temp, spring_day_temp, spring_night_temp, summer_day_temp, summer_night_temp, autumn_day_temp, autumn_night_temp', 'length', 'max'=>255),
			array('added_by, modified_on, modified_by', 'length', 'max'=>100),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('temp_id, uni_ref_id, min_temp, winter_day_temp, winter_night_temp, spring_day_temp, spring_night_temp, summer_day_temp, summer_night_temp, autumn_day_temp, autumn_night_temp, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'temp_id' => 'Temp',
			'uni_ref_id' => 'Uni Ref',
			'min_temp' => 'Min Temp',
			'winter_day_temp' => 'Winter Day Temp',
			'winter_night_temp' => 'Winter Night Temp',
			'spring_day_temp' => 'Spring Day Temp',
			'spring_night_temp' => 'Spring Night Temp',
			'summer_day_temp' => 'Summer Day Temp',
			'summer_night_temp' => 'Summer Night Temp',
			'autumn_day_temp' => 'Autumn Day Temp',
			'autumn_night_temp' => 'Autumn Night Temp',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('temp_id',$this->temp_id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('min_temp',$this->min_temp,true);
		$criteria->compare('winter_day_temp',$this->winter_day_temp,true);
		$criteria->compare('winter_night_temp',$this->winter_night_temp,true);
		$criteria->compare('spring_day_temp',$this->spring_day_temp,true);
		$criteria->compare('spring_night_temp',$this->spring_night_temp,true);
		$criteria->compare('summer_day_temp',$this->summer_day_temp,true);
		$criteria->compare('summer_night_temp',$this->summer_night_temp,true);
		$criteria->compare('autumn_day_temp',$this->autumn_day_temp,true);
		$criteria->compare('autumn_night_temp',$this->autumn_night_temp,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}