<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblState is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_state".
 *
 * The followings are the available columns in table 'tbl_state':
 * @property integer $id
 * @property string $name
 * @property integer $country_ref_id
 * @property string $state_code
 * @property integer $region_ref_id
 * @property string $added_on
 * @property string $synonym_names
 *
 * The followings are the available model relations:
 * @property EntranceExamApplicableLocation[] $entranceExamApplicableLocations
 * @property SeoState[] $seoStates
 * @property StudentPreferredLocation[] $studentPreferredLocations
 * @property TblCityMaster[] $tblCityMasters
 * @property TblCountryMaster $countryRef
 * @property LookupRegion $regionRef
 * @property TblUniversityMaster[] $tblUniversityMasters
 * @property TblUserMaster[] $tblUserMasters
 * @property VendorCenter[] $vendorCenters
 * @property VendorCentre[] $vendorCentres
 */
class BaseTblState extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblState the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_state';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, country_ref_id, added_on', 'required'),
			array('country_ref_id, region_ref_id', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>75),
			array('state_code', 'length', 'max'=>3),
			array('synonym_names', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name, country_ref_id, state_code, region_ref_id, added_on, synonym_names', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceExamApplicableLocations' => array(self::HAS_MANY, 'EntranceExamApplicableLocation', 'state_ref_id'),
			'seoStates' => array(self::HAS_MANY, 'SeoState', 'state_ref_id'),
			'studentPreferredLocations' => array(self::HAS_MANY, 'StudentPreferredLocation', 'state_ref_id'),
			'tblCityMasters' => array(self::HAS_MANY, 'TblCityMaster', 'state_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'regionRef' => array(self::BELONGS_TO, 'LookupRegion', 'region_ref_id'),
			'tblUniversityMasters' => array(self::HAS_MANY, 'TblUniversityMaster', 'state_ref_id'),
			'tblUserMasters' => array(self::HAS_MANY, 'TblUserMaster', 'state_ref_id'),
			'vendorCenters' => array(self::HAS_MANY, 'VendorCenter', 'state_ref_id'),
			'vendorCentres' => array(self::HAS_MANY, 'VendorCentre', 'state_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'country_ref_id' => 'Country Ref',
			'state_code' => 'State Code',
			'region_ref_id' => 'Region Ref',
			'added_on' => 'Added On',
			'synonym_names' => 'Synonym Names',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('state_code',$this->state_code,true);
		$criteria->compare('region_ref_id',$this->region_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('synonym_names',$this->synonym_names,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}