<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentWorkplanAdditionalActivity is autogenerate by UniModel generator
 *
 * This is the model class for table "student_workplan_additional_activity".
 *
 * The followings are the available columns in table 'student_workplan_additional_activity':
 * @property string $student_workplan_additional_activity_id
 * @property string $user_ref_id
 * @property string $activity_name
 * @property integer $time_spent_hrs
 * @property integer $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property TblAdmin $addedBy
 */
class BaseStudentWorkplanAdditionalActivity extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentWorkplanAdditionalActivity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_workplan_additional_activity';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, added_by', 'required'),
			array('time_spent_hrs, added_by', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('activity_name, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_workplan_additional_activity_id, user_ref_id, activity_name, time_spent_hrs, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_workplan_additional_activity_id' => 'Student Workplan Additional Activity',
			'user_ref_id' => 'User Ref',
			'activity_name' => 'Activity Name',
			'time_spent_hrs' => 'Time Spent Hrs',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_workplan_additional_activity_id',$this->student_workplan_additional_activity_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('activity_name',$this->activity_name,true);
		$criteria->compare('time_spent_hrs',$this->time_spent_hrs);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}