<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentValidationTracker is autogenerate by UniModel generator
 *
 * This is the model class for table "student_validation_tracker".
 *
 * The followings are the available columns in table 'student_validation_tracker':
 * @property integer $student_validation_tracker_id
 * @property string $user_ref_id
 * @property string $email_type
 * @property string $sent_on
 * @property string $unique_code
 * @property integer $is_expired
 * @property string $mail_open_date
 * @property string $profile_confirm_date
 * @property string $accessed_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseStudentValidationTracker extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentValidationTracker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_validation_tracker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, sent_on, unique_code', 'required'),
			array('is_expired', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('email_type', 'length', 'max'=>4),
			array('unique_code', 'length', 'max'=>500),
			array('mail_open_date, profile_confirm_date, accessed_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_validation_tracker_id, user_ref_id, email_type, sent_on, unique_code, is_expired, mail_open_date, profile_confirm_date, accessed_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_validation_tracker_id' => 'Student Validation Tracker',
			'user_ref_id' => 'User Ref',
			'email_type' => 'Email Type',
			'sent_on' => 'Sent On',
			'unique_code' => 'Unique Code',
			'is_expired' => 'Is Expired',
			'mail_open_date' => 'Mail Open Date',
			'profile_confirm_date' => 'Profile Confirm Date',
			'accessed_on' => 'Accessed On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_validation_tracker_id',$this->student_validation_tracker_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('email_type',$this->email_type,true);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('unique_code',$this->unique_code,true);
		$criteria->compare('is_expired',$this->is_expired);
		$criteria->compare('mail_open_date',$this->mail_open_date,true);
		$criteria->compare('profile_confirm_date',$this->profile_confirm_date,true);
		$criteria->compare('accessed_on',$this->accessed_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}