<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentUploadMasterList is autogenerate by UniModel generator
 *
 * This is the model class for table "student_upload_master_list".
 *
 * The followings are the available columns in table 'student_upload_master_list':
 * @property string $student_upload_master_list_id
 * @property integer $inst_ref_id
 * @property string $user_ref_id
 * @property string $first_name
 * @property string $last_name
 * @property string $email_id
 * @property string $country_code
 * @property string $phone_number
 * @property string $class
 * @property string $class_status
 * @property integer $board_ref_id
 * @property string $section
 * @property string $gender
 * @property integer $completion_month
 * @property integer $completion_year
 * @property string $invitation_status
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LookupBoard $boardRef
 * @property TblSiDi $instRef
 * @property TblUserMaster $userRef
 */
class BaseStudentUploadMasterList extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentUploadMasterList the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_upload_master_list';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('completion_year, added_on, added_by', 'required'),
			array('inst_ref_id, board_ref_id, completion_month, completion_year', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('first_name, last_name', 'length', 'max'=>100),
			array('email_id', 'length', 'max'=>255),
			array('country_code', 'length', 'max'=>4),
			array('phone_number', 'length', 'max'=>50),
			array('class', 'length', 'max'=>2),
			array('class_status, invitation_status', 'length', 'max'=>8),
			array('section, gender', 'length', 'max'=>1),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_upload_master_list_id, inst_ref_id, user_ref_id, first_name, last_name, email_id, country_code, phone_number, class, class_status, board_ref_id, section, gender, completion_month, completion_year, invitation_status, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
			'instRef' => array(self::BELONGS_TO, 'TblSiDi', 'inst_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_upload_master_list_id' => 'Student Upload Master List',
			'inst_ref_id' => 'Inst Ref',
			'user_ref_id' => 'User Ref',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'email_id' => 'Email',
			'country_code' => 'Country Code',
			'phone_number' => 'Phone Number',
			'class' => 'Class',
			'class_status' => 'Class Status',
			'board_ref_id' => 'Board Ref',
			'section' => 'Section',
			'gender' => 'Gender',
			'completion_month' => 'Completion Month',
			'completion_year' => 'Completion Year',
			'invitation_status' => 'Invitation Status',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_upload_master_list_id',$this->student_upload_master_list_id,true);
		$criteria->compare('inst_ref_id',$this->inst_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('country_code',$this->country_code,true);
		$criteria->compare('phone_number',$this->phone_number,true);
		$criteria->compare('class',$this->class,true);
		$criteria->compare('class_status',$this->class_status,true);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('section',$this->section,true);
		$criteria->compare('gender',$this->gender,true);
		$criteria->compare('completion_month',$this->completion_month);
		$criteria->compare('completion_year',$this->completion_year);
		$criteria->compare('invitation_status',$this->invitation_status,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}