<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentCitizenship is autogenerate by UniModel generator
 *
 * This is the model class for table "student_citizenship".
 *
 * The followings are the available columns in table 'student_citizenship':
 * @property string $student_citizenship_id
 * @property string $user_ref_id
 * @property integer $citizenship_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblCountryMaster $citizenshipRef
 * @property TblUserMaster $userRef
 */
class BaseStudentCitizenship extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentCitizenship the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_citizenship';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, citizenship_ref_id', 'required'),
			array('citizenship_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_citizenship_id, user_ref_id, citizenship_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'citizenshipRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'citizenship_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_citizenship_id' => 'Student Citizenship',
			'user_ref_id' => 'User Ref',
			'citizenship_ref_id' => 'Citizenship Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_citizenship_id',$this->student_citizenship_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('citizenship_ref_id',$this->citizenship_ref_id);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}