<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseScholarshipDepartment is autogenerate by UniModel generator
 *
 * This is the model class for table "scholarship_department".
 *
 * The followings are the available columns in table 'scholarship_department':
 * @property string $scholarship_department_id
 * @property string $scholarship_ref_id
 * @property integer $course_level_ref_id
 * @property integer $main_dept_ref_id
 * @property integer $sub_dept_ref_id
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 *
 * The followings are the available model relations:
 * @property LookupCourseLevel $courseLevelRef
 * @property LoginMaster $addedBy
 * @property LookupDepartment $mainDeptRef
 * @property LoginMaster $modifiedBy
 * @property Scholarship $scholarshipRef
 * @property LookupDepartment $subDeptRef
 */
class BaseScholarshipDepartment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ScholarshipDepartment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'scholarship_department';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_ref_id, added_by', 'required'),
			array('course_level_ref_id, main_dept_ref_id, sub_dept_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('scholarship_ref_id', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_department_id, scholarship_ref_id, course_level_ref_id, main_dept_ref_id, sub_dept_ref_id, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseLevelRef' => array(self::BELONGS_TO, 'LookupCourseLevel', 'course_level_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'mainDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_dept_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'subDeptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'sub_dept_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_department_id' => 'Scholarship Department',
			'scholarship_ref_id' => 'Scholarship Ref',
			'course_level_ref_id' => 'Course Level Ref',
			'main_dept_ref_id' => 'Main Dept Ref',
			'sub_dept_ref_id' => 'Sub Dept Ref',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_department_id',$this->scholarship_department_id,true);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('course_level_ref_id',$this->course_level_ref_id);
		$criteria->compare('main_dept_ref_id',$this->main_dept_ref_id);
		$criteria->compare('sub_dept_ref_id',$this->sub_dept_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}