<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseRequestCallback is autogenerate by UniModel generator
 *
 * This is the model class for table "request_callback".
 *
 * The followings are the available columns in table 'request_callback':
 * @property string $request_callback_id
 * @property string $user_ref_id
 * @property integer $uni_ref_id
 * @property integer $dept_ref_id
 * @property string $mobile_number
 * @property string $added_on
 * @property integer $timezone_ref_id
 * @property string $pref_time
 * @property string $email_sent
 *
 * The followings are the available model relations:
 * @property DiBannerRequestCallback[] $diBannerRequestCallbacks
 * @property LookupDepartment $deptRef
 * @property LookupTimezone $timezoneRef
 * @property TblUniversityMaster $uniRef
 * @property TblUserMaster $userRef
 */
class BaseRequestCallback extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return RequestCallback the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'request_callback';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, uni_ref_id, dept_ref_id, mobile_number, added_on, timezone_ref_id, pref_time', 'required'),
			array('uni_ref_id, dept_ref_id, timezone_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('mobile_number', 'length', 'max'=>15),
			array('pref_time', 'length', 'max'=>20),
			array('email_sent', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('request_callback_id, user_ref_id, uni_ref_id, dept_ref_id, mobile_number, added_on, timezone_ref_id, pref_time, email_sent', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diBannerRequestCallbacks' => array(self::HAS_MANY, 'DiBannerRequestCallback', 'request_callback_ref_id'),
			'deptRef' => array(self::BELONGS_TO, 'LookupDepartment', 'dept_ref_id'),
			'timezoneRef' => array(self::BELONGS_TO, 'LookupTimezone', 'timezone_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'request_callback_id' => 'Request Callback',
			'user_ref_id' => 'User Ref',
			'uni_ref_id' => 'Uni Ref',
			'dept_ref_id' => 'Dept Ref',
			'mobile_number' => 'Mobile Number',
			'added_on' => 'Added On',
			'timezone_ref_id' => 'Timezone Ref',
			'pref_time' => 'Pref Time',
			'email_sent' => 'Email Sent',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('request_callback_id',$this->request_callback_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('dept_ref_id',$this->dept_ref_id);
		$criteria->compare('mobile_number',$this->mobile_number,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('timezone_ref_id',$this->timezone_ref_id);
		$criteria->compare('pref_time',$this->pref_time,true);
		$criteria->compare('email_sent',$this->email_sent,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}