<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMockTestQueOptions is autogenerate by UniModel generator
 *
 * This is the model class for table "mock_test_que_options".
 *
 * The followings are the available columns in table 'mock_test_que_options':
 * @property string $mock_test_que_option_id
 * @property string $mock_test_questions_ref_id
 * @property string $que_option
 * @property string $is_correct
 * @property string $added_on
 * @property string $added_by
 * @property integer $marks
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property MockTestQuestions $mockTestQuestionsRef
 * @property MockTestUserAnswers[] $mockTestUserAnswers
 */
class BaseMockTestQueOptions extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MockTestQueOptions the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'mock_test_que_options';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('marks', 'numerical', 'integerOnly'=>true),
			array('mock_test_questions_ref_id, added_by', 'length', 'max'=>10),
			array('is_correct', 'length', 'max'=>1),
			array('que_option, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('mock_test_que_option_id, mock_test_questions_ref_id, que_option, is_correct, added_on, added_by, marks', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'mockTestQuestionsRef' => array(self::BELONGS_TO, 'MockTestQuestions', 'mock_test_questions_ref_id'),
			'mockTestUserAnswers' => array(self::HAS_MANY, 'MockTestUserAnswers', 'option_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mock_test_que_option_id' => 'Mock Test Que Option',
			'mock_test_questions_ref_id' => 'Mock Test Questions Ref',
			'que_option' => 'Que Option',
			'is_correct' => 'Is Correct',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'marks' => 'Marks',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('mock_test_que_option_id',$this->mock_test_que_option_id,true);
		$criteria->compare('mock_test_questions_ref_id',$this->mock_test_questions_ref_id,true);
		$criteria->compare('que_option',$this->que_option,true);
		$criteria->compare('is_correct',$this->is_correct,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('marks',$this->marks);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}