<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMilestoneFor9n10 is autogenerate by UniModel generator
 *
 * This is the model class for table "milestone_for_9n10".
 *
 * The followings are the available columns in table 'milestone_for_9n10':
 * @property string $id
 * @property integer $milestone_ref_id
 * @property integer $order
 *
 * The followings are the available model relations:
 * @property LookupMilestone $milestoneRef
 */
class BaseMilestoneFor9n10 extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MilestoneFor9n10 the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'milestone_for_9n10';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('milestone_ref_id, order', 'required'),
			array('milestone_ref_id, order', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, milestone_ref_id, order', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'milestoneRef' => array(self::BELONGS_TO, 'LookupMilestone', 'milestone_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'milestone_ref_id' => 'Milestone Ref',
			'order' => 'Order',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('milestone_ref_id',$this->milestone_ref_id);
		$criteria->compare('order',$this->order);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}