<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMembership is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_membership".
 *
 * The followings are the available columns in table 'lookup_membership':
 * @property integer $membership_id
 * @property string $membership_name
 * @property string $membership_desc
 */
class BaseMembership extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Membership the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_membership';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('membership_name', 'length', 'max'=>45),
			array('membership_desc', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('membership_id, membership_name, membership_desc', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'membership_id' => 'Membership',
			'membership_name' => 'Membership Name',
			'membership_desc' => 'Membership Desc',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('membership_id',$this->membership_id);
		$criteria->compare('membership_name',$this->membership_name,true);
		$criteria->compare('membership_desc',$this->membership_desc,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}