<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseInvoiceCustomer is autogenerate by UniModel generator
 *
 * This is the model class for table "invoice_customer".
 *
 * The followings are the available columns in table 'invoice_customer':
 * @property string $invoice_customer_id
 * @property string $invoice_customer_name
 * @property string $invoice_email_id
 * @property string $address
 * @property string $phone_number
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property OrderMaster[] $orderMasters
 */
class BaseInvoiceCustomer extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return InvoiceCustomer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'invoice_customer';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('invoice_customer_name', 'length', 'max'=>150),
			array('invoice_email_id, phone_number, added_by', 'length', 'max'=>50),
			array('address, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('invoice_customer_id, invoice_customer_name, invoice_email_id, address, phone_number, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'orderMasters' => array(self::HAS_MANY, 'OrderMaster', 'invoice_customer_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'invoice_customer_id' => 'Invoice Customer',
			'invoice_customer_name' => 'Invoice Customer Name',
			'invoice_email_id' => 'Invoice Email',
			'address' => 'Address',
			'phone_number' => 'Phone Number',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('invoice_customer_id',$this->invoice_customer_id,true);
		$criteria->compare('invoice_customer_name',$this->invoice_customer_name,true);
		$criteria->compare('invoice_email_id',$this->invoice_email_id,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('phone_number',$this->phone_number,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}