<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseGemLeadProspectInteraction is autogenerate by UniModel generator
 *
 * This is the model class for table "gem_lead_prospect_interaction".
 *
 * The followings are the available columns in table 'gem_lead_prospect_interaction':
 * @property string $gem_lead_prospect_interaction_id
 * @property string $gem_lead_prospect_ref_id
 * @property integer $advisor_ref_id
 * @property string $other_advisor
 * @property integer $interaction_ref_id
 * @property string $interaction_date
 * @property integer $assisted_by
 * @property string $summary
 * @property integer $rating
 * @property string $next_interaction
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $advisorRef
 * @property TblAdmin $assistedBy
 * @property MasterInteraction $interactionRef
 * @property GemLeadProspect $gemLeadProspectRef
 */
class BaseGemLeadProspectInteraction extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GemLeadProspectInteraction the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'gem_lead_prospect_interaction';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('gem_lead_prospect_ref_id, advisor_ref_id, interaction_ref_id', 'required'),
			array('advisor_ref_id, interaction_ref_id, assisted_by, rating', 'numerical', 'integerOnly'=>true),
			array('gem_lead_prospect_ref_id', 'length', 'max'=>10),
			array('other_advisor', 'length', 'max'=>64),
			array('interaction_date, summary, next_interaction, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('gem_lead_prospect_interaction_id, gem_lead_prospect_ref_id, advisor_ref_id, other_advisor, interaction_ref_id, interaction_date, assisted_by, summary, rating, next_interaction, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'advisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'advisor_ref_id'),
			'assistedBy' => array(self::BELONGS_TO, 'TblAdmin', 'assisted_by'),
			'interactionRef' => array(self::BELONGS_TO, 'MasterInteraction', 'interaction_ref_id'),
			'gemLeadProspectRef' => array(self::BELONGS_TO, 'GemLeadProspect', 'gem_lead_prospect_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'gem_lead_prospect_interaction_id' => 'Gem Lead Prospect Interaction',
			'gem_lead_prospect_ref_id' => 'Gem Lead Prospect Ref',
			'advisor_ref_id' => 'Advisor Ref',
			'other_advisor' => 'Other Advisor',
			'interaction_ref_id' => 'Interaction Ref',
			'interaction_date' => 'Interaction Date',
			'assisted_by' => 'Assisted By',
			'summary' => 'Summary',
			'rating' => 'Rating',
			'next_interaction' => 'Next Interaction',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('gem_lead_prospect_interaction_id',$this->gem_lead_prospect_interaction_id,true);
		$criteria->compare('gem_lead_prospect_ref_id',$this->gem_lead_prospect_ref_id,true);
		$criteria->compare('advisor_ref_id',$this->advisor_ref_id);
		$criteria->compare('other_advisor',$this->other_advisor,true);
		$criteria->compare('interaction_ref_id',$this->interaction_ref_id);
		$criteria->compare('interaction_date',$this->interaction_date,true);
		$criteria->compare('assisted_by',$this->assisted_by);
		$criteria->compare('summary',$this->summary,true);
		$criteria->compare('rating',$this->rating);
		$criteria->compare('next_interaction',$this->next_interaction,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}