<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseGatewayPayment is autogenerate by UniModel generator
 *
 * This is the model class for table "gateway_payment".
 *
 * The followings are the available columns in table 'gateway_payment':
 * @property string $gateway_payment_id
 * @property string $reference_no
 * @property string $amount
 * @property string $description
 * @property string $name
 * @property string $address
 * @property string $city
 * @property string $state
 * @property string $country
 * @property string $postal_code
 * @property string $phone
 * @property string $email
 * @property string $status
 * @property string $return_to
 * @property string $error_message
 * @property integer $is_success
 * @property integer $response_code
 * @property string $response_message
 * @property string $IsFlagged
 * @property string $payment_id
 * @property string $transaction_id
 * @property integer $bas_test_id
 * @property string $user_ref_id
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property OrderPayment[] $orderPayments
 */
class BaseGatewayPayment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GatewayPayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'gateway_payment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('reference_no, amount, name, email', 'required'),
			array('is_success, response_code, bas_test_id', 'numerical', 'integerOnly'=>true),
			array('reference_no, payment_id, transaction_id', 'length', 'max'=>20),
			array('amount', 'length', 'max'=>14),
			array('description, address, return_to, error_message, response_message', 'length', 'max'=>255),
			array('name', 'length', 'max'=>150),
			array('city, state, phone', 'length', 'max'=>75),
			array('country, IsFlagged', 'length', 'max'=>3),
			array('postal_code, status, user_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('email', 'length', 'max'=>100),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('gateway_payment_id, reference_no, amount, description, name, address, city, state, country, postal_code, phone, email, status, return_to, error_message, is_success, response_code, response_message, IsFlagged, payment_id, transaction_id, bas_test_id, user_ref_id, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'orderPayments' => array(self::HAS_MANY, 'OrderPayment', 'gateway_payment_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'gateway_payment_id' => 'Gateway Payment',
			'reference_no' => 'Reference No',
			'amount' => 'Amount',
			'description' => 'Description',
			'name' => 'Name',
			'address' => 'Address',
			'city' => 'City',
			'state' => 'State',
			'country' => 'Country',
			'postal_code' => 'Postal Code',
			'phone' => 'Phone',
			'email' => 'Email',
			'status' => 'Status',
			'return_to' => 'Return To',
			'error_message' => 'Error Message',
			'is_success' => 'Is Success',
			'response_code' => 'Response Code',
			'response_message' => 'Response Message',
			'IsFlagged' => 'Is Flagged',
			'payment_id' => 'Payment',
			'transaction_id' => 'Transaction',
			'bas_test_id' => 'Bas Test',
			'user_ref_id' => 'User Ref',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('gateway_payment_id',$this->gateway_payment_id,true);
		$criteria->compare('reference_no',$this->reference_no,true);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('address',$this->address,true);
		$criteria->compare('city',$this->city,true);
		$criteria->compare('state',$this->state,true);
		$criteria->compare('country',$this->country,true);
		$criteria->compare('postal_code',$this->postal_code,true);
		$criteria->compare('phone',$this->phone,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('return_to',$this->return_to,true);
		$criteria->compare('error_message',$this->error_message,true);
		$criteria->compare('is_success',$this->is_success);
		$criteria->compare('response_code',$this->response_code);
		$criteria->compare('response_message',$this->response_message,true);
		$criteria->compare('IsFlagged',$this->IsFlagged,true);
		$criteria->compare('payment_id',$this->payment_id,true);
		$criteria->compare('transaction_id',$this->transaction_id,true);
		$criteria->compare('bas_test_id',$this->bas_test_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}