<?php


class BaseEventEmailResponse extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventEmailResponse the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'event_email_response';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_email_ref_id', 'required'),
			array('event_email_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>11),
			array('response', 'length', 'max'=>1),
			array('opened_on, responded_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('event_email_response_id, event_email_ref_id, user_ref_id, response, opened_on, responded_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventEmailRef' => array(self::BELONGS_TO, 'EventEmail', 'event_email_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'event_email_response_id' => 'Event Email Response',
			'event_email_ref_id' => 'Event Email Ref',
			'user_ref_id' => 'User Ref',
			'response' => 'Response',
			'opened_on' => 'Opened On',
			'responded_on' => 'Responded On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('event_email_response_id',$this->event_email_response_id);
		$criteria->compare('event_email_ref_id',$this->event_email_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('response',$this->response,true);
		$criteria->compare('opened_on',$this->opened_on,true);
		$criteria->compare('responded_on',$this->responded_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}