<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamSamplePaper is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_sample_paper".
 *
 * The followings are the available columns in table 'entrance_exam_sample_paper':
 * @property string $entrance_exam_sample_paper_id
 * @property integer $entrance_exam_ref_id
 * @property string $topic_name
 * @property string $filename
 * @property integer $is_full_length
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property EntranceExam $entranceExamRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseEntranceExamSamplePaper extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamSamplePaper the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_sample_paper';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_exam_ref_id, filename, added_on, added_by', 'required'),
			array('entrance_exam_ref_id, is_full_length', 'numerical', 'integerOnly'=>true),
			array('topic_name, filename', 'length', 'max'=>255),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_exam_sample_paper_id, entrance_exam_ref_id, topic_name, filename, is_full_length, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_exam_sample_paper_id' => 'Entrance Exam Sample Paper',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'topic_name' => 'Topic Name',
			'filename' => 'Filename',
			'is_full_length' => 'Is Full Length',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_exam_sample_paper_id',$this->entrance_exam_sample_paper_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('topic_name',$this->topic_name,true);
		$criteria->compare('filename',$this->filename,true);
		$criteria->compare('is_full_length',$this->is_full_length);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}