<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamDetails is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_details".
 *
 * The followings are the available columns in table 'entrance_exam_details':
 * @property string $entrance_exam_details_id
 * @property integer $entrance_exam_ref_id
 * @property string $popular
 * @property string $rank
 * @property string $percentile
 * @property string $total_score
 * @property string $subject_marks_needed
 * @property integer $no_of_subjects
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property EntranceExam $entranceExamRef
 */
class BaseEntranceExamDetails extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_exam_ref_id, no_of_subjects', 'numerical', 'integerOnly'=>true),
			array('popular', 'length', 'max'=>6),
			array('rank, percentile, total_score, subject_marks_needed', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_exam_details_id, entrance_exam_ref_id, popular, rank, percentile, total_score, subject_marks_needed, no_of_subjects, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_exam_details_id' => 'Entrance Exam Details',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'popular' => 'Popular',
			'rank' => 'Rank',
			'percentile' => 'Percentile',
			'total_score' => 'Total Score',
			'subject_marks_needed' => 'Subject Marks Needed',
			'no_of_subjects' => 'No Of Subjects',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_exam_details_id',$this->entrance_exam_details_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('popular',$this->popular,true);
		$criteria->compare('rank',$this->rank,true);
		$criteria->compare('percentile',$this->percentile,true);
		$criteria->compare('total_score',$this->total_score,true);
		$criteria->compare('subject_marks_needed',$this->subject_marks_needed,true);
		$criteria->compare('no_of_subjects',$this->no_of_subjects);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}