<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEmailerKnowledgeTemplate is autogenerate by UniModel generator
 *
 * This is the model class for table "emailer_knowledge_template".
 *
 * The followings are the available columns in table 'emailer_knowledge_template':
 * @property integer $emailer_knowledge_template_id
 * @property string $template_key
 * @property string $template_subject
 * @property string $template_text
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property EmailerKnowledgeTemplateMap[] $emailerKnowledgeTemplateMaps
 */
class BaseEmailerKnowledgeTemplate extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EmailerKnowledgeTemplate the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'emailer_knowledge_template';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('template_key, template_subject, template_text, added_on', 'required'),
			array('template_key', 'length', 'max'=>50),
			array('template_subject', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('emailer_knowledge_template_id, template_key, template_subject, template_text, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'emailerKnowledgeTemplateMaps' => array(self::HAS_MANY, 'EmailerKnowledgeTemplateMap', 'emailer_knowledge_template_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'emailer_knowledge_template_id' => 'Emailer Knowledge Template',
			'template_key' => 'Template Key',
			'template_subject' => 'Template Subject',
			'template_text' => 'Template Text',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('emailer_knowledge_template_id',$this->emailer_knowledge_template_id);
		$criteria->compare('template_key',$this->template_key,true);
		$criteria->compare('template_subject',$this->template_subject,true);
		$criteria->compare('template_text',$this->template_text,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}