<?php

/**
 * This is the model class for table "email_tracker".
 *
 * The followings are the available columns in table 'email_tracker':
 * @property integer $email_tracker_id
 * @property string $user_ref_id
 * @property string $email_tracker_type_ref_id
 * @property string $sent_on
 * @property string $opened_on
 * @property integer $mail_type
 * @property string $response
 * @property string $responded_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseEmailTracker extends CActiveRecord
{
    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return BaseEmailTracker the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'email_tracker';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('sent_on', 'required'),
            array('email_tracker_type_ref_id', 'numerical', 'integerOnly'=>true),
            array('user_ref_id, email_message_ref_id', 'length', 'max'=>10),
            array('response', 'length', 'max'=>1),
            array('opened_on, responded_on', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('email_tracker_id, user_ref_id, email_tracker_type_ref_id, email_message_ref_id, sent_on, opened_on, response, responded_on', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'emailMessageRef' => array(self::BELONGS_TO, 'EmailMessage', 'email_message_ref_id'),
            'emailTrackerTypeRef' => array(self::BELONGS_TO, 'EmailTrackerType', 'email_tracker_type_ref_id'),
            'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'email_tracker_id' => 'Email Tracker',
            'user_ref_id' => 'User Ref',
            'email_tracker_type_ref_id' => 'Email Tracker Type Ref',
            'email_message_ref_id' => 'Email Message Ref',
            'sent_on' => 'Sent On',
            'opened_on' => 'Opened On',
            'response' => 'Response',
            'responded_on' => 'Responded On',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('email_tracker_id',$this->email_tracker_id);
        $criteria->compare('user_ref_id',$this->user_ref_id,true);
        $criteria->compare('email_tracker_type_ref_id',$this->email_tracker_type_ref_id);
        $criteria->compare('email_message_ref_id',$this->email_message_ref_id,true);
        $criteria->compare('sent_on',$this->sent_on,true);
        $criteria->compare('opened_on',$this->opened_on,true);
        $criteria->compare('response',$this->response,true);
        $criteria->compare('responded_on',$this->responded_on,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }
}