<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiUserEoiMessage is autogenerate by UniModel generator
 *
 * This is the model class for table "di_user_eoi_message".
 *
 * The followings are the available columns in table 'di_user_eoi_message':
 * @property string $di_user_eoi_message_id
 * @property string $di_user_eoi_log_ref_id
 * @property integer $sender_type
 * @property string $di_user_eoi_message_ref_id
 * @property string $message
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property DiUserEoiMessage $diUserEoiMessageRef
 * @property DiUserEoiMessage[] $diUserEoiMessages
 * @property LoginMaster $addedBy
 * @property DiUserEoiLog $diUserEoiLogRef
 * @property SenderRecipientType $senderType
 */
class BaseDiUserEoiMessage extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiUserEoiMessage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_user_eoi_message';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sender_type, message, added_on, added_by', 'required'),
			array('sender_type', 'numerical', 'integerOnly'=>true),
			array('di_user_eoi_log_ref_id, di_user_eoi_message_ref_id, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_eoi_message_id, di_user_eoi_log_ref_id, sender_type, di_user_eoi_message_ref_id, message, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserEoiMessageRef' => array(self::BELONGS_TO, 'DiUserEoiMessage', 'di_user_eoi_message_ref_id'),
			'diUserEoiMessages' => array(self::HAS_MANY, 'DiUserEoiMessage', 'di_user_eoi_message_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'diUserEoiLogRef' => array(self::BELONGS_TO, 'DiUserEoiLog', 'di_user_eoi_log_ref_id'),
			'senderType' => array(self::BELONGS_TO, 'SenderRecipientType', 'sender_type'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_user_eoi_message_id' => 'Di User Eoi Message',
			'di_user_eoi_log_ref_id' => 'Di User Eoi Log Ref',
			'sender_type' => 'Sender Type',
			'di_user_eoi_message_ref_id' => 'Di User Eoi Message Ref',
			'message' => 'Message',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_user_eoi_message_id',$this->di_user_eoi_message_id,true);
		$criteria->compare('di_user_eoi_log_ref_id',$this->di_user_eoi_log_ref_id,true);
		$criteria->compare('sender_type',$this->sender_type);
		$criteria->compare('di_user_eoi_message_ref_id',$this->di_user_eoi_message_ref_id,true);
		$criteria->compare('message',$this->message,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}