<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiInvoiceTransaction is autogenerate by UniModel generator
 *
 * This is the model class for table "di_invoice_transaction".
 *
 * The followings are the available columns in table 'di_invoice_transaction':
 * @property string $di_invoice_transaction_id
 * @property string $di_invoice_ref_id
 * @property integer $di_ref_id
 * @property integer $di_user_ref_id
 * @property string $user_ref_id
 * @property integer $campaign_ref_id
 * @property integer $banner_campaign_ref_id
 * @property integer $school_visit_product_ref_id
 * @property integer $webinar_product_ref_id
 * @property string $service_type
 * @property integer $is_free
 * @property string $amount
 * @property string $transaction_date
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property DiWebinarProduct $webinarProductRef
 * @property DiSchoolVisitProduct $schoolVisitProductRef
 * @property DiInvoice $diInvoiceRef
 * @property Di $diRef
 * @property DiUser $diUserRef
 * @property TblUserMaster $userRef
 * @property DiBannerCampaign $bannerCampaignRef
 * @property DiEmailCampaign $campaignRef
 */
class BaseDiInvoiceTransaction extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiInvoiceTransaction the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_invoice_transaction';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_invoice_ref_id, di_ref_id, amount, transaction_date, added_on', 'required'),
			array('di_ref_id, di_user_ref_id, campaign_ref_id, banner_campaign_ref_id, school_visit_product_ref_id, webinar_product_ref_id, is_free', 'numerical', 'integerOnly'=>true),
			array('di_invoice_ref_id, user_ref_id, amount', 'length', 'max'=>10),
			array('service_type', 'length', 'max'=>22),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_invoice_transaction_id, di_invoice_ref_id, di_ref_id, di_user_ref_id, user_ref_id, campaign_ref_id, banner_campaign_ref_id, school_visit_product_ref_id, webinar_product_ref_id, service_type, is_free, amount, transaction_date, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'webinarProductRef' => array(self::BELONGS_TO, 'DiWebinarProduct', 'webinar_product_ref_id'),
			'schoolVisitProductRef' => array(self::BELONGS_TO, 'DiSchoolVisitProduct', 'school_visit_product_ref_id'),
			'diInvoiceRef' => array(self::BELONGS_TO, 'DiInvoice', 'di_invoice_ref_id'),
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'diUserRef' => array(self::BELONGS_TO, 'DiUser', 'di_user_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'bannerCampaignRef' => array(self::BELONGS_TO, 'DiBannerCampaign', 'banner_campaign_ref_id'),
			'campaignRef' => array(self::BELONGS_TO, 'DiEmailCampaign', 'campaign_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_invoice_transaction_id' => 'Di Invoice Transaction',
			'di_invoice_ref_id' => 'Di Invoice Ref',
			'di_ref_id' => 'Di Ref',
			'di_user_ref_id' => 'Di User Ref',
			'user_ref_id' => 'User Ref',
			'campaign_ref_id' => 'Campaign Ref',
			'banner_campaign_ref_id' => 'Banner Campaign Ref',
			'school_visit_product_ref_id' => 'School Visit Product Ref',
			'webinar_product_ref_id' => 'Webinar Product Ref',
			'service_type' => 'Service Type',
			'is_free' => 'Is Free',
			'amount' => 'Amount',
			'transaction_date' => 'Transaction Date',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_invoice_transaction_id',$this->di_invoice_transaction_id,true);
		$criteria->compare('di_invoice_ref_id',$this->di_invoice_ref_id,true);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('di_user_ref_id',$this->di_user_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('campaign_ref_id',$this->campaign_ref_id);
		$criteria->compare('banner_campaign_ref_id',$this->banner_campaign_ref_id);
		$criteria->compare('school_visit_product_ref_id',$this->school_visit_product_ref_id);
		$criteria->compare('webinar_product_ref_id',$this->webinar_product_ref_id);
		$criteria->compare('service_type',$this->service_type,true);
		$criteria->compare('is_free',$this->is_free);
		$criteria->compare('amount',$this->amount,true);
		$criteria->compare('transaction_date',$this->transaction_date,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}