<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseUserEntranceExam');

class UserEntranceExam extends BaseUserEntranceExam
{
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('user_ref_id, entrance_exam_ref_id, exam_status, overall_marks, added_by', 'required'),
            array('entrance_exam_ref_id, exam_day, exam_month, exam_year', 'numerical', 'integerOnly'=>true),
            array('user_ref_id, added_by, modified_by', 'length', 'max'=>10),
            array('exam_status', 'length', 'max'=>9),
            array('overall_marks', 'length', 'max'=>8),
            array('shortlist_status, get_alert', 'length', 'max'=>1),
            array('modified_on', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('user_entrance_exam_id, user_ref_id, entrance_exam_ref_id, exam_status, exam_day, exam_month, exam_year, overall_marks, shortlist_status, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
        );
    }

    public function behaviors(){
        return array(
            'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
        );
    }        

    public function StudentActivityFeedLoggableAttributes(){
        return array(
            'entrance_exam_ref_id,exam_status,exam_year,overall_marks' => 'user_function_entrance_exam',
        );
    }
    
    public function user_function_entrance_exam($attribute = null){
        if($this->exam_year){
            return 'entrance_exam';
        }else{
            return 'test_shortlisted';
        }
    }
    
    public function fetchUserEnteredExam($student_id, $attribute, $attribute_value) {
        if ($student_id && $attribute_value && $attribute) {
            $data = self::model()->find(' user_ref_id = '.$student_id." and ".$attribute." = '".$attribute_value."' ");
            return $data->user_entrance_exam_id;
        }
    }

    public function  fetchUserExams($student_id) {
        if ($student_id) {
            $data = self::model()->findAll(' user_ref_id = '.$student_id);
            return $data;
        }
    }


    protected function beforeSave(){
        if(parent::beforeSave()){
            if($this->isNewRecord){
                $this->added_on = date('Y-m-d H:i:s');
            }else{
                $this->modified_on = date('Y-m-d H:i:s');
            }
            return true;

        }
        return false;
    }

    public static function deleteUserStandardExams($userId=0, $standardExamId=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->addCondition("user_ref_id = '".$userId."'", "AND");
        if($standardExamId > 0){
            $cdbCriteria->addCondition("entrance_exam_ref_id = '".$standardExamId."'", "AND");
        }
        $result = self::model()->findAll();
        foreach($result as $userEntranceExam){
            UserEntranceExamModule::model()->deleteAll(array("condition" => "user_entrance_exam_ref_id = '".$userEntranceExam->attributes['user_entrance_exam_id']."'"));
            self::model()->deleteByPk($userEntranceExam->attributes['user_entrance_exam_id']);
        }
    }

    public static function  getUserExamsInfo($userId) {

        if ($userId) {
            $data = self::model()->with('userEntranceExamModules')->findAll(' user_ref_id = '.$userId);
            return $data;
        }
    }

    public static function deleteUserAllExamData($userId){
        $sqlForDeleteModule = 'DELETE  user_entrance_exam_module 
                                FROM user_entrance_exam INNER JOIN  user_entrance_exam_module ON user_entrance_exam_ref_id=user_entrance_exam_id 
                                WHERE user_ref_id = ' . $userId;
        $command = Yii::app()->db->createCommand($sqlForDeleteModule);
        $resultCount = $command->execute();
        $sqlForDeleteTest = 'DELETE  user_entrance_exam 
                            FROM user_entrance_exam 
                            WHERE user_ref_id = ' . $userId;
        $command = Yii::app()->db->createCommand($sqlForDeleteTest);
        $rowCount = $command->execute();
        return $rowCount;
    }

    public static function deleteUserExamData($id){
        $resultCountChild = UserEntranceExamModule::model()->deleteAll('user_entrance_exam_ref_id='.$id);
        $resultCount = self::model()->deleteByPk($id);
        return $resultCount;
    }

    public function  fetchUserExamsPdf($student_id) {
        if ($student_id) {
            $criteria = new CDbCriteria();
            $criteria->select = 'exam_status,exam_year,overall_marks';
                $criteria->with = 'entranceExamRef';
            $criteria->addCondition("user_ref_id = '".$student_id."'", "AND");
            //$criteria->addCondition("exam_status = 'Completed'", "AND");
            $data = self::model()->findAll($criteria);
            return $data;
        }
    }

    public static function getUserEntranceExamDetails($userId=0){
        $cdbCriteria = new CDbCriteria();
        $cdbCriteria->condition = "user_ref_id = '".$userId."' AND exam_status = 'Completed'";
        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getUserFullEntranceExamList($userId=0,$offset=0,$limit=0){
        $sql='SELECT uee.entrance_exam_ref_id,ee.entrance_full_name,uee.exam_status
              FROM user_entrance_exam uee
              LEFT JOIN entrance_exam ee
              ON uee.entrance_exam_ref_id=ee.entrance_id
              WHERE uee.user_ref_id='.$userId.' AND shortlist_status = 1 order by ee.entrance_full_name LIMIT '.$offset.','.$limit.'';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        return $data;
    }

    public static function getUserFullEntranceExamListByAlert($userId=0,$offset=0,$limit=0, $alert = false){
        $sub_sql = ($alert != false) ? $sub_sql = " AND uee.get_alert = 1 " : '' ;

        $sql='SELECT uee.entrance_exam_ref_id,ee.entrance_full_name,uee.exam_status
              FROM user_entrance_exam uee
              INNER JOIN entrance_exam ee
              ON uee.entrance_exam_ref_id=ee.entrance_id
              WHERE uee.user_ref_id='.$userId.' AND (uee.exam_status="Planned" OR uee.exam_status=" ") '.$sub_sql.' order by ee.entrance_full_name LIMIT '.$offset.','.$limit.'';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        return $data;
    }

    public function getCountOfStudenShortListedTests($userId=0){
        $sql='SELECT COUNT(ee.entrance_full_name)
              FROM user_entrance_exam uee
              JOIN entrance_exam ee ON uee.entrance_exam_ref_id=ee.entrance_id AND ee.is_active = 1
              WHERE uee.user_ref_id='.$userId.' AND (uee.exam_status="Planned" OR uee.exam_status=" ") AND shortlist_status = "1"';
        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        return $data;

    }

    public function getListByCountryAndDepartment($userid=0,$countryId=0,$departmentId=0,$limit=0,$offset=0){
        $sql='   SELECT eead.`entrance_exam_ref_id`,uee.user_ref_id,ee.entrance_full_name,eead.main_department_ref_id,eeal.country_ref_id,uee.exam_status
                FROM user_entrance_exam uee
                JOIN `student_preferred_country` spc ON uee.user_ref_id=spc.user_ref_id
                JOIN `student_preferred_department` spd ON uee.user_ref_id=spd.user_ref_id
                JOIN `entrance_exam` ee ON uee.entrance_exam_ref_id=ee.entrance_id
                JOIN `entrance_exam_applicable_department` eead ON eead.entrance_exam_ref_id=ee.entrance_id
                JOIN `entrance_exam_applicable_location` eeal ON eead.entrance_exam_ref_id=eeal.entrance_exam_ref_id
                JOIN lookup_department ld ON ld.department_id = eead.main_department_ref_id
                WHERE eead.main_department_ref_id='.$departmentId.' AND uee.user_ref_id='.$userid.' AND eeal.country_ref_id='.$countryId.'  AND (uee.exam_status="Planned" OR uee.exam_status=" ") GROUP BY eead.`entrance_exam_ref_id` order by ee.entrance_full_name LIMIT '.$offset.','.$limit.'';


        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();

        return $data;
    }


    public function getListByCountryAndDepartmentAndUniversity($userid=0,$countryId=0,$departmentId=0,$universityId=0,$offset=0,$limit=0){
        $sql=' SELECT DISTINCT eead.`entrance_exam_ref_id`,uee.user_ref_id,ee.entrance_full_name,
                eead.main_department_ref_id,eeal.country_ref_id,ssu.uni_ref_id,tum.uni_name,uee.exam_status
                FROM user_entrance_exam uee
                JOIN `student_preferred_country` spc ON uee.user_ref_id=spc.user_ref_id
                JOIN `student_preferred_department` spd ON uee.user_ref_id=spd.user_ref_id
                JOIN `entrance_exam` ee ON uee.entrance_exam_ref_id=ee.entrance_id
                JOIN student_shortlist_university ssu ON ssu.user_ref_id=uee.user_ref_id
                JOIN tbl_university_master tum ON tum.uni_id=ssu.uni_ref_id
                JOIN tbl_uni_courses tc ON tc.uni_ref_id=ssu.uni_ref_id
                JOIN lookup_department ld ON ld.department_id = tc.department_ref_id
                JOIN lookup_department ldl ON ld.main_dept_id = ldl.department_id
                JOIN `entrance_exam_applicable_department` eead ON eead.entrance_exam_ref_id=ee.entrance_id
                JOIN `entrance_exam_applicable_location` eeal ON eead.entrance_exam_ref_id=eeal.entrance_exam_ref_id
                JOIN uni_course_test uct ON uct.uni_ref_id = ssu.uni_ref_id  AND uct.entrance_ref_id = uee.entrance_exam_ref_id
                WHERE eead.main_department_ref_id='.$departmentId.' AND uee.user_ref_id='.$userid.' AND eeal.country_ref_id='.$countryId.' AND ssu.uni_ref_id='.$universityId.'  AND (uee.exam_status="Planned" OR uee.exam_status=" ")
                GROUP BY eead.`entrance_exam_ref_id` LIMIT '.$offset.','.$limit.'';



        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        return $data;
    }

    public static function getUserexams($id){
      $sql = '  SELECT t.user_ref_id,t.entrance_exam_ref_id,t.exam_status,e.entrance_short_name
                FROM user_entrance_exam t
                JOIN entrance_exam e ON e.entrance_id = t.entrance_exam_ref_id
                WHERE user_ref_id = '.$id;

        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        $data = CHtml::listData($data,'entrance_exam_ref_id','entrance_short_name');
        return $data;
    }

    public static function getUserInternationexams($id){
        $sql = '  SELECT t.user_ref_id,t.entrance_exam_ref_id,t.exam_status,e.entrance_short_name
                FROM user_entrance_exam t
                JOIN entrance_exam e ON e.entrance_id = t.entrance_exam_ref_id
                WHERE type_of_exam = "International" AND user_ref_id = '.$id;

        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        $data = CHtml::listData($data,'entrance_exam_ref_id','entrance_short_name');
        return $data;
    }

    public static function getUserotherexams($id){
        $sql = '  SELECT t.user_ref_id,t.entrance_exam_ref_id,t.exam_status,e.entrance_short_name
                FROM user_entrance_exam t
                JOIN entrance_exam e ON e.entrance_id = t.entrance_exam_ref_id
                WHERE type_of_exam != "International" AND user_ref_id = '.$id;

        $command =Yii::app()->db->createCommand($sql);
        $data =$command->queryAll();
        $data = CHtml::listData($data,'entrance_exam_ref_id','entrance_short_name');
        return $data;
    }

    public static function getUserTest($searchTerm, $user_id) {

        $sql = "SELECT t.user_ref_id, t.entrance_exam_ref_id, t.exam_status, e.entrance_short_name
                FROM user_entrance_exam t
                JOIN entrance_exam e ON e.entrance_id = t.entrance_exam_ref_id
                WHERE user_ref_id = '".$user_id."' AND e.entrance_short_name LIKE '%".$searchTerm."%' ";

        $command =Yii::app()->db->createCommand($sql);
        return $command->queryAll();

    }
}