<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseStudentPreferredSubject');

class StudentPreferredSubject extends BaseStudentPreferredSubject
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
    public function getStudentPreferredSubjects($user_id=0)
    {
        $criteria = new CDbCriteria();
        $criteria->select = 'student_subject_ref_id, preference';
        $criteria->with = array("studentSubjectRef", array('select' => 'subject_name'));
        $criteria->addCondition("user_ref_id = '".$user_id."' AND type = 'Like' ", "AND");
        //$criteria->addCondition("not_sure=0", "AND");
        $criteria->order = 'preference';
        $data = self::model()->findAll($criteria);
        return $data;
    }  
    
    public function deleteSubjectPreferenceByUserId($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '" . $userId . "' AND type = 'Like'";
        self::model()->deleteAll($criteria);
    }
    
    public function insertSubjectPreferenceByUserId($userId, $subjectId, $preferenceOrder){
        $obj = new StudentPreferredSubject();
        $obj->{user_ref_id} = $userId;
        $obj->{student_subject_ref_id} = $subjectId;
        $obj->{preference} = $preferenceOrder;
        $obj->{type} = 'Like';
        $obj->save();
    }

    public function insertWeakSubjectPreferenceByUserId($userId, $subjectId, $preferenceOrder){
        $obj = new StudentPreferredSubject();
        $obj->{user_ref_id} = $userId;
        $obj->{student_subject_ref_id} = $subjectId;
        $obj->{preference} = $preferenceOrder;
        $obj->{type} = 'Dislike';
        $obj->save();
    }

    public function deleteWeakSubjectPreferenceByUserId($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '" . $userId . "' AND type = 'Dislike'";
        self::model()->deleteAll($criteria);
    }

    public function getStudentPreferredWeakSubjects($user_id=0)
    {
        $criteria = new CDbCriteria();
        $criteria->select = 'student_subject_ref_id, preference';
        $criteria->with = array("studentSubjectRef", array('select' => 'subject_name'));
        $criteria->addCondition("user_ref_id = '".$user_id."' AND type = 'Dislike' ", "AND");
        $criteria->order = 'preference';
        $data = self::model()->findAll($criteria);
        return $data;
    }
}