<?php

/**
 * This is the model class for table "student_preferred_duration".
 *
 * The followings are the available columns in table 'student_preferred_duration':
 * @property string $preferred_duration_id
 * @property string $user_ref_id
 * @property integer $duration_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupDuration $durationRef
 * @property TblUserMaster $userRef
 */
class StudentPreferredDuration extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredDuration the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_duration';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, duration_ref_id', 'required'),
			array('duration_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('preferred_duration_id, user_ref_id, duration_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'durationRef' => array(self::BELONGS_TO, 'LookupDuration', 'duration_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'preferred_duration_id' => 'Preferred Duration',
			'user_ref_id' => 'User Ref',
			'duration_ref_id' => 'Duration Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('preferred_duration_id',$this->preferred_duration_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('duration_ref_id',$this->duration_ref_id);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
    public static function getStudentStudyDuration($userId){
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$userId."'";
        $criteria->order = "duration_ref_id desc";
        $criteria->limit = 2;
        $studentPreferredDuration = self::model()->findAll($criteria);
        return $studentPreferredDuration;
    }
    
    public function deleteStudyDurationByUserId($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '" . $userId . "'";
        self::model()->deleteAll($criteria);
    }
    
    public function insertStudyDurationByUserId($userId, $studyDuration) {
        $obj = new StudentPreferredDuration();
        $obj->{user_ref_id} = $userId;
        $obj->{duration_ref_id} = $studyDuration;
        $obj->save();
    }

}