<link rel="stylesheet" type="text/css" href="/app/themes/new_grid_theme/views/layouts/css/skelton.css" />
<link rel="stylesheet" type="text/css" href="/app/themes/new_grid_theme/views/layouts/css/component.css" />

<style>
    .container{margin: 0px !important; }
    .italic{font-weight: normal; line-height: 18px; font-style: italic;}
    .absolute{background-color: rgb(255, 255, 255); padding: 0px 20px; position: absolute; left: 33%; z-index: 0; top: 87px;}
    form { margin: 0px; }
    .error select{border: 1px solid #fc8486 !important}
    body{background: none repeat scroll 0 0 #ffffff !important;}
</style>
<div class="row multi_line no-gutter white color-dark-gray container no-border">
    <div class="titles border-bottom row multi_line">
        <h3 class="uppercase center line-height">LOGIN TO UNLOCK YOUR CAREER PLAN</h3>
        <div class="center gutter20">Get your personalized career and college guidance program</div>
    </div>
    <div class="clearfix">
        <div class="clearfix relative">
            <?php
            $form = $this->beginWidget('CActiveForm', array(
                'id' => 'login-form',
                'enableClientValidation' => false,
                'enableAjaxValidation' => true,
                'clientOptions' => array(
                    'validateOnSubmit' => true,
                    'afterValidate'=>'js:afterValidate',
                ),
            ));
            ?>
            <div class="row multi_line visible">
                <div class="row visible relative clearfix">
                    <label class="left small-right">Do you already have an account on Univariety?</label>
                    <select id="uni_account_status" class="right" style="width:125px;">
                        <option value="yes">Yes</option>
                        <option value="no">No</option>
                    </select>
                </div>	
                
                <div class="row gutter_vertical relative visible">
                    <?php
                    echo $form->textField($model, 'username', array('size' => 50, 'placeholder' => 'Email', 'class' => 'full-width'));
                    echo $form->error($model, 'username', array("class" => "errorMessage popup right"));
                    ?>
                </div>	
                
                <div class="row gutter_vertical relative visible">
                    <?php
                    $model->pass_word = '';
                    echo $form->passwordField($model, 'pass_word', array('size' => 50, 'placeholder' => 'Password', 'class' => 'full-width'));
                    echo $form->error($model, 'pass_word', array("class" => "errorMessage popup right"));
                    ?>
                </div>
                
                <div id="carrer_plan_options" style="display:none;">
                    <div class="row gutter_vertical visible relative">
                        <?php 
                            echo CHtml::textField('career_plan_code', '', array('placeholder' => 'Enter your unique number (from scratch card)', 'class' => 'full-width'));
                        ?>
                        <div style="display:none" id="career_plan_code_em_" class="errorMessage popup right">
                            <div class="holder">Please Enter your unique code</div>
                        </div>
                    </div>

                    <div class="gutter_vertical visible relative">
                        <h5>Select your band</h5>
                    <?php foreach(LookupBand::model()->findAll(array('order' => 'band_order')) as $CarrerBand): ?>
                        <?php 
                            $band_slug = strtolower(Inflector::slug($CarrerBand->band_name, '_'));
                            $band_colors = explode('_and_', $band_slug);
                            $band_names = array();
                            foreach($band_colors as $color){
                                $band_names[] = sprintf('<span style="color:%s;">%s</span>', $color, ucwords($color));
                            }
                        ?>
                        <input class="carrer_bands" type="radio" name="career_band_name" value="<?php echo $CarrerBand->band_id; ?>" id="<?php echo 'career_band_'.$band_slug; ?>" /> 
                        <label for="career_band_<?php echo $band_slug; ?>" class="small_gutter_r carrer_bands"><?php echo implode(' and ', $band_names) ?></label>
                    <?php endforeach; ?>
                        <div style="display:none" id="career_band_name_em_" class="errorMessage popup right">
                            <div class="holder">Please select your band</div>
                        </div>
                    </div>
                </div>
                
                <div class="row center">
                    <?php echo CHtml::submitButton('Login', array('class' => 'button-blue tny full')); ?>
                </div>
            </div>
            <?php $this->endWidget(); ?>
        </div>
    </div>		
</div>
<script>
    
    $("body").on('focus', 'input, select', function () {
        if ($(this).is(':radio')) {
            $(this).parent().find('div.errorMessage').hide('slow');
            $(this).parent().removeClass('error');
        } else {
            $(this).next('div.errorMessage').hide('slow');
            $(this).parent().removeClass('error');
        }
    });
    
    $(function () {
        parent.$.fn.colorbox.resize({width: 580, height: 370});
    });
    
    $('body').on('focus', '#LoginMaster_pass_word', function(){
        get_bands();
    });
    
    $('body').on('change', '#LoginMaster_username', function(){
        get_bands();
    });
    
    function get_bands(){
        var username = $('#LoginMaster_username').val();
        if(username){
            $.ajax({
                url : '<?php echo $this->createUrl('getUserBandInfo'); ?>',
                dataType: 'json',
                type: 'post',
                data: {'username':username},
                beforeSend: function(){$('.carrer_bands').show(); $('#career_plan_code').removeAttr('readonly'); $('#career_plan_code').val(''); $('.carrer_bands').prop('disabled', false); $('input[name=career_band_name]').prop('checked', false);},
                success: function(data){
                    $('input[name=career_band_name]').prop('checked', false);
                    if(data.user_id){
                        parent.$.fn.colorbox.resize({width: 580, height: 490});
                        $('#carrer_plan_options').show();
                        $('.carrer_bands').hide();
                        if(data.present_class == 9 || data.present_class == 10){
                            $('#career_band_orange').show();
                            $('#career_band_orange').next('label').show();
                            $('#career_band_purple').show();
                            $('#career_band_purple').next('label').show();
                            $('#career_band_blue').show();
                            $('#career_band_blue').next('label').show();
                        }else{
                            $('.carrer_bands').show();
                        }
                        
                        if(data.band_id){
                            $('#career_plan_code').val(data.coupon_code).attr('readonly', 'readonly');
                            $('#'+data.band_name).prop('checked', true);
                            $('.carrer_bands').prop('disabled', true);
                        }
                    }
                }
            });
            
        }else{
            $('#carrer_plan_options').hide();
            parent.$.fn.colorbox.resize({width: 580, height: 370});
        }
        
    }
    
    function afterValidate(form,data,hasError){
        var return_val = true;
        var career_plan_code = $('#career_plan_code').val();
        var career_band_name = $('input[name=career_band_name]:checked').val()
        
        if(career_plan_code || career_band_name){
            if(!career_plan_code){
                $('#career_plan_code_em_').parent().addClass('error');
                $('#career_plan_code_em_').show();
                return false;
            }
            if(!career_band_name){
                $('#career_band_name_em_').parent().addClass('error');
                $('#career_band_name_em_').show();
                return false;
            }
        }
        
        for (var error_id in data){
            $('#'+error_id).parent().addClass('error');
            $('#'+error_id+'_em_').html(data[error_id][0]);
            $('#'+error_id+'_em_').show();
            return_val = false;
        }
        return return_val;
    }
    
    $('body').on('change', '#uni_account_status', function(){
        if($(this).val() == 'no') window.location = '/app/student/createProfile/PopupSignUp?carrer-plan=yes';
    });
    
</script>