<?php $this->pageTitle=Yii::app()->name . ' - Account Settings'; ?>
<section id="section1" class="section">
    <style>
        .error {
            border: medium none !important;
        }
        .error input, .error select, .error textarea {
            border: 1px solid #FC8383 !important;
        }
    </style>
    <div class="div-inner-gutter-space">
        <div class="row multi_line small-gutter border-bottom gutter_vertical relative">
            <h2 class="uppercase">Account Settings</h2>
        </div>
        <div class="row">
            <div class="row multi_line gray gutter-left-35 gutter_vertical" id="email">
                <div class="row visible clearfix " id="email_list">
                    <div class="grid_3 left">Primary Email</div>
                    <div class="left grid_7 relative" id="primaryEmail">
                        <i class="fa fa-envelope-o small_gutter_r"></i> <?php echo $user->username; ?>
                    </div>
                </div>
                <?php if($alternate->student_alternate_email_id){?>
                    <div class="row visible clearfix" id="email1">
                        <div class="grid_3 left">&nbsp;</div>
                        <div class="left grid_4 relative" id="alterEmail">
                            <i class="fa fa-envelope-o small_gutter_r"></i><?php echo $alternate->email_id; ?>
                        </div>
                        <div class="grid_3 right" id="emailAction" style="display: block">

                            <?php if ($alternate->is_confirmed){?>
                                <a href="javascript:void(0)" class="left" onclick="setPrimary(<?php echo $alternate->student_alternate_email_id;?>)"><i class="fa fa-level-up color-green"></i> <span class="small color-gray">Set as primary</span></a>
                            <?php } ?>
                            <a href="javascript:void(0)" onclick="removeEmail(<?php echo $alternate->student_alternate_email_id;?>)"><i class="fa  fa-times color-pink"></i> <span class="small color-gray">Remove</span></a>
                        </div>
                    </div>
                <?php } else{
                        $form = $this->beginWidget('CActiveForm',array(
                            'id' => 'add-email',
                            'enableAjaxValidation' => true,
                            'enableClientValidation' => false,
                            'clientOptions' => array( 'validateOnSubmit' => true),
                        ));

                        ?>
                        <div class="row multi_line no-gutter visible clearfix gutter_vertical">
                            <div class="grid_3 left">&nbsp;</div>
                            <div class="left grid_7 relative">
                                <div id="addMoreEmail" style="display: none">
                                    <?php
                                    echo $form->textField($model,'email_id',array('class' => 'grid_5 input  small_gutter_r', 'size'=>50,'placeholder' => 'Enter Email Address'));
                                    echo $form->error($model,'email_id',array("class" => "errorMessage popup"));
                                    ?>
                                    <?php
                                    echo $form->hiddenField($model,'login_ref_id',array('type' => 'hidden', 'value'=> $userId));
                                    echo $form->hiddenField($model,'added_by',array('type' => 'hidden','value'=> $userId));
                                    ?>
                                    <button type="submit" class="button-blue tny" >Add</button>
                                </div>
                                <a href="javascript:void(0)" class="clearfix" onclick="$(this).hide();$('#addMoreEmail').show();" id="more"><i class="fa fa-plus-square small_gutter_r"></i> Add another email address</a>

                            </div>
                        </div>
                        <?php $this->endWidget();
                        }?>
            </div>


            <div class="row multi_line gray gutter-left-35 gutter_vertical visible clearfix" >
                <div class="row visible clearfix">
                    <div class="grid_3 left">Password</div>
                    <div class="left grid_7 relative visible clearfix">
                        <?php
                        $form = $this->beginWidget('CActiveForm',array(
                            'id'=> 'changePassword',
                            'enableAjaxValidation' => true,
                            'enableClientValidation' => true,
                            'clientOptions' => array( 'validateOnSubmit' => true),
                        ));
                        ?>
                        <div id="oldNewPassword" style="display: none; overflow: visible !important">
                            <div class="row relative gutter_vertical grid_5 visible ">
                                <?php
                                    echo $form->passwordField($modelChangePassword,'pass_word',array('size'=>50,'placeholder'=>'Old Password','class'=>'grid_5 input'));
                                    echo $form->error($modelChangePassword,'pass_word', array('class'=>'errorMessage popup'));
                                ?>
                            </div>
                            <div class="row relative gutter_vertical grid_5 visible">
                                <?php
                                    echo $form->passwordField($modelChangePassword,'newPassword',array('size'=>50,'placeholder'=>'New Password','class'=>'grid_5 input'));
                                    echo $form->error($modelChangePassword,'newPassword', array('class'=>'errorMessage popup'));
                                ?>
                            </div>
                            <div class="row relative gutter_vertical grid_5 visible">
                                <?php
                                    echo $form->passwordField($modelChangePassword,'newPasswordRepeat',array('size'=>50,'placeholder'=>'Confirm New Password','class'=>'grid_5 input'));
                                    echo $form->error($modelChangePassword,'newPasswordRepeat', array('class'=>'errorMessage popup'));
                                ?>

                            </div>
                            <div class="row gutter_vertical">
                                <button type="submit" class="button-blue tny">Save</button>
                                <button type="button" class="button-default tny" onclick="closePassword();$('#pass').show(); ">Cancel</button>
                            </div>
                        </div>
                        <?php $this->endWidget();?>
                        <a href="javascript:void(0);" onclick=" $(this).hide();closePassword()" id="pass">Change Password</a>
                    </div>
                </div>
            </div>
            
            <div class="row multi_line gray gutter-left-35 gutter_vertical" >
                <div id="phone">
                <div class="row visible clearfix">

                    <div class="grid_3 left">
                        <a name='primary_contact'>&nbsp;</a>
                        Primary Contact
                    </div>
                    <div class="left grid_7 relative" id="primaryNumber">
                        <i class="fa fa-mobile fa-lg small_gutter_r"></i> <?php echo '+'.$primary_numbers->country_code.' '.$primary_numbers->number;  ?>
                    </div>
                    <?php  ?>
                </div>
                <?php foreach($secondary_numbers as $secondary_number){ ?>
                <div class="row visible clearfix" id="alt_<?php echo $secondary_number->student_contact_number_id; ?>">
                    <div class="grid_3 left">&nbsp;</div>
                    <div class="left grid_4 relative" id="secondary_<?php echo $secondary_number->student_contact_number_id; ?>">
                        <i class="fa fa-mobile fa-lg small_gutter_r"></i> <?php echo '+'.$secondary_number->country_code.' '.$secondary_number->number;  ?>
                    </div>
                    <div class="grid_3 right">
                        <a href="javascript:void(0)" class="left" onclick="setPhonePrimary(<?php echo $secondary_number->student_contact_number_id; ?>)" ><i class="fa fa-level-up color-green"></i> <span class="small color-gray">Set as primary</span></a>
                        <a href="javascript:void(0)" onclick="removeNumber(<?php echo $secondary_number->student_contact_number_id; ?>)"><i class="fa  fa-times color-pink"></i> <span class="small color-gray">Remove</span></a>
                    </div>
                </div>
                <?php } ?>
                <?php
                    $form = $this->beginWidget('CActiveForm',array(
                        'id' => 'addPhoneNumber',
                        'enableAjaxValidation' => true,
                        'enableClientValidation' => false,
                        'clientOptions' => array('validateOnSubmit' => true)
                    ));
                    $display = 'none';
                    if($modelContactNumber->number  || $modelContactNumber->hasErrors()) $display = 'block';
                ?>
                <div id="model_contact_number" class="row visible clearfix gutter_vertical" style="display: <?php echo $display; ?>">
                    <div class="grid_3 left">&nbsp;</div>
                    <div class="left grid_7 relative">
                        <div class="grid_2 pull small_gutter_r">
                            <?php
                                $modelContactNumber->country_code = '100-91';
                                echo $form->dropDownList($modelContactNumber,'country_code',$countryCodes,array('class'=>'grid_2 select'));
                                echo $form->error($modelContactNumber,'country_code',array('class' =>'errorMessage popup'));
                            ?>
                        </div>
                        <div class="grid_3 pull small_gutter_r relative">
                            <?php
                                echo $form->textField($modelContactNumber,'number',array('class'=>'grid_3 input','placeholder'=> 'Enter Phone Number'));
                                echo $form->error($modelContactNumber,'number',array('class'=>'errorMessage popup'));
                            ?>
                        </div>
                        <div class="grid_2 pull">
                            <button type="submit" class="button-blue tny">Add</button>
                        </div>
                    </div>
                </div>
                <?php $this->endWidget(); ?>
                </div>
                <?php $disp = ($modelContactNumber->hasErrors())?'none':'block';  ?>
                <div id="addPhone" class="row multi_line no-gutter visible clearfix gutter_vertical" style="display: <?php echo $disp; ?>">
                    <div class="grid_3 left">&nbsp;</div>
                    <div class="left grid_7 relative">
                        <a  href="javascript:void(0)"  onclick="$('#model_contact_number').show();$(this).hide();"><i class="fa fa-plus-square small_gutter_r"></i> Add another contact number</a>
                    </div>
                </div>

            </div>
            
            <?php
                $sms_results = Yii::app()->db->createCommand()
                        ->select()
                        ->from(SmsSubscription::model()->tableSchema->name.' SmsSubscription')
                        ->where('SmsSubscription.user_ref_id = '.Yii::app()->user->sub_id)
                        ->queryAll();
                $sms_subscription = CHtml::listData($sms_results, 'type_of_service', 'is_unsubscribed');
                $alert_on_img = '/app/images/webinar/alert_green.png';
                $alert_off_img = '/app/images/webinar/alert.png';
            ?>
            
            <div class="row multi_line gray gutter-left-35 gutter_vertical" >
                <div class="row visible clearfix">
                    
                    <div class="grid_3 left">SMS Subscriptions</div>
                    
                    <div class="left grid_7">
                        <span class="left">Webinar SMS</span>
                        <span class="right">
                            <?php 
                                if(isset($sms_subscription['Webinar']) && $sms_subscription['Webinar'] == 'Y'){
                                    $image = CHtml::image($alert_off_img, 'Off', array('id' => 'webinar_ams_alert_img'));
                                }else{
                                    $image = CHtml::image($alert_on_img, 'On', array('id' => 'webinar_ams_alert_img'));
                                }
                                echo CHtml::ajaxlink(
                                    $image,
                                    $this->createUrl('sms_alerts'),
                                    array(
                                        'type' => 'POST',
                                        'dataType' => 'json',
                                        'data' => array('type' => 'Webinar'),
                                        'success' => 'js:function(data){
                                            if(data.is_unsubscribed === "N"){
                                                $("#webinar_ams_alert_img").attr("src","'.$alert_on_img.'");
                                                $.notification({ class:"success_notify", notification:"notification_geniric", replaceKeys:{ MESSAGE : "Thanks for subscribing for our webinar updates"}});
                                            } 
                                            if(data.is_unsubscribed === "Y"){
                                                $("#webinar_ams_alert_img").attr("src","'.$alert_off_img.'");
                                                $.notification({ class:"error_notify", notification:"notification_geniric", replaceKeys:{ MESSAGE : "You have been unsubscribed from the SMS alerts of webinar"}});
                                            } 
                                        }',
                                    ),
                                    array()
                                );
                            ?>
                        </span>
                    </div>
                    
                </div>
            </div>
            
        </div>
    </div>
</section>

<script>
    function removeEmail(id){

        $.ajax({
            url: "<?php echo $this->createUrl('deleteEmail');?>",
            type: "POST",
            data: "ajax=remove-email&id="+id,
            dataType: "JSON",
            success: function(data){
                $("#alterEmail").hide();
                $("#email1").html("");
                window.location.reload();
                $.notification({
                    class:"success_notify",
                    notification:"email_deleted",
                    replaceKeys:{email_address:"<?php echo $alternate->email_id;?>"}
                });

            }
        });
    }

    function setPrimary(id){

        $.ajax({
            url: "<?php echo $this->createUrl('markPrimaryEmail');?>",
            type: "POST",
            data: "ajax=mark-email-primary&id="+id,
            dataType: "JSON",
            success: function(data){
                if(data.status=="success"){
                    $.notification({
                        class:"success_notify",
                        notification: "email_primary",
                        replaceKeys: {email_address:"<?php echo $alternate->email_id;?>"}
                    });

                    //$('#alterEmail').html("");
                    //$('#emailAction').html("");
                   // $('#email1').html("");

                    $.ajax({
                        url: "<?php echo $this->createUrl('ajaxEmailBlock');?>",
                        success:function(result){
                            $('#email').html(result);
                        }
                    });
                }else{
                    $.notification({
                        class:"error_notify",
                        notification:"email_primary_error",
                        replaceKeys:{email_address:"<?php echo $alternate->email_id;?>"}
                    });
                }
            }
        });
    }

    function setPhonePrimary(id){

        if(!confirm('Are you sure that you want to mark this phone number as primary?')) return false;
        $.ajax({

            url: "<?php echo $this->createUrl('markPrimaryPhone');?>",
            type: "POST",
            data:"ajax=mark-phone-primary&id="+id,
            dataType:"JSON",
            success: function(data){
              if(data.status == "success"){
                    $.notification({
                        class:"success_notify",
                        notification:"phone_primary"
                    });
                  // $('#secondary_'+id).html("");
                   //$('#alt_'+id).html("");
                    //$('#primaryNumber').html("");

                  $('#alt_'+id).hide();
                  $('#alt_'+id).html("");
                  $('#secondary_'+id).html("");

                    $.ajax({
                        url: "<?php  echo $this->createUrl('ajaxPhoneBlock'); ?>",
                        success: function(results){
                            $('#phone').html(results);
                            $('#addPhone').show();
                            $('#addPhone').find('a').show();
                            
                        }
                    });
                }
            }
        });
    }

    function removeNumber(id){
        if(!confirm('Are you sure that you want to delete this phone number?')) return false;
        $.ajax({
            url: "<?php echo $this->createUrl('deletePhone')?>",
            type: "POST",
            data: "ajax=remove-phone&id="+id,
            dataType:"JSON",
            success: function(data){
                $.notification({
                    class:"error_notify",
                    notification:"phone_deleted"
                });

                $('#alt_'+id).hide();
                $('#alt_'+id).html("");
                $('#secondary_'+id).html("");
            }
        });
    }
    function closePassword(){
        $('#oldNewPassword').slideToggle('fast');
        $('#oldNewPassword').find('input').each(function(){
            $(this).parent().removeClass('error');
            $(this).next('div.errorMessage').hide();
            $(this).val('');
        });
    }
    
    
</script>