
<?php
$rootPath = realpath(Yii::app()->basePath . '/../../');
if ($university_data['logo'] != "") {
    $imgPath = $rootPath . '/uploads/university/images/logo/' . $university_data['logo'];
}

$imgUrl = '/uploads/university/images/logo/' . $university_data['logo'];
?>



<div class="row multi_line white color-dark-gray">
    <div class="row multi_line no-gutter clearfix gutter_vertical border-bottom relative visible">
        <div class="grid_2 pull center">
            <?php if (file_exists($imgPath)) { ?>
                <img  width="100" title="<?php echo $university_data['name']; ?>" src="<?php echo $imgUrl; ?>" alt="University Logo">
            <?php } ?>
        </div>
        <div class="pull grid_7 div-inner-gutter-space">
            <h4><a href="#"><?php echo $university_data['name']; ?></a></h4>
            <div class="gutter_vertical"><?php echo $university_data['city'] ? $university_data['city'].", " : ""; echo $university_data['state'] ? $university_data['state'].", " : "";  echo $university_data['country']; ?></div>
        </div>
    </div>

    <div style="height: 350px; overflow: auto; padding-right: 5px;">
        <?php
        foreach($studentPreferredDepartments as $dept) {
        $deptId = $dept['main_dept_ref_id'];
        if (array_key_exists($deptId, $eoiDetails)) { ?>
            <div class="titles">
                <h3 class="uppercase gutter_vertical border-bottom"><?php echo $dept->mainDeptRef->department_name; ?></h3>
            </div>
        <div class=" gutter_vertical">
            <table class="grid_view color-dark-gray border no-hover">
                <tr class="gray-bg">
                    <th>Admission Chances</th>
                    <th>Scholarship Amount</th>
                    <th>Scholarship Chances</th>
                </tr>
                <tr>
                    <td class="center"><?php echo $eoiDetails[$deptId]['admission_chance']; ?> </td>
                    <td class="center"><?php echo $eoiDetails[$deptId]['amount'] ? "Rs. ".$eoiDetails[$deptId]['amount'] : "--"; ?> </td>
                    <td class="center"><?php echo $eoiDetails[$deptId]['scholarship_chance'] ? $eoiDetails[$deptId]['scholarship_chance'] : "--"; ?></td>
                </tr>
            </table>
        </div>
            <?php if($eoiDetails[$deptId]['offer_message']) { ?>
                <h4 class="gutter_vertical">Message</h4>
                <span><?php echo $eoiDetails[$deptId]['offer_message']; ?></span>
                <div class="row multi_line no-gutter">
                    <?php echo $eoiDetails[$deptId]['offer_message']; ?>
                </div>
            <?php } ?>

        <?php }?>

        <?php } ?>

    </div>
</div>