<link rel="stylesheet" type="text/css" href="/app/themes/new_grid_theme/views/layouts/css/skelton.css" />
<link rel="stylesheet" type="text/css" href="/app/themes/new_grid_theme/views/layouts/css/component.css" />

<style>
    .container{margin: 0px !important; }
    .italic{font-weight: normal; line-height: 18px; font-style: italic;}
    .absolute{background-color: rgb(255, 255, 255); padding: 0px 20px; position: absolute; left: 33%; z-index: 0; top: 87px;}
    form { margin: 0px; }
    .error select{border: 1px solid #fc8486 !important}
    body{background: none repeat scroll 0 0 #ffffff !important;}
</style>
<div class="row multi_line no-gutter white color-dark-gray container no-border">
    <div class="titles border-bottom row multi_line">
        <h3 class="uppercase center line-height">SIGN-UP TO UNLOCK YOUR CAREER PLAN</h3>
        <div class="center gutter20">Get your personalized career and college guidance program</div>
    </div>
    <div class="clearfix">
        <div class="clearfix relative">
            <?php
            $form = $this->beginWidget('CActiveForm', array(
                'id' => 'signupB2CData',
                'enableAjaxValidation' => true,
                'enableClientValidation' => false,
                'clientOptions' => array(
                    'validateOnSubmit' => true,
                    'validateOnChange' => false,
                    'validateOnType' => false,
                    'afterValidate'=>'js:afterValidate',
                ),
            ));
            ?>
            <div class="row multi_line visible">
                <div class="row visible relative clearfix">
                    <label class="left small-right">Do you already have an account on Univariety?</label>
                    <select id="uni_account_status" class="right" style="width:125px;">
                        <option value="no">No</option>
                        <option value="yes">Yes</option>
                    </select>
                </div>	
                
                <div class="row gutter_vertical visible relative">
                    <?php
                    echo $form->textField($model, 'username', array('placeholder' => "Your Email Address", 'onkeyup' => 'return removeSpace(this.value, "StudentSignupB2C_username");', "maxlength" => "40", "class" => "full-width"));
                    echo $form->error($model, 'username', array("class" => "errorMessage popup right"));
                    ?>
                </div>	
                
                <div class="row gutter_vertical visible relative">
                    <?php
                    $model->password = '';
                    echo $form->passwordField($model, 'password', array('placeholder' => "Password", "maxlength" => "25", "class" => "full-width"));
                    echo $form->error($model, 'password', array("class" => "errorMessage popup right"));
                    ?>
                </div>
                
                <div class="row visible relative gutter_vertical">
                    <?php
                    echo $form->dropDownList($model, 'present_class', $this->currentStudyLevelArray, array('empty' => 'You are a student in', 'class' => 'full-width'));
                    echo $form->error($model, 'present_class', array("class" => "errorMessage popup right"));
                    ?>
                </div>
                
                <div id="carrer_options" style="display:none;">
                    <div class="row gutter_vertical visible relative">
                        <?php 
                            echo CHtml::textField('career_plan_code', '', array('placeholder' => 'Enter your unique number (from scratch card)', 'class' => 'full-width'));
                        ?>
                        <div style="display:none" id="career_plan_code_em_" class="errorMessage popup right">
                            <div class="holder">Please Enter your unique code</div>
                        </div>
                    </div>

                    <div class="gutter_vertical visible relative">
                        <h5>Select your band</h5>
                        <?php foreach(LookupBand::model()->findAll(array('order' => 'band_order')) as $CarrerBand): ?>
                            <?php 
                                $band_slug = strtolower(Inflector::slug($CarrerBand->band_name, '_'));
                                $band_colors = explode('_and_', $band_slug);
                                $band_names = array();
                                foreach($band_colors as $color){
                                    $band_names[] = sprintf('<span style="color:%s;">%s</span>', $color, ucwords($color));
                                }
                            ?>
                            <input class="carrer_bands" type="radio" name="career_band_name" value="<?php echo $CarrerBand->band_id; ?>" id="<?php echo 'career_band_'.$band_slug; ?>" /> 
                            <label for="career_band_<?php echo $band_slug; ?>" class="small_gutter_r carrer_bands"><?php echo implode(' and ', $band_names) ?></label>
                        <?php endforeach; ?>

                        <div style="display:none" id="career_band_name_em_" class="errorMessage popup right">
                            <div class="holder">Please select your band</div>
                        </div>
                    </div>
                </div>
                
                <div class="row center">
                    <?php echo CHtml::submitButton('Sign Up', array('value' => 'Sign Up', 'class' => "button-blue tny full", 'id' => 'profileSignUp')); ?>
                </div>
                <div class="row small center">
                    By clicking 'Sign Up' you agree to our <a href="/app/content/termscondition" target="_blank">Terms & Conditions</a>
                </div>	
            </div>
            <?php $this->endWidget(); ?>
        </div>
    </div>		
</div>

<script>
    $("body").on('focus', 'input, select', function () {
        if ($(this).is(':radio')) {
            $(this).parent().find('div.errorMessage').hide('slow');
            $(this).parent().removeClass('error');
        } else {
            $(this).next('div.errorMessage').hide('slow');
            $(this).parent().removeClass('error');
        }
    });

    $(function () {
        parent.$.fn.colorbox.resize({height: 465, width: 580});
    });
    
    $('body').on('change', '#StudentSignupB2C_present_class', function(){
        var present_class = $(this).val();
        
        if(!present_class){
            $('#carrer_options').hide();
            parent.$.fn.colorbox.resize({height: 465, width: 580});
            return false;
        }
        parent.$.fn.colorbox.resize({height: 565, width: 580});
        $('#carrer_options').show();
        $('input[name=career_band_name]').prop('checked', false);
        $('.carrer_bands').hide();
        if(present_class == '9p' || present_class == '10p'){
            $('#career_band_orange').show();
            $('#career_band_orange').next('label').show();
            $('#career_band_purple').show();
            $('#career_band_purple').next('label').show();
            $('#career_band_blue').show();
            $('#career_band_blue').next('label').show();
        }else{
            $('.carrer_bands').show();
        }
        
    });
    
    function afterValidate(form,data,hasError){
        var return_val = true;
        var career_plan_code = $('#career_plan_code').val();
        var career_band_name = $('input[name=career_band_name]:checked').val()
        if(career_plan_code || career_band_name){
            if(!career_plan_code){
                $('#career_plan_code_em_').parent().addClass('error');
                $('#career_plan_code_em_').show();
                return false;
            }
            if(!career_band_name){
                $('#career_band_name_em_').parent().addClass('error');
                $('#career_band_name_em_').show();
                return false;
            }
        }
        
        for (var error_id in data){
            $('#'+error_id).parent().addClass('error');
            $('#'+error_id+'_em_').html(data[error_id][0]);
            $('#'+error_id+'_em_').show();
            return_val = false;
        }
        return return_val;
    }
    
    $('body').on('change', '#uni_account_status', function(){
        if($(this).val() == 'yes') window.location = '/app/login/PopupLogin?carrer-plan=yes';
    });
    
</script>