<?php

class StudentTestDetail extends CFormModel {

    public $entrance_exam_ref_id;
    public $exam_status;
    public $exam_year;
    public $overall_marks;
    public $user_entrance_exam_id;
    public $child = array();
    public $moduleList = array();
    public $entranceExamMaxMarks = 0;

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'entrance_exam_ref_id' => 'Test',
        );
    }

    /**
     * Declares the validation rules.
     * 
     */
    public function rules() {
        return array(
            
            array('exam_status', 'required', 'message'=>'<div class="holder"><p>Your exam status is required</p></div>'),
            array('exam_year', 'required', 'message'=>'<div class="holder"><p>Your year of appearing in exam is required</p></div>'),
            //array('overall_marks', 'required', 'message'=>'Your overall marks in exam is required'),
           // array('overall_marks', 'numerical','message'=>'<div class="holder"><p>Numbers only</p></div>'),
            array('overall_marks', 'numerical','numberPattern'=>'/^[+]?\d+([.]\d+)?$/','message'=>'<div class="holder"<p>Your overall marks should be number</p></div>'),
          //  array('overall_marks','match','pattern'=>'/^[0-9]+.[0-9]+$/','message'=>'<div class="holder"<p>Your overall marks should be number</p></div>'),
            array('overall_marks', 'validateMarks'),

            array('entrance_exam_ref_id, exam_status, exam_year, overall_marks, user_entrance_exam_id, child, moduleList, entranceExamMaxMarks', 'safe'),
        );
    }

    public function validateMarks($attribute, $param) {
        if($this->exam_status == "Planned") {
            
        } elseif ($this->overall_marks == '') {
            if($this->exam_status != "Planned") {
                $this->addError($attribute, '<div class="holder"><p>Overall score is required</p></div>');
            }
        } else {
            $compositeDetail = EntranceExam::model()->find('entrance_id=' . $this->entrance_exam_ref_id);
            if ($this->overall_marks <= 0) {
                $this->addError($attribute, '<div class="holder"><p>Maximum score allowed is ' . number_format($compositeDetail->max_marks) . '</p></div>');
            } elseif ($compositeDetail->max_marks > 0 && $this->overall_marks > $compositeDetail->max_marks) {
                $this->addError($attribute, '<div class="holder"><p>Maximum score allowed is ' . number_format($compositeDetail->max_marks) . '</p></div>');
            }
        }
    }



}

?>