<?php
class StudentProfilesDownload
{

    public function downloadDiBoughtProfiles($diID=0, $origin='', $users=''){

        $sql = "
		SELECT LM.username, TUM.user_id, TUM.login_ref_id, CONCAT(TUM.first_name, ' ', TUM.last_name) AS student_name,
		 CONCAT(TUM.father_first_name, ' ', TUM.father_last_name) AS father_name,
		 CONCAT(TUM.mother_first_name, ' ', TUM.mother_last_name) AS mother_name,
		 CONCAT(TUM.guardian_first_name, ' ', TUM.guardian_last_name) AS guardian_name,
		 DATE_FORMAT(TUM.dob, '%d-%b-%Y') AS dob, TUM.gender, TUM.address1, TUM.address2, TCM.city_name,
		 TUM.post_code, TS.name AS state_name, TCNTM.country_name, ME.ethnicity_name
		FROM di_student_selection DSS
		JOIN tbl_user_master TUM ON TUM.user_id = DSS.user_ref_id
		JOIN login_master LM ON LM.login_id = TUM.login_ref_id
		LEFT JOIN tbl_city_master TCM ON TCM.city_id = TUM.city_ref_id
		LEFT JOIN tbl_state TS ON TS.id = TUM.state_ref_id
		LEFT JOIN tbl_country_master TCNTM ON TCNTM.country_id = TUM.country_ref_id
		LEFT JOIN master_ethnicity ME ON ME.ethnicity_id = TUM.ethnicity_ref_id
		WHERE DSS.di_ref_id='".$diID."' AND DSS.status = 'Bought'";

        if($origin == 'Direct')
            $sql .= " AND DSS.origin NOT IN ('Campaign', 'BannerCampaign', 'SchoolVisit', 'Webinar', 'FeaturedAdClick')";
        elseif($origin == 'EmailCampaign')
            $sql .= " AND DSS.origin = 'Campaign'";
        elseif($origin == 'BannerCampaign')
            $sql .= " AND DSS.origin = 'BannerCampaign'";
        elseif($origin == 'SchoolVisit')
            $sql .= " AND DSS.origin = 'SchoolVisit'";
        elseif($origin == 'Webinar')
            $sql .= " AND DSS.origin = 'Webinar'";
        elseif($origin == 'FeaturedAdClick')
            $sql .= " AND DSS.origin = 'FeaturedAdClick'";

        if($users)
            $sql .= " AND DSS.user_ref_id IN (".$users.")";

        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        return $result;
    }


    public function downloadExpertBoughtProfiles($expertID=0, $users=''){

        $sql = "
		SELECT LM.username, TUM.user_id, TUM.login_ref_id, CONCAT(TUM.first_name, ' ', TUM.last_name) AS student_name,
		 CONCAT(TUM.father_first_name, ' ', TUM.father_last_name) AS father_name,
		 CONCAT(TUM.mother_first_name, ' ', TUM.mother_last_name) AS mother_name,
		 CONCAT(TUM.guardian_first_name, ' ', TUM.guardian_last_name) AS guardian_name,
		 DATE_FORMAT(TUM.dob, '%d-%b-%Y') AS dob, TUM.gender, TUM.address1, TUM.address2, TCM.city_name,
		 TUM.post_code, TS.name AS state_name, TCNTM.country_name, ME.ethnicity_name
		FROM vendor_student_selection VSS
		JOIN tbl_user_master TUM ON TUM.user_id = VSS.user_ref_id
		JOIN login_master LM ON LM.login_id = TUM.login_ref_id
		LEFT JOIN tbl_city_master TCM ON TCM.city_id = TUM.city_ref_id
		LEFT JOIN tbl_state TS ON TS.id = TUM.state_ref_id
		LEFT JOIN tbl_country_master TCNTM ON TCNTM.country_id = TUM.country_ref_id
		LEFT JOIN master_ethnicity ME ON ME.ethnicity_id = TUM.ethnicity_ref_id
		WHERE VSS.vendor_expert_ref_id='".$expertID."' AND VSS.status = 'Bought'";

        if($users)
            $sql .= " AND VSS.user_ref_id IN (".$users.")";

        $cmd = Yii::app()->db->createCommand($sql);
        $result = $cmd->queryAll();
        return $result;
    }
}