<?php

class StudentPreferencesForm extends CFormModel {

    public $levelOfStudy1;
    public $levelOfStudy2;
    public $levelOfStudyId1;
    public $levelOfStudyId2;
    public $countryPreference1;
    public $countryPreference2;
    public $countryPreference3;
    public $countryPreferenceNotSure;
    public $departmentPreference1;
    public $departmentPreference2;
    public $departmentPreference3;
    public $departmentPreferenceNotSure;
    public $subDepartmentPreference1;
    public $subDepartmentPreference2;
    public $subDepartmentPreference3;
    public $likelyStartPeriod1;
    public $likelyStartPeriod2;
    public $likelyStartPeriod3;
    public $likelyStartPeriodYear1;
    public $likelyStartPeriodYear2;
    public $likelyStartPeriodYear3;
    public $studyDuration1;
    public $studyDuration2;
    public $studyDurationId1;
    public $studyDurationId2;

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'countryPreference1' => 'Country Preference 1',
            'departmentPreference1' => 'Department Preference 1',
        );
    }

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
            array('levelOfStudy1', 'required','message'=>'<div class="holder"><p>Please choose your study evel</p></div>'),
            array('levelOfStudy1', 'validateStudyLevel'),
            
            array('studyDuration1', 'validateStudyDuration'),            
            
            array('countryPreference1', 'required', 'message' => '<div class="holder"><p>Your first country preference is required</p></div>'),
            array('countryPreference1', 'validateCountryPreference'),
            
            //array('departmentPreference1', 'required', 'message' => 'Your first major preference is required'),
            array('departmentPreference1', 'validateDepartment'),
            
            array('likelyStartPeriod1', 'validateLikelyStartPeriodMonthAndYear'),
            array('likelyStartPeriod1', 'validateLikelyStartPeriod'),
            
            array('levelOfStudy1, levelOfStudy2, levelOfStudyId1, levelOfStudyId2, countryPreference1, countryPreference2, countryPreference3, countryPreferenceNotSure, departmentPreference1, departmentPreference2, departmentPreference3, subDepartmentPreference1, subDepartmentPreference2, subDepartmentPreference3, likelyStartPeriod1, likelyStartPeriod2, likelyStartPeriod3, likelyStartPeriodYear1,
                likelyStartPeriodYear2, likelyStartPeriodYear3, studyDuration1, studyDuration2, studyDurationId1, studyDurationId2', 'safe'),
        );
    }

    public function validateCountryPreference($attribute, $params) {
        $arrCountryPref = array('1' => $this->countryPreference1, '2' => $this->countryPreference2, '3' => $this->countryPreference3);
        $arr = array();
        if(($this->countryPreference1 != '' || $this->countryPreference2 != '' || $this->countryPreference3 != '')){
            if(!$this->countryPreference1){
                $this->addError('countryPreference1', '<div class="holder"><p>Your first country preference is required</p></div>');
            }
            foreach ($arrCountryPref as $key => $val) {
                if ($val != '' && in_array($val, $arr)) {
                    $this->addError('countryPreference' . $key, '<div class="holder"><p>You selected the same country.Please change</p></div>');
                } else {
                    $arr[] = $val;
                }
            }
        }else if(!$this->countryPreferenceNotSure){
            if(!$this->countryPreference1){
                $this->addError('countryPreference1', '<div class="holder"><p>Your first country preference is required</p></div>');
            }
        }
    }

    public function validateStudyLevel($attribute, $params) {
        $arrStudyLevel = array('1' => $this->levelOfStudy1, '2' => $this->levelOfStudy2);
        $arr = array();
        foreach ($arrStudyLevel as $key => $val) {
            if ($val != '' && in_array($val, $arr)) {
                $this->addError('levelOfStudy' . $key, '<div class="holder"><p>You selected the same study level again.Please change</p></div>');
            } else {
                $arr[] = $val;
            }
        }
    }
    
    public function validateStudyDuration($attribute, $params) {
        $arrStudyDuration = array('1' => $this->studyDuration1, '2' => $this->studyDuration2);
        $arr = array();
        foreach ($arrStudyDuration as $key => $val) {
            if ($val != '' && in_array($val, $arr)) {
                $this->addError('studyDuration' . $key, '<div class="holder"><p>You selected the same study duration again.Please change</p></div>');
            } else {
                $arr[] = $val;
            }
        }
    }



    public function validateDepartment($attribute, $params){

        $main_dept = array();
        if($this->departmentPreference1) $main_dept[1] = $this->departmentPreference1;
        if($this->departmentPreference2) $main_dept[2] = $this->departmentPreference2;
        if($this->departmentPreference3) $main_dept[3] = $this->departmentPreference3;

        $sub_dept = array();
        if($this->subDepartmentPreference1) $sub_dept[1] = $this->subDepartmentPreference1;
        if($this->subDepartmentPreference2) $sub_dept[2] = $this->subDepartmentPreference2;
        if($this->subDepartmentPreference3) $sub_dept[3] = $this->subDepartmentPreference3;

        if(empty($main_dept[1])){
            $this->addError('departmentPreference1', '<div class="holder"><p>Your first major preference is required</p></div>');
        }else{
            $main_sub = array();
            foreach($main_dept as $key => $md){
                if(array_key_exists($key, $sub_dept)){
                    if(in_array($md.$sub_dept[$key], $main_sub)){
                        $this->addError('subDepartmentPreference' . $key, '<div class="holder"><p>Choose different department</p></div>');
                        unset($main_dept[$key]);
                    }
                    $main_sub[] = $md.$sub_dept[$key];

                }

            }

            $non_duplicate = array_unique($main_dept);
            $missed = array_diff_assoc($main_dept,$non_duplicate);

            if($missed){
                $missed[array_search($missed[key($missed)], $main_dept)] = $main_dept[array_search($missed[key($missed)], $main_dept)];
                ksort($missed);
                foreach($missed as $key => $v){
                    if(!array_key_exists($key, $sub_dept)) $this->addError('subDepartmentPreference'.$key, '<div class="holder"><p>Choose a department</p></div>');
                }
            }
        }

    }

    public function validateLikelyStartPeriodMonthAndYear($attribute, $params) {
        $arrLikelyStartPeriodMonth = array(
            '1' => $this->likelyStartPeriod1,
            '2' => $this->likelyStartPeriod2,
            '3' => $this->likelyStartPeriod3
        );
        $arrLikelyStartPeriodYear = array(
            '1' => $this->likelyStartPeriodYear1,
            '2' => $this->likelyStartPeriodYear2,
            '3' => $this->likelyStartPeriodYear3
        );
        
        for($i = 1; $i <= 3; $i++) {
            if($arrLikelyStartPeriodMonth[$i] == '' && $arrLikelyStartPeriodYear[$i] != '') {
                $this->addError('likelyStartPeriod' . $i, '<div class="holder"><p>You need to select a prospective starting session month</p></div>');
            } elseif($arrLikelyStartPeriodMonth[$i] != '' && $arrLikelyStartPeriodYear[$i] == '') {
                $this->addError('likelyStartPeriodYear' . $i, '<div class="holder"><p>Select starting session year</p></div>');
            }
        }
    }
    
    public function validateLikelyStartPeriod($attribute, $params) {
        $arrLikelyStartPeriod = array(
            '1' => $this->likelyStartPeriod1 . $this->likelyStartPeriodYear1,
            '2' => $this->likelyStartPeriod2 . $this->likelyStartPeriodYear2,
            '3' => $this->likelyStartPeriod3 . $this->likelyStartPeriodYear3
        );
        $arr = array();
        foreach ($arrLikelyStartPeriod as $key => $val) {
            if ($val != '' && in_array($val, $arr)) {
                $this->addError('likelyStartPeriod' . $key, '<div class="holder"><p>You have selected same prospective starting session</p></div>');
            } else {
                $arr[] = $val;
            }
        }
    }

}

?>