<?php

class StudentEditProfile extends CFormModel {

    public $first_name;
    public $middle_name;
    public $last_name;
    public $gender;
    public $school_name;
    public $dob_date;
    public $dob_month;
    public $dob_year;
    public $dob;
    public $ethnicity_ref_id;
    public $citizenship_ref_id1;
    public $citizenship_ref_id2;
    public $studentCitizenshipId1;
    public $studentCitizenshipId2;
    public $email_address;
    public $address1;
    public $address2;
    public $post_code;
    //public $city;

    public $student_country_code;
    public $student_number;
    public $country_ref_id;
    public $state_ref_id;
    public $city_ref_id;
    public $introduce_yourself;
    public $note;
    public $address_country_code;

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'first_name' => 'first name',
            'middle_name' => 'middle name',
            'last_name' => 'last name',
            'parent_first_name' => 'parent first name',
            'parent_last_name' => 'parent last name',
            'gender' => 'gender',
            'email_address' => 'email_address',
            'ethnicity_ref_id' => 'ethnicity',
            'address1' => 'address line1',
            'address2' => 'address line2',
            'dob_date' => 'Birth date',
            'dob_month' => 'Birth month',
            'dob_year' => 'Birth year',
            'dob' => 'Date of Birth',
            //'city' => 'city name',
            'post_code' => 'zip code',
            'country_ref_id' => 'country',
            'state_ref_id' => 'state',
            'city_ref_id' => 'city',
            'introduce_yourself' => 'Introduce yourself',
            'note' => 'note',
        );
    }

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
            array('first_name', 'required', 'message' => '<div class="holder"><p>Your first name is required</p></div>', 'on' => 'basicInfo'),
            array('last_name', 'required', 'message' => '<div class="holder"><p>Your last name is required</p></div>', 'on' => 'basicInfo'),
            array('last_name','match','pattern' =>'/^[a-zA-Z ]*$/i','message' => '<div class="holder"><p>Last name should contain only alphabets</p></div>', 'on' => 'basicInfo'),
            array('middle_name','match','pattern' =>'/^[a-zA-Z ]*$/i','message' => '<div class="holder"><p>Middle name should contain only alphabets</p></div>', 'on' => 'basicInfo'),
            array('first_name', 'match', 'pattern' => '/^[a-zA-Z ]*$/i', 'message' => '<div class="holder"><p>First name should contain only alphabets</p></div>', 'on' => 'basicInfo'),
            //array('school_name', 'required', 'message' => '<div class="holder"><p>School name cant be blank</p></div>', 'on' => 'basicInfo'),
            //array('address1,address2','match','pattern'=>'/[a-zA-Z0-9]/','message'=>'<div class="holder"><p>Invalid address</p></div>'),
            //array('gender, citizenship_ref_id, country_ref_id, city_ref_id, dob_date, dob_month, dob_year', 'required', 'message' => 'Select your {attribute}.', 'on' => 'basicInfo'),
            array('gender', 'required', 'message' => '<div class="holder"><p>Select your {attribute}</p></div>', 'on' => 'basicInfo'),
            //array('phone_num, country_code', 'required', 'message' => 'Enter {attribute} ', 'on' => 'basicInfo'),
            array('email_address', 'match', 'pattern' => '/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$/',
                'message' => ' Enter valid {attribute}</p></div>', 'on' => 'basicInfo'),
            //array('parent_email_address', 'required', 'message' => "Enter parent's email", 'on' => 'basicInfo'),
            array('email_address', 'validateEmailAddress', 'on' => 'basicInfo'),
            array('dob', 'validateDOB', 'on' => 'basicInfo'),
            // array('state_ref_id', 'validateState', 'on' => 'basicInfo'),
            array('student_country_code', 'required', 'message' => '<div class="holder"><p>Your country code is required</p></div>', 'on' => 'basicInfo'),
            array('student_country_code', 'numerical', 'integerOnly' => true, 'min'=>'1', 'tooSmall'=>'<div class="holder"><p>Country code is invalid</p></div>', 'message' => '<div class="holder"><p>Country code should only contain numbers</p></div>', 'on' => 'basicInfo'),
            array('student_number', 'required', 'message' => '<div class="holder"><p>Your phone number is required</p></div>', 'on' => 'basicInfo'),
            array('student_number', 'numerical', 'integerOnly' => true, 'message' => '<div class="holder"><p>Enter valid phone number</p></div>', 'on' => 'basicInfo'),
           array('student_number', 'studentPhoneValidation', 'on' => 'basicInfo'),
            array('student_number', 'length', 'min' => '5', 'max' => '12', 'tooShort' => '<div class="holder"><p>Enter valid phone number</p></div>', 'tooLong' => '<div class="holder"><p>Maximum 12 digits</p></div>', 'on' => 'basicInfo'),
            array('student_number', 'match', 'pattern' => '/^[1-9]+[0-9]{0,12}$/i', 'message' => '<div class="holder"><p>Phone number is invalid</p></div>', 'on' => 'basicInfo'),
            array('post_code', 'match', 'pattern' => '/^[a-zA-Z1-9]{1}+[a-zA-Z0-9]{3,12}$/', 'message' => '<div class="holder"><p>The zipcode entered is not correct</p></div>', 'on' => 'basicInfo'),
            array('citizenship_ref_id1', 'validateCitizenship', 'on' => 'basicInfo'),            
            //array('city', 'match', 'pattern' => '/^[a-z ]*$/i', 'message' => 'Please enter valid city', 'on' => 'basicInfo'),
            array('citizenship_ref_id1, citizenship_ref_id2, studentCitizenshipId1, studentCitizenshipId2, school_name,dob_date,dob_month,dob_year,ethnicity_ref_id,address1,address2,country_ref_id,state_ref_id,city_ref_id,introduce_yourself,student_number,student_country_code, address_country_code', 'safe', 'on' => 'basicInfo'),            
                //array('user_id, login_ref_id, membership_ref_id, uno, user_photo, first_name, middle_name, last_name, father_first_name, father_last_name, mother_first_name, mother_last_name, address1, address2, city_ref_id, state_ref_id, country_ref_id, post_code, present_class, class_status, present_board_ref_id, school_ref_id, passout_year, passout_month, dob, gender, citizenship_ref_id, ethnicity_ref_id, family_income_ref_id, primary_financing_ref_id, scholarship_importance_ref_id, reason_study_abroad_ref_id, ps_why_this_subject, ps_leadership, introduce_yourself, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, is_newsletter_subscribe, added_on, modified_on, new_password, book_session_count, is_valid_email, profile_complete_date, critical_percent, recommended_percent', 'safe', 'on'=>'basicInfo'),
            array('note', 'required', 'message' => '<div class="holder"><p>Please enter {attribute}</p></div>', 'on' => 'note'),
        );
    }

   public function studentPhoneValidation() {

        if ($this->student_country_code == 91) {/*
            $res = file_get_contents('http://www.bmobile.in/'.$this->student_number);

            $res_arr = explode('<table class="table table-hover table-condensed "><tbody>', $res);
            $res_arr1 = explode('</tbdy>', $res_arr[1]);

            $count = 0;
            $count = substr_count($res_arr1[0], $this->student_number); */

            if($this->student_number[0] < 7){
                $this->addError('student_number', '<div class="holder"><p>Enter a valid mobile number</p></div>');
            }
        }
    }

    public function validateEmailAddress($attribute, $params) {
        $emailAddress = $_POST['EditProfile']['email_address'];
        $loginRefID = $_POST['loginRefId'];
        $emailExist = LoginMaster::isDuplicateEmail($emailAddress, $loginRefID);

        if ($emailExist) {
            $this->addError($attribute, '<div class="holder"><p>Email Id is already exists. Please enter another Email Id</p></div>');
        }
    }

    public function validateCitizenship($attribute, $params) {
        $arrCitizenship = array('1' => $this->citizenship_ref_id1, '2' => $this->citizenship_ref_id2);
        $arr = array();
        foreach ($arrCitizenship as $key => $val) {
            if ($val != '' && in_array($val, $arr)) {
                $this->addError('citizenship_ref_id' . $key, '<div class="holder"><p>You entered same citizenship again.Please change</p></div>');
            } else {
                $arr[] = $val;
            }
        }
    }
    
    public function validateDOB($attribute, $params) {
        $day = $this->dob_date;
        $month = $this->dob_month;
        $year = $this->dob_year;
        $flag = false;
        if ($day != '' || $month != '' || $year != '') {
            if ($day == '') {
                $this->addError('dob_date', '<div class="holder"><p>Select Date</p></div>');
                $flag = true;
            }
            if ($month == '') {
                if($flag){
                    $this->addError('dob_month', '');
                }else{
                    $this->addError('dob_month', '<div class="holder"><p>Select Month</p></div>');
                    $flag = true;
                }
            }
            if ($year == '') {
                if($flag){
                    $this->addError('dob_year', '');
                }else{
                    $this->addError('dob_year', '<div class="holder"><p>Select Year</p></div>');
                }
            }
            if(($month !='' && $day !='' && $year !='') && !checkdate($month,$day,$year)) {
                $errorDate=$day.' '.date("M", mktime(0, 0, 0, $month, 1, $year)).' '. $year;
                $this->addError('dob_date', '<div class="holder"><p>'.$errorDate.' is not a valid date</p></div>');

            }
        }
    }

    public function getCountryCodes() {
        $result = TblCountryMaster::model()->findAll('is_active= "Y" AND country_code <> "" ORDER BY country_code ASC ');
        return CHtml::listData($result, 'phone_code', function($country) { return $country->country_name." (+".$country->phone_code.")"; } );
    }


    
}

?>