<?php

/**
 * This is the model class for student registration.
 *
 * The followings are the available columns student registration form':
 * @property string $username
 * @property string $pass_word
 *
 */
class CommonLogin extends CFormModel {

    public $email;
    public $password;
    public $unique_id;

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
            // email and password are required
            array('email, password', 'required', 'message' => 'Please enter {attribute}.'),
            array('email', 'email', 'message' => 'Please enter valid email address.'),
            array('unique_id','safe'),
        );
    }

 
    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'email' => 'email',
            'password' => 'password',
        );
    }
}
?>