<?php

/*
 * sign-up controller for student
 * 
 */

class SignupController extends Controller
{

    //public $layout = "//layouts/partnership";
    public $currentStudyLevelArray = array(
        '9p' => 'Pursuing - 9th or equivalent',
        '10p' => '10th',
        '11p' => '11th',
        '12p' => '12th',
        '12c' => '12th Completed',
    );
    public $currentStudyLevelDbValuesArray = array(
        '12c' => array('12', 'Completed'),
        '12p' => array('12', 'Pursuing'),
        '11p' => array('11', 'Pursuing'),
        '10p' => array('10', 'Pursuing'),
        '9p' => array('9', 'Pursuing'),
    );

    public $gradesArray = array(
        '1' => 'A*',
        '2' => 'A',
        '3' => 'B',
        '4' => 'C',
        '5' => 'D',
    );

    public $userId, $loginRefId, $likelyStartPeriodYear, $userSession;
    public $schoolRefId, $schoolName, $slugName = null;
    public $studentExtraParams = array();
    public $schoolNameOnBlur = 'Type & select your school name...';
    public $aspireSchoolOnBlur = 'Type college name...';
    public $userProfCriticalFields = array();
    public $schoolBoardRefId = null;

    public $courseLevel = array();
    public $userInfo = array();
    public $studyDuration = array();
    public $countryList = array();
    public $stateList = array();
    public $cityList = array();

    public $studentClassDetails = array();
    public $overallType = '';
    public $overallMax = 0;
    public $subjectMax = 0;
    public $classLevel = 0;
    public $studentPreferredDepartmentIds = array();
    public $studentPreferredCountryIds = array();
    public $subjects = array();
    public $subjectInputMarks;
    public $flagStandardExams = false;
    public $standardExams = array();
    public $userContactInfo = array();
    public $isCssAccess = false;
    public $instId = '';
    public $cssStudentNames = array();
    public $cssStudentNamesList = array();


    /*public function accessRules()
    {
        return array(
            array('allow',
                'actions' => array('index', 'dynamicpassoutyear', 'getboardlist', 'basicInfo'),
                'users' => array('*'),
                //'expression' => 'Yii::app()->user->isAdmin()'
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }*/

    public function filters()
    {
        return array(
            'rights',
        );
    }

    public function actions()
    {
        return array(
            // captcha action renders the CAPTCHA image displayed on the registration page
            'captcha' => array(
                'class' => 'CCaptchaAction',
                'backColor' => 0xFFFFFF,
                'minLength' => '5',
                'maxLength' => '5',
                'testLimit' => '1',
                'transparent' => true,
            ),
        );
    }

    public function init()
    {
        parent::init();
        Yii::app()->theme = 'uni_avada';
        $this->layout = "//layouts/registration";

        //getting user information from session

        if (Yii::app()->session->itemAt('sUserUnivariety') != '') {

            $this->getUserSessionInfo();
            $this->userProfCriticalFields = TblUserProfCriticalCompletion::getUserCriticalField($this->userId);
        }

    }

    public function actionIndex()
    {

        $this->canonicalUrl = 'https://www.univariety.com/app/student/signup';
        $res = explode(".",$_SERVER['HTTP_HOST']);
        $redirect_signup = 0;
        if (($res[0] != 'www') && (count($res) > 2)) {

        } else {
            /*Yii::import('application.components.abtest.*');
            $ab = new phpab('StudentSignUp');
            $ab->add_variation('signup');
            $ab->add_variation('newsignup');
            if($ab->get_user_segment() == 'signup') {
                $this->redirect('/app/student/createProfile');
            } else { */
                $this->redirect('/app/student/createProfile/signUp');
                //$this->redirect('/app/student/createProfile');
            //}
        }

        $this->setPageTitle(Yii::app()->name ." - Create a new account");

        // Comment this line not allwoing counsellor to back on sign up first page. - Anshul 
        //if (Yii::app()->session->itemAt('sUserUnivariety') != '' && Yii::app()->session->itemAt('sInstituteUnivariety') == '') {
        if (Yii::app()->session->itemAt('sUserUnivariety') != '') {
          
            $this->userInfo = TblUserMaster::getUserDetails($this->userId);
            if($this->userInfo->membership_ref_id == 2){
                CommonUtils::checkUserRedirection($this->userId, $this->action->Id);
            }else{
                CommonUtils::checkUserRedirection($this->userId, $this->action->Id);
                //$this->redirect(Yii::app()->params['cbasepath'] . '/app/dashboard');
            }
        }

        $this->checkCssAccess();

        $yearList = array();

        $studentSignupModel = new StudentSignup('firstPage');
        $this->performAjaxValidation($studentSignupModel);

        $uniqueId = md5($studentSignupModel->getUniqueID("uid"));
        $studentSignupModel->set_session("unique_id", $uniqueId);
        //$emailHash = '';
        $instId = $presentSchool = $presentClass = '';
        $postData = array();
        $emailHash = (@$_POST['StudentSignup']['username'] != '') ? md5(@$_POST['StudentSignup']['username']) : Yii::app()->request->getParam('hashkey');
        //$emailHash = 'a25a0c5a35b3f2356d92f661f5def6f6';

        if ($emailHash != '') {
            $result = $studentSignupModel->getInvitedStudentsBasicInfo($emailHash);
      
            if ($result) {
                $invitedStudentInfo = $result->attributes;
                $instId = $invitedStudentInfo['inst_ref_id'];
                $studentSignupModel->first_name = $invitedStudentInfo['first_name'];
                $studentSignupModel->last_name = $invitedStudentInfo['last_name'];
                $studentSignupModel->username = $invitedStudentInfo['email_id'];
                $studentSignupModel->confirm_username = $invitedStudentInfo['email_id'];
                $studentSignupModel->gender = $invitedStudentInfo['gender'];
                $studentSignupModel->present_board_ref_id = $invitedStudentInfo['board_ref_id'];
                $studentSignupModel->passout_month = $invitedStudentInfo['completion_month'];
                $studentSignupModel->passout_year = $invitedStudentInfo['completion_year'];

                // While adding student through css panel. completed staus is saving as blank so add new condition '' in study level - Gaurav
                $studyLevel = ($invitedStudentInfo['class_status'] == '' || $invitedStudentInfo['class_status'] == 'Complete' || $invitedStudentInfo['class_status'] == 'Completed') ? 'c' : 'p';

                $studentSignupModel->present_studylevel = $invitedStudentInfo['class'] . $studyLevel;
                $this->studentExtraParams['confEmailType'] = 'hidden';
                $this->studentExtraParams['emailReadOnly'] = 'readonly';
                $yearList = UniversityHelper::completeYear($invitedStudentInfo['class'] . $studyLevel);
                $yearList = array_combine($yearList, $yearList);
            }
        } else {
            $this->studentExtraParams['confEmailType'] = 'text';
            $this->studentExtraParams['emailReadOnly'] = '';
        }
        if ($instId > 0) {
            $userMembershipRefId = $studentSignupModel->getMembershipId('SI Student');
            $result = TblSiDi::GetSchoolLookupId($instId);
            $instInfo = $result->attributes;
            $this->schoolRefId = $instInfo['school_ref_id'];
            $this->schoolName = $instInfo['inst_name'];
        } elseif (0 !== strpos($_SERVER['HTTP_HOST'], 'www')) { // not start with www
            $hostName = explode(".", $_SERVER['HTTP_HOST']);
            if($hostName[1] != "com") {
                $subDomainName = $hostName[0];
                $schoolData = $studentSignupModel->getSchoolNameBySubdomain($subDomainName)->attributes;
                if($schoolData['school_id']){
                    $siDiData = TblSiDi::GetInstIdFromSchoolId($schoolData['school_id']);
                    $instId = $siDiData->inst_id;
                }
            }
        } else {
            $instId = 'null';
            $this->schoolRefId = 'null';
            $userMembershipRefId = $studentSignupModel->getMembershipId('Guest');
        }
     
        if (isset($_POST['StudentSignup'])) {

            $studentSignupModel->attributes = $_POST['StudentSignup'];
            $postData = Yii::app()->request->getPost('StudentSignup');
       
        
            if ($studentSignupModel->validate()) {

                //$emailHash = md5($postData['username']);
                //Checking the given email is exist in student_upload_master_list
                //(in case student is registering directly with out invitation link)
                $isEmailConfirmed = 0;

                if (isset($emailHash) && $emailHash != '') {
                    $result = $studentSignupModel->getInvitedStudentsBasicInfo($emailHash);
                    if (isset($result)) {
                        $invitedStudentInfo = $result->attributes;
                        $tempInstId = $invitedStudentInfo['inst_ref_id'];
                        if ($tempInstId > 0) {
                            $result = TblSiDi::GetSchoolLookupId($instId);
                            $instInfo = $result->attributes;
                            $this->schoolRefId = $instInfo['school_ref_id'];
                            $this->schoolName = $instInfo['inst_name'];
                            $instId = $tempInstId;
                            $this->schoolBoardRefId = $invitedStudentInfo['board_ref_id'];
                            $userMembershipRefId = $studentSignupModel->getMembershipId('SI Student');
                            $isEmailConfirmed = 1;
                        }
                    } elseif (0 !== strpos($_SERVER['HTTP_HOST'], 'www')) { // not start with www
                        $hostName = explode(".", $_SERVER['HTTP_HOST']);
                        if($hostName[1] != "com") {
                            $subDomainName = $hostName[0];
                            $schoolData = $studentSignupModel->getSchoolNameBySubdomain($subDomainName)->attributes;
                            if($schoolData['school_id']){
                                $this->schoolRefId = $schoolData['school_id'];
                                $this->schoolName = $instInfo['inst_name'];
                                $userMembershipRefId = $studentSignupModel->getMembershipId('SI Student');
                                $siDiData = TblSiDi::GetInstIdFromSchoolId($schoolData['school_id']);
                                $instId = $siDiData->inst_id;
                                $isEmailConfirmed = 1;
                            }
                        }
                    }

                    if (!$_SESSION['loginID']) {
                        $isEmailConfirmed = 0;
                    }
                } 

                //getting user role. Default: Student
                $userRoleId = $studentSignupModel->getUserRefId();
                $postData['username'] = strtolower(trim($postData['username']));

                //creating a login_master record
                $loginMasterData = array('username' => $postData['username'], 'pass_word' => $postData['pass_word'],
                                         'user_type_ref_id' => $userRoleId, 'is_active' => 1, 'is_email_confirmed' => $isEmailConfirmed,
                                         'added_on' => date('Y-m-d H:i:s')
                );
                //die(print_r($loginMasterData));
                $loginMasterModel = new LoginMaster;
                $loginMasterModel->setAttributes($loginMasterData);
                //die($this->printr($loginMasterModel->attributes));
                $loginMasterModel->save();
                $this->loginRefId = $loginMasterModel->login_id;

                //Creating student unique number
                if (Yii::app()->session->itemAt('sInstituteUnivariety') != '') {
                    $userUNO = $studentSignupModel->generateUNO($postData['country_code'], $instId);
                } else {
                    $userUNO = $studentSignupModel->generateUserUNO('IN');
                }

                //getting Url_id
                if ($instId > 0) {
                    $classLevel = $postData['present_studylevel']; //substr($postData['present_studylevel'], 0, -1);
                    switch ($classLevel) {
                        case '9p':
                        case '10p':
                        {
                            $classLevel = 9;
                            $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'signup',
                                'class_level' => $classLevel,
                                'type_of_field' => 'critical',
                                'label' => 'b2c_country_pref',
                            ), 1);
                            break;
                        }
                        case '11p':
                        case '12p':
                        case '12c':
                        {
                            $classLevel = 12;
                            $urlDetailsData = array('model_name' => 'profile',
                                'class_level' => $classLevel,
                                'type_of_field' => 'critical',);
                            $urlDetails = LookupUrl::getUrlByModel($urlDetailsData, 1);
                            break;
                        }
                    }
                    //$urlDetails = LookupUrl::getUrlByModel('profile', $classLevel, 1);

                    $redirectUrlRefId = $urlDetails[0]['url_id'];
                    $afterSignupRedirectUrl = $urlDetails[0]['url'];
                    //$this->printr($urlDetails);
                    //$this->printr($urlDetailsData);
                } else {
                    //$urlDetails = LookupUrl::getUrlByModel('signup', 0, 1);
                    $classLevel = $postData['present_studylevel'];
                    if ($classLevel == '10p') {
                        $classLevel = 9;
                    } else {
                        $classLevel = 0;
                    }
                    $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'signup',
                                                                 'class_level' => $classLevel,
                                                                 'type_of_field' => 'critical',
                                                                 'label' => 'b2c_country_pref',
                                                           ), 1);
                    $afterSignupRedirectUrl = $urlDetails[0]['url'];

//                    $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,
//                                                                 'label' => 'dashboard',
//                                                           ), 1);
                    
                    $redirectUrlRefId = $urlDetails[0]['url_id'];
                }

                $boardDetail = LookupBoardEquivalent::getBoardDetailById($_POST['StudentSignup']['present_board_ref_id']);
                // todo: need to implement code for updating membership_ref_id,
                //adding user details to tbl_user_master
                $userMasterModel = new TblUserMaster;
                $userMasterData = array('login_ref_id' => $this->loginRefId, 'uno' => $userUNO,
                                        'first_name' => ucwords(strtolower(trim($postData['first_name']))), 'last_name' => ucwords(strtolower(trim($postData['last_name']))),
                                        'membership_ref_id' => $userMembershipRefId['membership_id'], 'gender' => $postData['gender'],
                                        'present_class' => $this->currentStudyLevelDbValuesArray[$postData['present_studylevel']][0],
                                        'class_status' => $this->currentStudyLevelDbValuesArray[$postData['present_studylevel']][1],
                                        'redirect_url_ref_id' => $redirectUrlRefId,
                                        'profile_status_ref_id' => '3', 'passout_year' => $postData['passout_year'],
                                        'passout_month' => $postData['passout_month'],
                                        'added_on' => date('Y-m-d H:i:s'),
                                        'present_board_ref_id'=>$boardDetail['board_ref_id'],
                );
                if($_POST['hidStudentDropdowns'] > 0 && $postData['cssStudentNames'] != ''){
                    $userMasterData['first_name'] = ucwords(strtolower(trim($this->cssStudentNames[$postData['cssStudentNames']]['first_name'])));
                    $userMasterData['last_name'] = ucwords(strtolower(trim($this->cssStudentNames[$postData['cssStudentNames']]['last_name'])));
                }
                if ($this->schoolRefId > 0) {
                    $userMasterData['school_ref_id'] = $this->schoolRefId;
                }
                if ($this->schoolBoardRefId > 0) {
                    $userMasterData['present_board_ref_id'] = $this->schoolBoardRefId;
                }
				$userMasterModel->scenario='register';
                $userMasterModel->attributes = $userMasterData;
              //  die($this->printr($userMasterData));
                if ($userMasterModel->save(false)) {
                    $this->userId = $userMasterModel->user_id;
                    if($_POST['hidStudentDropdowns'] > 0 && $postData['cssStudentNames'] != ''){
                        StudentUploadMasterNoEmail::updateMasterListData($postData['cssStudentNames']);
                    }

                    //changing student invitation status to "Accepted" if he is CSS invited student
                    StudentUploadMasterList::updateInvitedStudentInfoByEmail($postData['username'],
                        array('user_ref_id' => $this->userId,
                              'invitation_status' => 'Accepted',
                              'modified_on' => date('Y-m-d H:i:s'),
                              'modified_by' => $this->loginRefId
                        )
                    );

                    //todo: create a record in student education table

                    //Assigning user as Student to RBAC
                    $studentSignupModel->setRbacAssignment('Student', $this->loginRefId);

                    /*//Adding student email into student_alternate_email table
                    $attributes = array('login_ref_id' => $this->loginRefId, 'contact_type_ref_id' => 1,
                                        'email_id' => $postData['username'], 'added_by' => $this->loginRefId, 'is_active' => 1,
                                        'added_on' => date('Y-m-d H:i:s')
                    );
                    StudentAlternateEmail::storeUserContactInfo($attributes);*/

                    //Creating a record in student_education
                    $studentEducationDetails = array('user_ref_id' => $this->userId,
                                                     'class_level' => $this->currentStudyLevelDbValuesArray[$postData['present_studylevel']][0],
                                                     'status' => $this->currentStudyLevelDbValuesArray[$postData['present_studylevel']][1],
                                                     'school_name' => $this->schoolName, //todo: get school name
                                                     'month' => $postData['passout_month'], 
                                                     'year' => $postData['passout_year'], 
                                                     'added_on' => date('Y-m-d')
                    );
                    
                    // do not insert 12th completed month and year in 10th class sign up education detail
                    if($postData['present_studylevel'] == "10p") {
                        $studentEducationDetails['month'] = NULL;
                        $studentEducationDetails['year'] = NULL;
                    }
                    
                    if ($this->schoolBoardRefId > 0) {
                        $boardRefId = $studentSignupModel->getBoardEquivalentId($this->currentStudyLevelDbValuesArray[$postData['present_studylevel']][0],
                            $this->schoolBoardRefId);
                        $studentEducationDetails['board_ref_id'] = $boardRefId;
                    }
                    StudentEducation::createStudentEducationRecord($studentEducationDetails);

                    //inserting to tbl_si_students if he is related to a School
                    if ($instId > 0) {
                        $studentSignupModel->setSiStudents($this->userId, $instId);
                    }

                    if ($isEmailConfirmed == 0) {
						$this->sendConfirmationEmail($postData['first_name'], $postData['username'], $this->userId);
					}

                    //updating critical percentage fields
                    $criticalFields = array('name' => 1, 'gender' => 1, 'edu_study_level' => 1, 'completion_year' => 1);
                    TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                    CommonUtils::calculateCriticalPercentage($this->userId);

                    // session set
                    Yii::app()->session['signupProcess'] = 'guestSignup';
                    //Yii::app()->session['firstTimeSignup'] = '1';

                    //TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));

                    

                    setFlashMessage('success_notify', 'globalnotifications.profile_created');

                    $loginModel = new LoginMaster();
                    $loginModel->loginWithRedirect($postData['username'], $postData['pass_word'], $afterSignupRedirectUrl);
                }

            }
        }


        $this->render('signup', array('userMasterModel' => $studentSignupModel,
                                      'emailHash' => $emailHash,
                                      //'loginModel'=>$loginModel,
                                      //'schoolList' => $schoolList,
                                      //'boardList' => $boardList,
                                      //'postData' => $postData,
                                      'year' => $yearList,
                                        'instId'=>$instId,
                                      //'partnerStudentData' => $partnerStudentData,
                                      //
                                      //'uniqueId' =>$uniqueId
                                ));
    }
    
    public function actionValidateEmailAddress() {
        $email = Yii::app()->getRequest()->getParam('email');
        echo $emailExist = LoginMaster::isDuplicateEmail($email);
        Yii::app()->end();
    }
    
    public function actionError()
    {
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

    public function actionDynamicpassoutyear()
    {
        $yearlist = UniversityHelper::completeYear($_POST['StudentSignup']['present_studylevel']);
        echo CHtml::tag('option', array('value' => ''), CHtml::encode('12th Completion Year'), true);
        foreach ($yearlist as $key => $value) {
            echo CHtml::tag('option', array('value' => $value), CHtml::encode($value), true);
        }
    }
    public function actionDynamicboards()
    {

        $boardId = yii::app()->request->getParam('boardId');
        switch ($_POST['StudentSignup']['present_studylevel']) {
            case '9p':
                $class = 9;
                break;
            case '10p':
                $class = 10;
                break;
            case '11p':
                $class = 11;
                break;
            case '12p':
            case '12c':
                $class = 12;
                break;

        }
        if ($_GET['instId'] == '' || $_GET['instId'] == 'null' || !$_GET['instId']) {
            $sql ="SELECT board_equivalent_id,lb.board_desc,board_ref_id FROM lookup_board lb
                    INNER JOIN lookup_board_equivalent t ON lb.board_id = t.board_ref_id
                    WHERE t.class_level ='".$class."' ORDER BY lb.board_desc";
            $command =Yii::app()->db->createCommand($sql);
            $result = $command->queryAll();
        } else {
            $result = TblSiBoard::getSchoolBoardEquivalentList($_GET['instId'], $class);
        }
        $boardsList = CHtml::listData($result, 'board_equivalent_id', 'board_id');
        echo CHtml::tag('option', array('value' => ''), CHtml::encode('Choose your board'), true);
        foreach ($boardsList as $key=>$data) {
            $boardName = LookupBoard::getBoardDescById($data);
            if($data == $boardId){
                $sel = 'selected';
            }
            else{
                $sel = '';
            }
            echo CHtml::tag('option', array('value' => $key,'selected'=> $sel), CHtml::encode($boardName['board_desc']), true);
        }
    }
    public function actionDynamicpassoutyearandmonth()
    {
        $currentYear = date('Y');
        $currentMonth = date('n');
        $return = array();
        $boardDetail = LookupBoardEquivalent::getBoardDetailById($_POST['StudentSignup']['present_board_ref_id']);

        switch ($_POST['StudentSignup']['present_studylevel']) {
            case '10p' || '9p':
                switch ($boardDetail['board_ref_id']) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return[0] = CHtml::tag('option', array('value' => 2),  CHtml::encode('February'), true);
                        if ($currentMonth <= 2) {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear+2),  CHtml::encode($currentYear+2), true);
                        } else {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear+3),  CHtml::encode($currentYear+3), true);
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return[0] =  CHtml::tag('option', array('value' => 6),  CHtml::encode('June'), true);
                        if ($currentMonth <= 6) {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear+2),  CHtml::encode($currentYear+2), true);
                        } else {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear+3),  CHtml::encode($currentYear+3), true);
                        }
                        break;
                }
                break;
            case '11p':
                switch ($boardDetail['board_ref_id']) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return[0] =  CHtml::tag('option', array('value' => 2),  CHtml::encode('February'), true);
                        if ($currentMonth <= 2) {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear+1),  CHtml::encode($currentYear+1), true);
                        } else {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear+2),  CHtml::encode($currentYear+2), true);
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return[0] =  CHtml::tag('option', array('value' => 6),  CHtml::encode('June'), true);
                        if ($currentMonth <= 6) {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear+1),  CHtml::encode($currentYear+1), true);
                        } else {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear+2),  CHtml::encode($currentYear+2), true);
                        }
                        break;
                }
                break;
            case '12p':
                switch ($boardDetail['board_ref_id']) {
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 7:
                        $return[0] =  CHtml::tag('option', array('value' => 2),  CHtml::encode('February'), true);
                        if ($currentMonth <= 2) {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear),  CHtml::encode($currentYear), true);
                        } else {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear+1),  CHtml::encode($currentYear+1), true);
                        }
                        break;
                    case 5:
                    case 6:
                    case 8:
                        $return[0] =  CHtml::tag('option', array('value' => 6),  CHtml::encode('June'), true);
                        if ($currentMonth <= 6) {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear),  CHtml::encode($currentYear), true);
                        } else {
                            $return[1] = CHtml::tag('option', array('value' => $currentYear+1),  CHtml::encode($currentYear+1), true);
                        }
                        break;
                }
                break;
            case '12c':
                $yearlist = UniversityHelper::completeYear($_POST['StudentSignup']['present_studylevel']);
                $return[] = CHtml::tag('option', array('value' => ''), CHtml::encode('12th Completion Year'), true);
                foreach ($yearlist as $key => $value) {
                    $return[] = CHtml::tag('option', array('value' => $value), CHtml::encode($value), true);
                }
            break;
        }
        echo CJSON::encode($return);
    }

    public function actionGetBoardList()
    {
        $schoolName = $_POST['school_name'];
        $schoolHiddenId = $_POST['school_id'];
        $signUpModel = new StudentSignup();

        $userBoardList = $signUpModel->getBoardListBySchoolName($schoolName, $schoolHiddenId);
        //print_r($userBoardList);die;
        echo CHtml::tag('option', array('value' => ''), CHtml::encode('--Select Board--'), true);
        if (count($userBoardList) > 0 && $_POST['school_name'] != '') {
            foreach ($userBoardList as $key => $value) {
                echo CHtml::tag('option', array('value' => $value['board_id']), CHtml::encode($value['board_desc']), true);
            }
        } else {
            $boardlookup = new LookupBoard;
            $boardList = CHtml::listData($boardlookup->findAll(), 'board_id', 'board_desc');
            foreach ($boardList as $key => $value) {
                echo CHtml::tag('option', array('value' => $key), CHtml::encode($value), true);
            }
        }
    }

    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'postRegistration') {
            echo CActiveForm::validate($model);
        
            Yii::app()->end();
        }
    }

    public function actionAjaxDisplayMasterSchool()
    {
        $schoolId = Yii::app()->request->getPost('schoolId');
        $type = Yii::app()->request->getPost('type');
        $emailId = Yii::app()->request->getPost('emailId');
        $studentSignupModel = new StudentSignup;
        if (!empty($type) && $type == 'yes') {
            $schoolData = $studentSignupModel->getSchoolNameBySchoolid($schoolId);
            $fldschool_name = $schoolData->school_name;
            $fldschool_id = $schoolData->school_id;
            echo "$fldschool_name|$fldschool_id \n";

        } else {
            $result = $studentSignupModel->deleteStudentFromStudentMaster($emailId);
        }
    }


    public function printr($array = array())
    {
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }


    public function actionSchools()
    {
        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        if ($term) {
            $res = LookupSchool::model()->findAll(array('condition' => 'school_name like "%' . $term . '%" AND user_entered <> 1 ', 'limit' => '10', 'order' => 'CASE WHEN school_name LIKE "' . $term . '%" THEN 0 ELSE 1 END, length(school_name), school_name'));
            $val = array();
            if ($res) {
                foreach ($res as $r) {
                    $val[] = $r->attributes['school_name'];
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }

    public function actionCountryPreference()
    {
        //echo Yii::app()->session->get('firstTimeSignup'); exit;
        $this->setPageTitle(Yii::app()->name .' - Choose a session start period and country preference');
        $studentSignupModel = new StudentSignup('b2cCountryPref');
        $this->performAjaxValidation($studentSignupModel);
        
        
        $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
        $tabUrls = LookupUrl::getB2CTabUrl();
        foreach($tabUrls as $tabUrl){
            if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
            } else {
                $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
            }
        }
        
        $userInfo = TblUserMaster::getUserInformation($this->userId);
        $userPresentClass = $userInfo['present_class'] . strtolower($userInfo['class_status'][0]);


        $yearList = array();
        $yearList = UniversityHelper::completeYear($userPresentClass);
        //$yearList = $this->completeYear('10p');
        $this->likelyStartPeriodYear = $yearList[0];
        $yearList = array_combine($yearList, $yearList);

        
        
        //Likely Start Period _START
        $model = new LookupLikelyPeriod;
        $data = $model->findAll();

        foreach ($data as $likelyPreferredPeriod) {
            $preferredPeriod = $likelyPreferredPeriod->attributes;
            $rangeArray = range($preferredPeriod['from_month'], $preferredPeriod['to_month']);
            foreach ($rangeArray as $month) {
                $startPeriodMonths[$month] = date('F', strtotime(date('Y-' . $month . '-1')));
                $preferredPeriodMonthRelationArray[$month]['start'] = $preferredPeriod['from_month'];
                $preferredPeriodMonthRelationArray[$month]['end'] = $preferredPeriod['to_month'];
                $preferredPeriodMonthRelationArray[$month]['period_id'] = $preferredPeriod['period_id'];
            }
        }
        $startPeriodMonths = array_unique($startPeriodMonths);

        $preferredYear = UniversityHelper::LikelyStartYearList($userInfo['passout_year']);
        $likelyStartPeriodYear = array_shift(array_values($preferredYear));

        // add one month in 12 completed year and month for strart likely period
        $nextMonthTime = strtotime($likelyStartPeriodYear."-". $userInfo['passout_month'] ."-01");
        $newLikelyPeriod = strtotime(date("Y-m-d", strtotime("+1 month", $nextMonthTime)));

        $studentSignupModel->likely_start_period_month  = (int)date("m", $newLikelyPeriod);
        $studentSignupModel->likely_start_period_year = date("Y", $newLikelyPeriod);
        
        //Likely Start Period _END
        
        /*die($this->printr($data));
                $preferredPeriodMonthRelationArray = array();
                $preferredYear = array();
                $startPeriodMonths = array();
                foreach($preferredPeriods as $key => $val){
                    $dateSplit = explode('-', $key);
                    $rangeArray = range($dateSplit[0], $dateSplit[1]);
                    $preferredYear[$dateSplit[2]] = $dateSplit[2];
                    foreach($rangeArray as $month){
                        $startPeriodMonths[$month] = date('F', strtotime(date('Y-'.$month.'-1')));
                        //$preferredPeriodMonthRelationArray[$month] = $dateSplit[0].'-'.$dateSplit[1];
                        $preferredPeriodMonthRelationArray[$month]['start'] = $dateSplit[0];
                        $preferredPeriodMonthRelationArray[$month]['end'] = $dateSplit[1];
                    }

                }*/

        
        //Getting Student Interested Countries List order by Country name
        $countryList = TblCountryMaster::getStudentInterestedCountryList();
        $countryData = CHtml::listData($countryList, 'country_id', 'country_name');

        $allCountryList = TblCountryMaster::getCountryList();
        $uniqueCountryList = array_diff($allCountryList, $countryData);
        $countryData['Others'] = $uniqueCountryList;
        
        
        $studentPreferredCountryList = StudentPreferredCountry::getStudentPreferredCountryDetails($this->userId);
        foreach ($studentPreferredCountryList as $prefCountry) {
            if ($prefCountry->attributes['not_sure'] == 1) {
                $studentSignupModel->{country_not_sure} = 'Y';
            } else {
                $studentSignupModel->{country_pref . $prefCountry->attributes['preference_order']} = $prefCountry->attributes['country_ref_id'];
            }
        }

        if (isset($_POST['StudentSignup'])) {
            $studentSignupModel->attributes = $_POST['StudentSignup'];
            $postData = Yii::app()->request->getPost('StudentSignup');

            if (count($postData) > 0) {
                for ($i = 1; $i <= 3; $i++) {
                    $countryPrefArr[] = $postData['country_pref' . $i];
                }
                $countryPrefArr = array_values(array_filter($countryPrefArr));
                for ($i = 0; $i < 3; $i++) {
                    $postData['country_pref' . ($i + 1)] = (isset($countryPrefArr[$i])) ? $countryPrefArr[$i] : '';
                }
                foreach ($studentSignupModel->attributes as $key => $value) {
                    $studentSignupModel->{$key} = $postData[$key];
                }
            }

            if ($studentSignupModel->validate()) {

                //updating tbl_user_master with present_month and present_year values
                /*TblUserMaster::updateUserFields($this->userId, array('passout_month' => $postData['passout_month'],
                        'passout_year' => $postData['passout_year'])
                );*/
//die($this->printr($postData));
                //updating student_preferred_period
                /*StudentPreferredPeriod::model()->deleteAllByAttributes(array(user_ref_id => $this->userId));
                $fromMonth = $preferredPeriodMonthRelationArray[$postData['likely_start_period_month']]['start'];
                $toMonth = $preferredPeriodMonthRelationArray[$postData['likely_start_period_month']]['end'];
                $periodRefId = $preferredPeriodMonthRelationArray[$postData['likely_start_period_month']]['period_id'];

                $modelPreferedPeriod = new StudentPreferredPeriod();
                $updateValues = array('user_ref_id' => $this->userId,
                                      'from_month' => $fromMonth, 'to_month' => $toMonth, 'year' => $postData['likely_start_period_year'],
                                      'period_ref_id' => $periodRefId, 'added_on' => date('Y-m-d H:i:s')
                );
                $modelPreferedPeriod->attributes = $updateValues;
                if ($modelPreferedPeriod->save(false)) {
                    $criticalFields = array('likely_start_period' => 1);
                    TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                    CommonUtils::calculateCriticalPercentage($this->userId);
                }*/
                //Saving Student Preferred Period _START
                $studentPreferredPeriodRef = array();
                $prefPeriodRel = array();
                $startPeriodMonth = $postData['likely_start_period_month'];
                $startPeriodYear = $postData['likely_start_period_year'];
                for ($i = $startPeriodMonth; ; $i++) {
                    if (count($studentPreferredPeriodRef) == 3) {
                        break;
                    } else {
                        if (isset($preferredPeriodMonthRelationArray[$i]) && (!in_array($preferredPeriodMonthRelationArray[$i]['period_id'], $studentPreferredPeriodRef))) {
                            $studentPreferredPeriodRef[] = $preferredPeriodMonthRelationArray[$i]['period_id'];
                            $prefPeriodRel[] = array(
                                'from_month' => $preferredPeriodMonthRelationArray[$i]['start'],
                                'to_month' => $preferredPeriodMonthRelationArray[$i]['end'],
                                'year' => $startPeriodYear,
                                'period_ref_id' => $preferredPeriodMonthRelationArray[$i]['period_id'],
                                'user_ref_id' => $this->userId,
                                'added_on' => date('Y-m-d H:i:s'),
                            );
                        }
                    }
                    if ($i == 12) {
                        $i = 0;
                        $startPeriodYear++;
                    }
                }
                StudentPreferredPeriod::model()->deleteAll(array("condition" => "user_ref_id = '" . $this->userId . "'"));
                foreach ($prefPeriodRel as $preferredPeriod) {
                    StudentPreferredPeriod::addStudentPreferences($preferredPeriod);
                }
                $flagCriticalLikelyStartPeriod = 1;
                //Saving Student Preferred Period _END

                /*foreach ($postData['likely_start_period'] as $startPeriods) {
                    $startPeriod = explode('-', $startPeriods);
                    $modelPreferedPeriod = new StudentPreferredPeriod();
                    $modelPreferedPeriod->attributes = array('user_ref_id' => $this->userId,
                        'from_month' => $startPeriod[0], 'to_month' => $startPeriod[1], 'year' => $startPeriod[2],
                        'added_on' => date('Y-m-d H:i:s')
                    );
                    if ($modelPreferedPeriod->save(false)) {
                        $criticalFields = array('likely_start_period' => 1);
                        TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                    }
                }*/

                //updating student preferred country details
                StudentPreferredCountry::model()->deleteAllByAttributes(array(user_ref_id => $this->userId));
                for ($i = 1; $i <= 3; $i++) {
                    if (isset($postData['country_pref' . $i]) && $postData['country_pref' . $i] != '') {
                        $modelPreferedCountry = new StudentPreferredCountry();
                        $modelPreferedCountry->attributes = array('user_ref_id' => $this->userId,
                                                                  'country_ref_id' => $postData['country_pref' . $i], 'preference_order' => $i,
                                                                  'added_on' => date('Y-m-d H:i:s')
                        );
                        if ($modelPreferedCountry->save(false)) {
                            $criticalFields = array('country' => 1, 'likely_start_period' => 1);
                            TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                            CommonUtils::calculateCriticalPercentage($this->userId);
                        }
                    }
                }
                $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'signup',
                                                             'class_level' => 0,
                                                             'type_of_field' => 'critical',
                                                             'label' => 'b2c_dept_pref',
                                                       ),
                    1);
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'country preferences'));
                $this->redirect($urlDetails[0]['url']);
                //$this->redirect($urlDetails[0]['url'] . '/loginId/' . $this->loginRefId . '/userId/' . $this->userId);

            }
        } else {
            CommonUtils::isSignupStepComplete($this->userId);
        }

        $this->render("country_pref", array('userMasterModel' => $studentSignupModel,
                                            'year' => $yearList,
                                            'preferredPeriods' => $preferredPeriods,
                                            'countryData' => $countryData,
                                            'preferredMonths' => $startPeriodMonths,
                                            'preferredYear' => $preferredYear,
                                            'otherCountryList' => $otherCountryList,
                                            'urlArr' => $urlArr,
                                      )
        );
    }

    public function displayStudentPreferedPeriods($data, $studentPrefPeriodArr)
    {
        $preferredPeriodsArray = array();
        $currentYear = $this->likelyStartPeriodYear;
        //calculating course end year for 1.5years
        //$oneAndHalfYearTimeStamp = (strtotime('1 years 6 months', strtotime($currentYear.'-'.date('m-d'))));
        $oneAndHalfYearTimeStamp = (strtotime('2 years', strtotime($currentYear . '-' . date('m-d'))));
        $courseEndYear = date('Y', $oneAndHalfYearTimeStamp);
        //$courseEndMonth = date('m', $oneAndHalfYearTimeStamp);

        $liHTML = '<ul >';
        for ($y = $currentYear; $y <= $courseEndYear; $y++) {
            foreach ($data as $d) {
                $startPeriodArr = $d->attributes;
                if (strtotime($y . '-' . $startPeriodArr['from_month'] . '-1') < $oneAndHalfYearTimeStamp) {
                    $currentPref = $startPeriodArr['from_month'] . '-' . $startPeriodArr['to_month'] . '-' . $y;
                    $styleClass = 'uncheck';
                    if (in_array($currentPref, $studentPrefPeriodArr)) {
                        $styleClass = 'check';
                        //$this->studentPrefHtml .= '<div rel="' . $currentPref . '" class="selectedfield small pad_5 border_radius_16 left light_green strong"><span>' . $startPeriodArr['months'] . ' ' . $y . '</span><span class="close">&nbsp;</span> </div>';
                        //$this->studentPrefCSV[] = $currentPref;
                    }
                    $liHTML .= '<li class="left ' . $styleClass . '" rel="' . $currentPref . '">' . $startPeriodArr['months'] . ' ' . $y . '</li>';
                    $preferredPeriodsArray[$currentPref] = $startPeriodArr['months'] . ' ' . $y;
                }
                /*if (!($startPeriodArr['from_month'] < date('n') && $y == date('Y'))) {
                    $currentPref = $startPeriodArr['from_month'] . '-' . $startPeriodArr['to_month'] . '-' . $y;
                    $styleClass = 'uncheck';
                    if (in_array($currentPref, $studentPrefPeriodArr)) {
                        $styleClass = 'check';
                        $this->studentPrefHtml .= '<div rel="' . $currentPref . '" class="selectedfield small pad_5 border_radius_16 left light_green strong"><span>' . $startPeriodArr['months'] . ' ' . $y . '</span><span class="close">&nbsp;</span> </div>';
                        $this->studentPrefCSV[] = $currentPref;
                    }
                    $liHTML .= '<li class="left ' . $styleClass . '" rel="' . $currentPref . '">' . $startPeriodArr['months'] . ' ' . $y . '</li>';
                }*/
            }
        }
        //return $liHTML;
        return $preferredPeriodsArray;
    }

    /*
	 * Returns JS Base URL
	 */
    public function jsBaseUrl()
    {
        return Yii::app()->request->baseUrl;
    }

    public function actionCountry()
    {
        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        if ($term) {
            $criteria = new CDbCriteria;
            $criteria->condition = "is_stud_interested = 'N' and country_name like '%" . $term . "%'";
            $criteria->limit = 10;
            $criteria->order = "CASE WHEN country_name LIKE '" . $term . "%' THEN 0 ELSE 1 END, country_name";
            $res = CountryMaster::model()->findAll($criteria);
            $val = array();
            if ($res) {
                foreach ($res as $r) {
                    $r2 = $r->attributes;
                    $r2['value'] = $r->attributes['country_name'];
                    $val[] = $r2;
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }

    public function actionDepartmentPreference()
    {
        $this->getUserSessionInfo();
        $this->userInfo = TblUserMaster::getUserDetails($this->userId);

        if ($this->userInfo->membership_ref_id == 2) {
            $scenario = 'cssMajorPreferences';
            
            $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
            $tabUrls = LookupUrl::getB2BTabUrl();
            foreach($tabUrls as $tabUrl){
                if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                    $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
                } else {
                    $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
                }
            }
            
        } else {
            $scenario = 'b2cDeptPref';
            
            $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
            $tabUrls = LookupUrl::getB2CTabUrl();
            foreach($tabUrls as $tabUrl){
                if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                    $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
                } else {
                    $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
                }
            }
        }

        $this->setPageTitle(Yii::app()->name .' - Choose a major of study');
        $studentSignupModel = new StudentSignup($scenario);
        $this->performAjaxValidation($studentSignupModel);

        //Getting departments order by department name
        $departmentsList = LookupDepartment::getMainDepartmentList();
        //$this->printr($departmentsList);

        foreach ($this->userInfo->studentPreferredDepartments as $prefDepartment) {
            if ($prefDepartment->attributes['not_sure'] == 1) {
                $studentSignupModel->{department_not_sure} = 'Y';
            } else {
                $studentSignupModel->{dept_pref . $prefDepartment->attributes['preference_order']} = $prefDepartment->attributes['main_dept_ref_id'];
                $studentSignupModel->{sub_dept_pref . $prefDepartment->attributes['preference_order']} = $prefDepartment->attributes['sub_dept_ref_id'];
            }
        }

        if (isset($_POST) && $_POST['butSubmit'] == 'Save') {
            $studentSignupModel->attributes = $_POST['StudentSignup'];
            //$this->printr($studentSignupModel->attributes);
            $postData = Yii::app()->request->getPost('StudentSignup');

            if (count($postData) > 0) {
                for ($i = 1; $i <= 3; $i++) {
                    $deptPrefArr[] = $postData['dept_pref' . $i];
                }
                $deptPrefArr = array_values(array_filter($deptPrefArr));
                for ($i = 0; $i < 3; $i++) {
                    $postData['dept_pref' . ($i + 1)] = (isset($deptPrefArr[$i])) ? $deptPrefArr[$i] : '';
                }
                foreach ($studentSignupModel->attributes as $key => $value) {
                    $studentSignupModel->{$key} = $postData[$key];
                }
            }

            if ($studentSignupModel->validate()) {

                //updating student preferred country details
                StudentPreferredDepartment::model()->deleteAllByAttributes(array(user_ref_id => $this->userId));
                $dbTransactionStatus = false;
                if (@$postData['department_not_sure'] == 'Y') {
                    $model = new StudentPreferredDepartment();
                    $model->user_ref_id = $this->userId;
                    $model->not_sure = 1;
                    if ($model->save(false)) {
                        $dbTransactionStatus = true;
                    }
                } else {
                    for ($i = 1; $i <= 3; $i++) {
                        if (isset($postData['dept_pref' . $i]) && $postData['dept_pref' . $i] != '') {
                            $modelPreferredDepartment = new StudentPreferredDepartment();
                            $modelPreferredDepartment->attributes = array('user_ref_id' => $this->userId,
                                                                          'main_dept_ref_id' => $postData['dept_pref' . $i],
                                                                          'sub_dept_ref_id' => $postData['sub_dept_pref' . $i],
                                                                          'preference_order' => $i,
                                                                          'added_on' => date('Y-m-d H:i:s')
                            );
                            if ($modelPreferredDepartment->save(false)) {
                                $dbTransactionStatus = true;
                            }
                        }
                    }
                }

                if ($dbTransactionStatus) {
                    $criticalFields = array('intended_subjects' => 1);
                    TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                    CommonUtils::calculateCriticalPercentage($this->userId);

                    setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'major preferences'));
                    if ($this->userInfo->membership_ref_id == 2) {
                        $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'profile',
                                                                     'class_level' => 12,
                                                                     'type_of_field' => 'critical',
                                                                     'label' => 'b2b_edu_study_level',
                                                               ),
                            1);
                        $redirectUrlRefId = $urlDetails[0]['url_id'];
                        TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));
                        $this->redirect($urlDetails[0]['url']);
                    } else {
                        //Yii::app()->session['isCompleteSignupNecessarySteps'] = '1'; // if this variable is set then user will get link on each tab
                        $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'signup',
                                                                     'class_level' => 0,
                                                                     'type_of_field' => 'critical',
                                                                     'label' => 'b2c_aspiration_list',
                                                               ),
                            1);
                        $redirectUrlRefId = $urlDetails[0]['url_id'];
                        TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));
                        $this->redirect($urlDetails[0]['url']);
                    }
                }

                if(Yii::app()->session->itemAt('studentProfileConfirmationId')){
                    LoginMaster::updateProfileValidationField($this->loginRefId, 'is_preference_confirmed', 1, $this->userId);
                }

            }
        }else{
            CommonUtils::isSignupStepComplete($this->userId);
//            if ($this->userInfo->membership_ref_id == 2) {
//                CommonUtils::checkUserRedirection($this->userId, $this->action->Id);
//            }
        }

        $this->render("dept_pref", array('userMasterModel' => $studentSignupModel,
                                         'departmentsList' => $departmentsList,
                                         'urlArr' => $urlArr)
        );
        //die($this->loginRefId . "###" . $this->userId);
    }

    public function actionGetSubDeptList(){
        $deptId = Yii::app()->request->getQuery('deptId');
        $modelSubDept = LookupDepartment::getSubDepartmentsList($deptId);
        $subDeptList = CHtml::listData($modelSubDept,'department_id', 'department_name');
        echo json_encode($subDeptList);
    }

    public function actionGetSubDepartmentsPopularCourses()
    {
        $departmentId = Yii::app()->request->getQuery('deptId');
        $returnType = Yii::app()->request->getQuery('returnType');
        $returnArray = LookupDepartment::getSubDepartmentsPopularCourses($departmentId);

        if (strtolower($returnType) == 'json') {
            echo json_encode($returnArray);
        } else {
            return $returnArray;
        }
    }

    public function actionGetPopularCourses()
    {
        $result = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        if ($term) {
            //$res = LookupSchool::model()->findAll(array('condition' => 'school_name like "%' . $term . '%" AND user_entered <> 1 ', 'limit' => '10', 'order' => 'CASE WHEN school_name LIKE "' . $term . '%" THEN 0 ELSE 1 END, length(school_name), school_name'));
            $result = LookupPopularCourses::getPopularCoursesByName($term);
            $val = array();
            if ($result) {

                foreach ($result as $popularCourse) {
                    $popularCourseArr = array();
                    //$popularCourseArr['main_dept_id'] = $popularCourse->departmentRef->attributes['main_dept_id'];
                    $popularCourseArr['department_id'] = $popularCourse->departmentRef->attributes['department_id'];
                    $popularCourseArr['popular_courses_id'] = $popularCourse->attributes['popular_courses_id'];
                    //$popularCourseArr['course_name'] = $popularCourse->attributes['course_name'];

                    $popularCourseArr['id'] = $popularCourse->departmentRef->attributes['main_dept_id'];
                    $popularCourseArr['value'] = $popularCourse->attributes['course_name'];

                    $val[] = $popularCourseArr; //$r->attributes['course_name'];
                    //$val[] = $popularCourse->attributes['course_name'];
                }
            }
        }
        echo CJSON::encode($val);
        Yii::app()->end();
    }


    public function getUserSessionInfo()
    {
     
        $this->userSession = @unserialize(Yii::app()->session->get('sUserUnivariety'));
        $this->userId = $this->userSession['UserId'];
        $this->loginRefId = Yii::app()->session->get('loginID');
    }

    public function actionAspirationCollege()
    { 
        $this->setPageTitle(Yii::app()->name .' - Choose colleges of your interest');
        $this->userInfo = TblUserMaster::getUserDetails($this->userId);
        
        if ($this->userInfo->membership_ref_id == 2) {
            $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
            $tabUrls = LookupUrl::getB2BTabUrl();
            foreach($tabUrls as $tabUrl){
                if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                    $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
                } else {
                    $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
                }
            }
        } else {
            $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
            $tabUrls = LookupUrl::getB2CTabUrl();
            foreach($tabUrls as $tabUrl){
                if( Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                    $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
                } else {
                    $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
                }
            }
        }
        
        
        if (isset($_POST) && $_POST['save']) {
            Yii::app()->session['isCompleteSignupNecessarySteps'] = '1'; // if this variable is set then user will get link on each tab
            $urlDetails = LookupUrl::getUrlByModel(array(
                                                        'class_level' => 12,
                                                        'label' => 'finish',
                                                    ), 1);
            $redirectUrlRefId = $urlDetails[0]['url_id'];
            TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));
            $this->redirect( $urlDetails[0]['url'] );
        } else {
            // check user already completed sign up process then redirect to dashboard
            CommonUtils::isSignupStepComplete($this->userId);
        }

        $studentSignupModel = new StudentSignup('b2cAspirationList');
        $this->performAjaxValidation($studentSignupModel);

        $studentPreferences = StudentPreferredUniversity::getStudentPreferredUniversities($this->userId);
        // StudentShortlistUniversity::addStudentShortListUniversity($aspireCollegeInfo, $this->loginRefId);

        //setFlashMessage('success_notify', 'globalnotifications.profile_info_updated',array('NAME' => 'College Interests'));
        $this->render('aspire_colleges', array('userMasterModel' => $studentSignupModel,
                                               'studentPreferences' => $studentPreferences,
                                                'urlArr' => $urlArr)
        );
    }


    public function actionCollegesList()
    {
        $res = array();
        $term = Yii::app()->getRequest()->getParam('term', false);
        $gender = Yii::app()->getRequest()->getParam('gender', false);
        $val = $this->getUniversityListByTerm($term, 'uni_name', $gender);
        echo CJSON::encode($val);
        Yii::app()->end();
    }

    public function getUniversityListByTerm($term = '', $returnField = 'uni_name', $gender = '')
    {
        $val = array();
        if ($term) {
            $res = TblUniversityMaster::getSuggestionList($term, 0, 10, $gender);
            if ($res) {
                foreach ($res as $r) {
                    $val[] = html_entity_decode($r->attributes[$returnField], ENT_QUOTES);
                }
            }
        }
        return $val;
    }

    public function actionAddAspirationCollege()
    {
        //$this->getUserSessionInfo();
        //echo "####".$this->userId;

        $studentSignupModel = new StudentSignup('b2cAspirationList');
        $this->performAjaxValidation($studentSignupModel);

        if (isset($_POST['StudentSignup'])) {
            $modelStudentPrefUni = StudentPreferredUniversity::model()->findAll('user_ref_id=' . $this->userId);
            if (count($modelStudentPrefUni) < 3) {
                $studentSignupModel->attributes = $_POST['StudentSignup'];
                $postData = Yii::app()->request->getPost('StudentSignup');
                $aspireCollegeInfo = array();
                $universityInfo = $this->getUniversityListByTerm($postData['aspire_college'], 'uni_id');
                if (trim($postData['aspire_college']) != '') {
                    if (count($universityInfo) > 0) {
                        $aspireCollegeInfo['university_ref_id'] = $universityInfo[0];
                    } else {
                        $aspireCollegeInfo['university_name'] = $postData['aspire_college'];
                    }
                    $aspireCollegeInfo['user_ref_id'] = $this->userId;
                    // StudentPreferredUniversity::addStudentAspireCollege($aspireCollegeInfo, $this->loginRefId);
                    StudentShortlistUniversity::addStudentShortListUniversity($aspireCollegeInfo, $this->loginRefId);
                }
                $this->userInfo = TblUserMaster::getUserDetails($this->userId);

//                if($this->userInfo->membership_ref_id == 2){
//
//                    if($this->userInfo->present_class == 12 || $this->userInfo->present_class == 11){
//                        $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,
//                                                                     'label' => 'dashboard',
//                                                               ),
//                            1);
//
//                        $redirectUrlRefId = $urlDetails[0]['url_id'];
//                        TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));
//                    }else{
//                        //for 9p & 10p students
//                    }
//                }

            }
        }
        $studentPreferences = StudentPreferredUniversity::getStudentPreferredUniversities($this->userId);
        echo $this->prepareUserPrefAsHtml($studentPreferences);
    }

    public function prepareUserPrefAsHtml($userPref = array())
    {
        $html = '';
        $cssArray = array(1 => array('one', 'First'), 2 => array('two', 'Second'), 3 => array('three', 'Third'));
        $i = 1;
        foreach ($userPref as $pref) {
            //<div class="alert general one"><div class="msg">Harvard University,  Cambridge, MA, USA</div><a class="toggle-alert" href="#">Toggle</a></div>
            $uniInfo = $pref['university_name'];
            $uniInfo .= ($pref['country_name'] != '') ? ', ' . $pref['country_name'] : '';
            $uniInfo .= ($pref['state_name'] != '') ? ', ' . $pref['state_name'] : '';
            $uniInfo .= ($pref['city_name'] != '') ? ', ' . $pref['city_name'] : '';

            $html .= '<div class="alert general ' . $cssArray[$i][0] . '"><div class="msg">' . $uniInfo . '</div><a class="toggle-alert" href="javascript:void(0)" onclick="removeStudentPref(' . $pref['preferred_university_id'] . ')">Toggle</a></div>';
            $i++;
        }
        for ($j = $i; $j <= 3; $j++) {
            $html .= '<div class="alert general"><div class="msg">' . $cssArray[$j][1] . ' college preference</div><a class="toggle-alert" href="javascript:void(0)" onclick="removeStudentPref(' . $pref['preferred_university_id'] . ')">Toggle</a></div>';
        }
        return $html;
    }

    public function actionDeleteStudentPrefUni()
    {
        $prefId = Yii::app()->request->getQuery('prefId');
        StudentPreferredUniversity::deleteStudentIdealList($this->userId, $prefId);
        //StudentPreferredUniversity::model()->deleteAll();
        $studentPreferences = StudentPreferredUniversity::getStudentPreferredUniversities($this->userId);
        echo $this->prepareUserPrefAsHtml($studentPreferences);
    }

    public function actionFinish()
    {
        $this->userInfo = TblUserMaster::getUserDetails($this->userId);
        
        if ($this->userInfo->membership_ref_id == 2) {
            $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
            $tabUrls = LookupUrl::getB2BTabUrl();
            foreach($tabUrls as $tabUrl){
                if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                    $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
                } else {
                    $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
                }
            }
        } else {
            $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
            $tabUrls = LookupUrl::getB2CTabUrl();
            foreach($tabUrls as $tabUrl){
                if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                    $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
                } else {
                    $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
                }
            }
        }
        
        $userContactInfo = StudentContactNumber::getFullContactNumbers($this->userId, 1);

        $studentSignupModel = new StudentSignup('finishPage');
        $this->performAjaxValidation($studentSignupModel);

        if($userContactInfo->country_code != '' && $userContactInfo->number != ''){
            $label = 'Please confirm your phone number below';
            $studentSignupModel->{alternate_phone_contry_code} = $userContactInfo->country_code;
            $studentSignupModel->{alternate_phone} = $userContactInfo->number;
            $disabled = true;
            $disableClass = 'disable';
        }else{
            $label = 'Please provide a phone number where we can contact you';
            $disabled = false;
            $disableClass = '';
        }

        $studentPreferences = StudentPreferredUniversity::getStudentPreferredUniversities($this->userId);
        if (isset($_POST) && $_POST['butSubmit'] == 'Finish') {
            //Yii::app()->session['isFinishClicked'] = '1'; // if this variable is set when user click on finish step
            $studentSignupModel->attributes = $_POST['StudentSignup'];
            $postData = Yii::app()->request->getPost('StudentSignup');
            if ($studentSignupModel->validate()) {
                if($_POST['StudentSignup']){
                    $contactDetails = array(
                        'contact_type_ref_id' => 1,
                        'country_code' => $postData['alternate_phone_contry_code'],
                        'number' => $postData['alternate_phone'],
                        'user_ref_id' => $this->userId,
                        'is_primary' => 1,
                        'added_on' => date('Y-m-d H:i:s'),
                        'added_by' => $this->loginRefId,
                        'phone_type' => 'Home',
                    );
                    $studentContactModel = StudentContactNumber::model()->find(array("condition" => "user_ref_id = $this->userId AND contact_type_ref_id = 1 AND is_primary = 1"));
                    if(!$studentContactModel){
                        $studentContactModel = new StudentContactNumber();
                        $studentContactModel->setAttributes($contactDetails);
                        $studentContactModel->added_on = date('Y-m-d H:i:s');
                        //echo "<br>NEW";
                        $studentContactModel->save(false);
                    }else{
                        $studentContactModel->setAttributes($contactDetails);
                        $studentContactModel->added_on = date('Y-m-d H:i:s');
                        //echo "<br>Updated";
                        $studentContactModel->save();
                    }
                    // we r tracking below info for gem propsect
                    $userInfo = TblUserMaster::model()->findByPk($this->userId);
                    if($userInfo->membership_ref_id == 2) // B2B student
                    {
                        /* $loginInfo = LoginMaster::model()->findByPk($this->loginRefId);
                        $gemLeadModel->email_id = $loginInfo->username;
                        $gemLeadModel = GemLead::model()->find(array("condition" => "email_id = '$gemLeadModel->email_id' "));
                        if(!$gemLeadModel){
                            $gemLeadModel = new GemLead();
                        }
                        $gemLeadModel->name = $userInfo->first_name.' '.$userInfo->last_name;
                        $gemLeadModel->phone_number = $postData['alternate_phone_contry_code'].$postData['alternate_phone'];;
                        $gemLeadModel->email_id = $loginInfo->username;
                        $gemLeadModel->gem_status = 'NotAssigned';
                        $gemLeadModel->save(false);

                        if($gemLeadModel->gem_lead_id){
                            $gemLeadProspectModel = GemLeadProspect::model()->find(array("condition" => "gem_lead_ref_id = '$gemLeadModel->gem_lead_id' "));
                            if(!$gemLeadProspectModel){
                                $gemLeadProspectModel = new GemLeadProspect();
                            }
                            $gemLeadProspectModel->gem_lead_ref_id = $gemLeadModel->gem_lead_id;
                            $gemLeadProspectModel->prospect_category_ref_id=16; //Sign up request
                            $gemLeadProspectModel->save(false);
                        }
                        */
                        $prospectModel = Prospect::model()->find(array("condition" => "user_ref_id = $this->userId "));
                        if(!$prospectModel){
                            $prospectModel = new Prospect();
                        }
                        $prospectModel->user_ref_id = $this->userId;
                        $prospectModel->prospect_status = 'NotAssigned';
                        $prospectModel->prospect_category_ref_id=16; //Sign up request
                        $prospectModel->added_on = date('Y-m-d H:i:s');
                        $prospectModel->assigned_date = null;
                        $prospectModel->save(false);
                    }

                    TblUserMaster::updateUserFields($this->userId, array('can_contact' => 1));

                    TblUserProfCriticalCompletion::updateCriticalFields($this->userId, array('phone' => 1));
                    CommonUtils::calculateCriticalPercentage($this->userId);

                }else{
                    TblUserMaster::updateUserFields($this->userId, array('can_contact' => 0));
                }
                
                $urlDetails = LookupUrl::getUrlByModel(array(
                                                        'class_level' => 0,
                                                        'label' => 'dashboard',
                                                    ), 1);
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));
                //$this->redirect( $urlDetails[0]['url'] );
                $this->redirect('/app/confirmation');

                //$this->redirect($_POST['redirectUrl']);
            }else{
                //die('234234324');
            }
        } else {
            // check user already completed sign up process then redirect to dashboard
            //if(Yii::app()->session->get('isFinishClicked') == 1) {
            CommonUtils::isSignupStepComplete($this->userId);
            //}
        }

        $this->render('finish_page', array('userMasterModel' => $studentSignupModel,
                                           'studentPreferences' => $studentPreferences,
                                           'contactInfoLabel' => $label,
                                           'disabled' => $disabled,
                                           'disableClass' => $disableClass,
                                           'userId' => $this->userId,
                                           'urlArr' => $urlArr,
                                     )
        );
    }
    
    public function actionAjaxFinish(){
        
        $userId = base64_decode(Yii::app()->request->getPost('submitComplete'));
        if($userId) {
            //Yii::app()->session['isFinishClicked'] = '1'; // if this variable is set when user click on finish step
            $urlDetails = LookupUrl::getUrlByModel(array(
                                                    'class_level' => 0,
                                                    'label' => 'dashboard',
                                                ), 1);
            $redirectUrlRefId = $urlDetails[0]['url_id'];
            TblUserMaster::updateUserFields($userId, array('redirect_url_ref_id' => $redirectUrlRefId));
            echo $urlDetails[0]['url']; 
        }
    }

    /*
	 * @params of aspireCollegeInfo['user_ref_id', 'department_id / main_dept_id', 'university_ref_id / university_name']
	 * if university_ref_id = NULL, system will add given university information into student_preferred_university table
	 * if 'department_id / main_dept_id' is available then system will insert the university and department as his 'Aspire' list.
	 * else if 'department_id / main_dept_id' is not available then system will check selected university[departments] with studdent_preferred_departments and insert the matched departments as his 'Aspire' list.
	 */
    public function actionAddStudentAspireCollege()
    {
        $aspireCollegeInfo = $_POST['aspireCollegeInfo'];
        $loginRefId = $_POST['loginRefId'];
        $departmentId = $_POST['department_id'];
        echo StudentPreferredUniversity::addStudentAspireCollege($aspireCollegeInfo, $loginRefId, $departmentId);
    }

    public function actionConfirmationEmail()
    {

        $this->pageTitle = Yii::app()->name . ' - Confirmation Email';

        if (Yii::app()->session->get('sUserUnivariety') != '') {
            $userSession = unserialize(Yii::app()->session->get('sUserUnivariety'));
            //Yii::app()->session->add('sUserUnivariety',serialize($userSession));
        }

        if (!empty($_POST)) {
            $this->sendConfirmationEmail($userSession['UserFullName'], $userSession['UserEmail']);
            ?>
        <script>window.location.href = window.location.href</script><?php
        }


        if (Yii::app()->session['sUserUnivariety'] != '') {
            $result = LoginMaster::getUserDetails($userSession['UserEmail']);
            if ($result['is_email_confirmed'] == 1)
                $this->redirect(Yii::app()->params['cbasepath'] . '/app/dashboard');
            else
                 $this->render('confirmationMail', array('userEmail' => $userSession['UserEmail']));
        } else {
            $this->render('confirmationMail', array('userEmail' => $userSession['UserEmail']));
        }
    }

    public function sendConfirmationEmail($firstName = false, $email = false, $userId)
    {
        //confirmation mail
       /* $siteURL = Yii::app()->params['cbasepath'];
        $result = LoginMaster::getUserDetails($email);
        $user = TblUserMaster::model()->findByAttributes(array('login_ref_id'=>$result['login_id']));
        $si = TblSiStudents::model()->find('user_ref_id = :ID', array(':ID'=>$user->user_id));
        if($si->inst_ref_id)
        {
            $inst_res = TblSiDi::model()->find('inst_id=:ID ',array(':ID' =>$si->inst_ref_id));
            $siteURL = $inst_res->subdomain_slug_name.'.'.ACTUALHOST;

        }*/

        Yii::import('application.components.StudentRegistration.php');
        $obj = new StudentRegistration();
        $obj->sendConfirmationEmail($userId);

        /*
        $s = empty($_SERVER['HTTPS']) ? '' : ($_SERVER['HTTPS'] == 'on') ? 's' : '';
        $protocol = strtolower($_SERVER['SERVER_PROTOCOL']);
        $protocol =  substr($protocol, 0, strpos($protocol, '/')). $s;
        $port = ($_SERVER['SERVER_PORT'] == '80') ? '' : (':'.$_SERVER['SERVER_PORT']);
        $siteURL = $protocol . '://' . $_SERVER['SERVER_NAME'];

        $msg = $this->renderPartial('confirmationTemplateMail', array('firstName' => $firstName, 'email' => $email, 'siteURL' => $siteURL), true);
        $params = array();
        $params['EmailMessage']['subject'] = 'Registration Confirmation';
        $params['EmailMessage']['body'] = $msg;
        $params['EmailMessage']['type'] = 'Signup';
        $params['EmailMessage']['siteUrl'] = '';
        $params['EmailMessage']['cc'] = '';
        $params['EmailMessage']['toName'] = $firstName;
        $params['EmailMessage']['toEmail'] = $email;
        $params['EmailMessage']['apiKey'] = Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;
        Yii::app()->user->setState('$_POST', $url);

        $status = Yii::app()->runController("sms/email/addMessage");
        */
    }

    public function actionThankyou($username = false)
    {
       $this->pageTitle = Yii::app()->name .' - Thank You';
       $result = LoginMaster::getUserDetails(base64_decode($username));
       $redirectUrl=$_GET['redirect'];
	   if($result)
	   {
			   $isEmailConfirmed =  $result['is_email_confirmed'];
			   LoginMaster::model()->updatebyPk($result['login_id'],array('is_email_confirmed'=>1));
               $user = TblUserMaster::model()->findByAttributes(array('login_ref_id'=>$result['login_id']));
               if ($user->user_id) {
                   $verify_score = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$user->user_id));
                   if ($verify_score->user_ref_id) {
                       $sum = $verify_score->profile_score+$verify_score->passout_year+$verify_score->board_10+$verify_score->board_12+$verify_score->marks_10+$verify_score->marks_12+$verify_score->marks_100+$verify_score->marks_above_95+$verify_score->marks_diff+$verify_score->subject_marks_10_100+$verify_score->subject_marks_12_100+$verify_score->pref_country+$verify_score->pref_country_score+$verify_score->pref_dept+$verify_score->pref_dept_score+$verify_score->contact_number;

                       if ($sum == 16) {
                           $date = date('Y-m-d H:i:s');
                           LoginMaster::model()->updatebyPk($result['login_id'],array('is_class_status_confirmed'=>1,'is_preference_confirmed'=>1,'is_valid'=>1,'validated_on'=>$date));
                       }
                   }
               }

			   $shortlist = new ShortListEngine();
			   $shortlist->profileUpdated();  		   
		       if($isEmailConfirmed == 0)
			   {
				   $loginObj = new LoginMaster;				 
				   $loginObj->skipPassword = true;
				   setFlashMessage('success_notify', 'globalnotifications.emailConfirmation');
                                   
                                    $urlDetails = LookupUrl::getUrlByModel(array('class_level' => 0,
                                                                                'label' => 'dashboard',
                                                                        ), 1);
                                    $redirectUrlRefId = $urlDetails[0]['url_id'];
                                    TblUserMaster::updateUserFields($result['user_id'], array('redirect_url_ref_id' => $redirectUrlRefId));
                   if($redirectUrl){
                       $loginObj->loginRedirect(base64_decode($username),'',base64_decode($redirectUrl));
                   }
                   if($redirectUrl == ''){
				   $loginObj->loginWithRedirect(base64_decode($username),'',"/app/dashboard");
                   }
			   }
			   else
			   {
				   setFlashMessage('success_notify', 'globalnotifications.alreadyConfirmed');
				   $this->redirect("/app/login");
			   }	
	       }	     
    }


    public function actionPreferences()
    {
        $this->setPageTitle(Yii::app()->name .' - Choose a country preference');
        $this->getUserSessionInfo();

        $this->userInfo = TblUserMaster::getUserDetails($this->userId);

        $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
        $tabUrls = LookupUrl::getB2BTabUrl();
        foreach($tabUrls as $tabUrl){
            if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
            } else {
                $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
            }
        }
        
        $studentSignupModel = new StudentSignup('cssPreferences');
        $this->performAjaxValidation($studentSignupModel);

        //Study Levels _START
        $this->courseLevel = LookupCourseLevel::getParentCourseLevel();
        $this->courseLevel = CHtml::listData($this->courseLevel, 'level_id', 'course_level');

        $i = 1;
        foreach ($this->userInfo->studentPreferredStudyLevels as $prefStudyLevel) {
            $studentSignupModel->{course_level . $i} = $prefStudyLevel->courseLevelRef->attributes['parent_ref_id'];
            $i++;
        }
        //Study Levels _END

        //Likely Start Period _START
        $model = new LookupLikelyPeriod;
        $data = $model->findAll();

        foreach ($data as $likelyPreferredPeriod) {
            $preferredPeriod = $likelyPreferredPeriod->attributes;
            $rangeArray = range($preferredPeriod['from_month'], $preferredPeriod['to_month']);
            foreach ($rangeArray as $month) {
                $startPeriodMonths[$month] = date('F', strtotime(date('Y-' . $month . '-1')));
                $preferredPeriodMonthRelationArray[$month]['start'] = $preferredPeriod['from_month'];
                $preferredPeriodMonthRelationArray[$month]['end'] = $preferredPeriod['to_month'];
                $preferredPeriodMonthRelationArray[$month]['period_id'] = $preferredPeriod['period_id'];
            }
        }
        $startPeriodMonths = array_unique($startPeriodMonths);

        $preferredYear = UniversityHelper::LikelyStartYearList($this->userInfo['passout_year']);
        $likelyStartPeriodYear = array_shift(array_values($preferredYear));

        // add one month in 12 completed year and month for strart likely period
        $nextMonthTime = strtotime($likelyStartPeriodYear."-". $this->userInfo->passout_month ."-01");
        $newLikelyPeriod = strtotime(date("Y-m-d", strtotime("+1 month", $nextMonthTime)));

        $studentSignupModel->likely_start_period_month  = (int)date("m", $newLikelyPeriod);
        $studentSignupModel->likely_start_period_year = date("Y", $newLikelyPeriod);
        
        //Likely Start Period _END

        //Country Preferences _START
        $countryList = TblCountryMaster::getStudentInterestedCountryList();
        $countryData = CHtml::listData($countryList, 'country_id', 'country_name');

        $allCountryList = TblCountryMaster::getCountryList();
        $uniqueCountryList = array_diff($allCountryList, $countryData);
        $countryData['Others'] = $uniqueCountryList;

        foreach ($this->userInfo->studentPreferredCountries as $prefCountry) {
            if ($prefCountry->attributes['not_sure'] == 1) {
                $studentSignupModel->{country_not_sure} = 'Y';
            } else {
                $studentSignupModel->{country_pref . $prefCountry->attributes['preference_order']} = $prefCountry->attributes['country_ref_id'];
            }
        }
        //Country Preferences _END

        //Study Duration _START
        $this->studyDuration = LookupDuration::getDurations();
        $this->studyDuration = CHtml::listData($this->studyDuration, 'duration_id', 'name');
        //Study Duration _END

        if (isset($_POST['StudentSignup'])) {
            $studentSignupModel->attributes = $_POST['StudentSignup'];
            $postData = Yii::app()->request->getPost('StudentSignup');

            $studyLevel = array_values(array_filter($postData['course_level']));
            for ($i = 0; $i < 2; $i++) {
                $postData['course_level' . ($i + 1)] = (isset($studyLevel[$i])) ? $studyLevel[$i] : '';
            }
            /*for($i=0; $i<count($studyLevel); $i++){
                $studentSignupModel->{course_level.($i+1)} = $studyLevel[$i];
            }*/

            for ($i = 1; $i <= 3; $i++) {
                $countryPrefArr[] = $postData['country_pref' . $i];
            }
            $countryPrefArr = array_values(array_filter($countryPrefArr));
            for ($i = 0; $i < 3; $i++) {
                $postData['country_pref' . ($i + 1)] = (isset($countryPrefArr[$i])) ? $countryPrefArr[$i] : '';
            }

            $studyDuration = array_values(array_filter($postData['study_duration']));
            for ($i = 0; $i < 2; $i++) {
                $postData['study_duration' . ($i + 1)] = (isset($studyDuration[$i])) ? $studyDuration[$i] : '';
            }

            foreach ($studentSignupModel->attributes as $key => $value) {
                $studentSignupModel->{$key} = $postData[$key];
            }

            if ($studentSignupModel->validate()) {
                $flagCriticalStudyLevel = $flagCriticalLikelyStartPeriod = $flagCriticalCountry = $flagCriticalPreferredCourseDuration = 0;

                //Saving Student Preferred Study Level _START
                StudentPreferredStudyLevel::deleteStudentPreferences($this->userId);
                StudentPreferredStudyLevel::addStudentPreferences($this->userId, $postData['course_level']);
                $flagCriticalStudyLevel = 1;
                //Saving Student Preferred Study Level _END

                //Saving Student Preferred Period _START
                $studentPreferredPeriodRef = array();
                $prefPeriodRel = array();
                $startPeriodMonth = $postData['likely_start_period_month'];
                $startPeriodYear = $postData['likely_start_period_year'];
                for ($i = $startPeriodMonth; ; $i++) {
                    if (count($studentPreferredPeriodRef) == 3) {
                        break;
                    } else {
                        if (isset($preferredPeriodMonthRelationArray[$i]) && (!in_array($preferredPeriodMonthRelationArray[$i]['period_id'], $studentPreferredPeriodRef))) {
                            $studentPreferredPeriodRef[] = $preferredPeriodMonthRelationArray[$i]['period_id'];
                            $prefPeriodRel[] = array(
                                'from_month' => $preferredPeriodMonthRelationArray[$i]['start'],
                                'to_month' => $preferredPeriodMonthRelationArray[$i]['end'],
                                'year' => $startPeriodYear,
                                'period_ref_id' => $preferredPeriodMonthRelationArray[$i]['period_id'],
                                'user_ref_id' => $this->userId,
                                'added_on' => date('Y-m-d H:i:s'),
                            );
                        }
                    }
                    if ($i == 12) {
                        $i = 0;
                        $startPeriodYear++;
                    }
                }
                StudentPreferredPeriod::model()->deleteAll(array("condition" => "user_ref_id = '" . $this->userId . "'"));
                foreach ($prefPeriodRel as $preferredPeriod) {
                    StudentPreferredPeriod::addStudentPreferences($preferredPeriod);
                }
                $flagCriticalLikelyStartPeriod = 1;
                //Saving Student Preferred Period _END

                //Saving Student Preferred Country _START
                StudentPreferredCountry::model()->deleteAll(array("condition" => "user_ref_id = '" . $this->userId . "'"));
                if (@$postData['country_not_sure'] == 'Y') {
                    $model = new StudentPreferredCountry();
                    $model->user_ref_id = $this->userId;
                    $model->not_sure = 1;
                    $model->save(false);
                } else {
                    for ($i = 1; $i <= 3; $i++) {
                        if ($postData['country_pref' . $i] != '') {
                            $model = new StudentPreferredCountry();
                            $model->user_ref_id = $this->userId;
                            $model->country_ref_id = $postData['country_pref' . $i];
                            $model->preference_order = $i;
                            $model->added_on = date('Y-m-d H:i:s');
                            $model->save(false);
                        }

                    }
                }
                $flagCriticalCountry = 1;
                //Saving Student Preferred Country _END

                //Saving Student Preferred Duration _START
                StudentPreferredDuration::model()->deleteAll(array("condition" => "user_ref_id = '" . $this->userId . "'"));
                for ($i = 1; $i <= 2; $i++) {
                    if($postData['study_duration' . $i] > 0){
                        $model = new StudentPreferredDuration();
                        $model->user_ref_id = $this->userId;
                        $model->duration_ref_id = $postData['study_duration' . $i];
                        $model->added_on = date('Y-m-d H:i:s');
                        $model->save(false);
                    }
                }
                $flagCriticalPreferredCourseDuration = 1;
                //Saving Student Preferred Duration _END

                if(Yii::app()->session->itemAt('studentProfileConfirmationId')){
                    LoginMaster::updateProfileValidationField($this->loginRefId, 'is_preference_confirmed', 1, $this->userId);
                }

                $criticalFields = array(
                    'country' => $flagCriticalCountry,
                    'likely_start_period' => $flagCriticalLikelyStartPeriod,
                    'study_level' => $flagCriticalStudyLevel,
                    'preferred_course_duration' => $flagCriticalPreferredCourseDuration,
                );
                TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                CommonUtils::calculateCriticalPercentage($this->userId);

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'country preferences'));

                $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'profile',
                                                             'class_level' => 12,
                                                             'type_of_field' => 'critical',
                                                             'label' => 'intended_subjects',
                                                       ),
                    1);
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));
                $this->redirect($urlDetails[0]['url']);
            }
        }else{
            CommonUtils::isSignupStepComplete($this->userId);
        }

        //$this->printr($postData);

        $this->render('css_preferences', array('userMasterModel' => $studentSignupModel,
                                               'preferredMonths' => $startPeriodMonths,
                                               'preferredYear' => $preferredYear,
                                               'countryData' => $countryData,
                                               'urlArr' => $urlArr,
                                         ));
    }
    
    public function get10AutoPopulateData($presentClassLevel) {
        $educationDetail10 = StudentEducation::getStudentEducationDetails($this->userId, 10);
        
        $this->studentClassDetails[10]['schoolName'] = $this->userInfo->schoolRef->school_name;
        
        if( $educationDetail10 ) {
            $this->studentClassDetails[10]['board'] = $educationDetail10->board_ref_id;
            $boardDetails = LookupBoardEquivalent::GetBoardDetails(10, $educationDetail10->board_ref_id);

            $this->studentClassDetails[10]['overallMax'] = $boardDetails['overall_max'];
            $this->studentClassDetails[10]['subjectMax'] = $boardDetails['subject_max'];
            $this->studentClassDetails[10]['overallType'] = strtolower($boardDetails['overall_type']);
            $this->studentClassDetails[10]['lookupBoardId'] = $boardDetails['board_ref_id'];
            $this->studentClassDetails[10]['classLevel'] = 10;

            $this->studentClassDetails[10]['schoolName'] = $educationDetail10->school_name;
            $this->studentClassDetails[10]['completeMonth'] = $educationDetail10->month;
            $this->studentClassDetails[10]['completeYear'] = $educationDetail10->year;

            if(strtolower($boardDetails['overall_type']) == "grades") {
                $gradeEducation = StudentEducation::getGradeDetail(10, $this->userId);
                foreach($gradeEducation as $gradeData){
                    foreach($gradeData->studentGradeCounts as $grades) {
                        $gradeMarksArr[$grades->grade_ref_id] = $grades->grade_count;
                    }
                }
                $this->studentClassDetails[10]['overallMarks'] = $gradeMarksArr;
            } else {
                $this->studentClassDetails[10]['overallMarks'] = $educationDetail10->overall_marks;
            }

            $showSubjectFlag = 0;
            $studentPreferredDepartments = $this->userInfo->studentPreferredDepartments;
            if (count($studentPreferredDepartments) > 0) {
                foreach ($studentPreferredDepartments as $deptPref) {
                    $departmentId = $deptPref->attributes['main_dept_ref_id'];
                    $this->studentPreferredDepartmentIds[] = $departmentId;
                    if($departmentId == 74 || $departmentId == 55 || $departmentId == 23) {
                        $showSubjectOfFilterDept[] = $departmentId;
                        $showSubjectFlag = 1;
                    }
                }
            }

            $this->studentPreferredDepartmentIds = array_filter($this->studentPreferredDepartmentIds);
            $this->studentClassDetails[10]['subjectsList'] = array();
            if( $educationDetail10->board_ref_id && $showSubjectFlag ) {
                $this->studentClassDetails[10]['subjectsList'] = LookupStudentSubject::getPreferredSubjectsByDepartment($educationDetail10->board_ref_id, $showSubjectOfFilterDept);
            }

            $educationSubjectData = StudentEducation::getSubjectDetail(10, $this->userId);
            $studentSubjectArr = array();
            foreach($educationSubjectData as $subjectsData) {
                foreach($subjectsData->studentEducationDetails as $subject) {
                    if(strtolower($boardDetails['overall_type']) == "grades" || strtolower($boardDetails['overall_type']) == "marks-gpa") {
                        $studentSubjectArr[$subject->student_subject_ref_id] =  $subject->grade_ref_id;
                    } else {
                        $studentSubjectArr[$subject->student_subject_ref_id] =  $subject->marks;
                    }
                }
            }
            if(count($studentSubjectArr)) {
                $this->studentClassDetails[10]['subjects'] = $studentSubjectArr;
            }
        }
    }
    
    public function get12AutoPopulateData($presentClassLevel) {
        $educationDetail12 = StudentEducation::getStudentEducationDetails($this->userId, 12);
        if( $educationDetail12 ) {
            $this->studentClassDetails[12]['board'] = $educationDetail12->board_ref_id;
            $boardDetails = LookupBoardEquivalent::GetBoardDetails(12, $educationDetail12->board_ref_id);

            $this->studentClassDetails[12]['overallMax'] = $boardDetails['overall_max'];
            $this->studentClassDetails[12]['subjectMax'] = $boardDetails['subject_max'];
            $this->studentClassDetails[12]['overallType'] = strtolower($boardDetails['overall_type']);
            $this->studentClassDetails[12]['lookupBoardId'] = $boardDetails['board_ref_id'];
            $this->studentClassDetails[12]['classLevel'] = 12;

            if(strtolower($boardDetails['overall_type']) == "grades") {
                $gradeEducation = StudentEducation::getGradeDetail(12, $this->userId);
                foreach($gradeEducation as $gradeData){
                    foreach($gradeData->studentGradeCounts as $grades) {
                        $gradeMarksArr[$grades->grade_ref_id] = $grades->grade_count;
                    }
                }
                $this->studentClassDetails[12]['overallMarks'] = $gradeMarksArr;
            } else {
                $this->studentClassDetails[12]['overallMarks'] = $educationDetail12->overall_marks;
            }

            $showSubjectFlag = 0;
            $studentPreferredDepartments = $this->userInfo->studentPreferredDepartments;
            if (count($studentPreferredDepartments) > 0) {
                foreach ($studentPreferredDepartments as $deptPref) {
                    $departmentId = $deptPref->attributes['main_dept_ref_id'];
                    $this->studentPreferredDepartmentIds[] = $departmentId;
                    if($departmentId == 74 || $departmentId == 55 || $departmentId == 23) {
                        $showSubjectOfFilterDept[] = $departmentId;
                        $showSubjectFlag = 1;
                    }
                }
            }
            
            $this->studentPreferredDepartmentIds = array_filter($this->studentPreferredDepartmentIds);
            $this->studentClassDetails[12]['subjectsList'] = array();
            if($educationDetail12->board_ref_id && $showSubjectFlag && $presentClassLevel == "12Completed") {
                $this->studentClassDetails[12]['subjectsList'] = LookupStudentSubject::getPreferredSubjectsByDepartment($educationDetail12->board_ref_id, $showSubjectOfFilterDept);
            }

            $educationSubjectData = StudentEducation::getSubjectDetail(12, $this->userId);
            $studentSubjectArr = array();
            foreach($educationSubjectData as $subjectsData) {
                foreach($subjectsData->studentEducationDetails as $subject) {
                    if(strtolower($boardDetails['overall_type']) == "grades" || strtolower($boardDetails['overall_type']) == "marks-gpa") {
                        $studentSubjectArr[$subject->student_subject_ref_id] =  $subject->grade_ref_id;
                    } else {
                        $studentSubjectArr[$subject->student_subject_ref_id] =  $subject->marks;
                    }
                }
            }
            if(count($studentSubjectArr)) {
                $this->studentClassDetails[12]['subjects'] = $studentSubjectArr;
            }
        }
    }

    public function actionEducation()
    {
        $this->setPageTitle(Yii::app()->name .' - Your educational details');
        $this->getUserSessionInfo();

        $this->userInfo = TblUserMaster::getUserDetails($this->userId);
        
        $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
        $tabUrls = LookupUrl::getB2BTabUrl();
        foreach($tabUrls as $tabUrl){
            if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
            } else {
                $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
            }
        }
        
        $presentClass = $this->userInfo->present_class;
        $presentClassStatus = $this->userInfo->class_status;
        $presentClassLevel = $presentClass . $presentClassStatus;

        $studentSignupModel = new StudentSignup('cssEducation');
        $this->performAjaxValidation($studentSignupModel);

        //echo "####".$presentClassLevel;
        switch ($presentClassLevel) {
            case '12Completed':
            {
                $this->studentClassDetails[12]['label'] = '12th standard or equivalent';
                $this->studentClassDetails[12]['status'] = 'Completed';

                $this->get12AutoPopulateData($presentClassLevel);

                
                $passoutYear = UniversityHelper::completeYear($presentClassLevel, 1);
                
                $this->studentClassDetails[12]['passoutYear'] = $passoutYear;


                $this->studentClassDetails[10]['label'] = '10th standard or equivalent';
                $this->studentClassDetails[10]['status'] = 'Completed';
                
                $this->get10AutoPopulateData($presentClassLevel);
                
                break;
            }
            case '12Pursuing':
            {
                $this->studentClassDetails[12]['label'] = '12th Expected';
                $this->studentClassDetails[12]['status'] = 'Pursuing';
                
                $this->get12AutoPopulateData($presentClassLevel);


                $passoutYear = UniversityHelper::completeYear($presentClassLevel, 1);
                
                $this->studentClassDetails[12]['passoutYear'] = $passoutYear;

                $this->studentClassDetails[10]['label'] = '10th standard or equivalent';
                $this->studentClassDetails[10]['status'] = 'Completed';
                
                $this->get10AutoPopulateData($presentClassLevel);
                
                break;
            }
            case '11Pursuing':
            {
                $this->studentClassDetails[12]['label'] = '12th Expected';
                $this->studentClassDetails[12]['status'] = 'Pursuing';
                
                $this->get12AutoPopulateData($presentClassLevel);

                
                $passoutYear = UniversityHelper::completeYear($presentClassLevel, 1);
                
                $this->studentClassDetails[12]['passoutYear'] = $passoutYear;

                $this->studentClassDetails[10]['label'] = '10th standard or equivalent';
                $this->studentClassDetails[10]['status'] = 'Completed';
                
                $this->get10AutoPopulateData($presentClassLevel);
                
                break;
            }
            case '10Pursuing':
            {
                $this->studentClassDetails[10]['label'] = '10th Expected';
                $this->studentClassDetails[10]['status'] = 'Pursuing';
                $this->get10AutoPopulateData($presentClassLevel);
                break;
            }
            case '9Pursuing':
            {
                $this->studentClassDetails[10]['label'] = '10th Expected';
                $this->studentClassDetails[10]['status'] = 'Pursuing';
                break;
            }
        }
        $this->studentClassDetails[10]['passoutYear'] = UniversityHelper::complitionYearList('10', $this->userInfo->passout_year);
        $this->userInfo = TblUserMaster::getUserDetails($this->userId);
        
        $showTest = 0;
        $studentPreferredCountries = $this->userInfo->studentPreferredCountries;
        if (count($studentPreferredCountries) > 0) {
            foreach ($studentPreferredCountries as $countryPref) {
                $studentPreferredCountryIds[] = $countryPref->attributes['country_ref_id'];
                if($countryPref->attributes['country_ref_id'] == 224 || $countryPref->attributes['country_ref_id'] == 190){
                    $showTest = 1;
                }
            }
        }
        $studentPreferredDepartments = $this->userInfo->studentPreferredDepartments;
        if (count($studentPreferredDepartments) > 0) {
            foreach ($studentPreferredDepartments as $deptPref) {
                $studentPreferredDepartmentIds[] = $deptPref->attributes['main_dept_ref_id'];
            }
        }


        $userTestInfo = UserEntranceExam::getUserExamsInfo($this->userId);
            if ($userTestInfo) {
                foreach ($userTestInfo as $key => $data) {
                    $userTestModels[$key + 1] = new StudentTestDetail();
                    $userTestModels[$key + 1]->attributes = $data->attributes;
                    if ($data->userEntranceExamModules) {
                        foreach ($data->userEntranceExamModules as $k => $value) {
                            $userTestModels[$key + 1]->child[$k + 1] = new StudentTestModuleDetail();
                            $userTestModels[$key + 1]->child[$k + 1]->attributes = $value->attributes;
                        }
                    } else {
                        $userTestModels[$key + 1]->child[1] = new StudentTestModuleDetail();
                    }
                    if ($data->entrance_exam_ref_id) {
                        $testModulelist = EntranceExamModule::getEntranceModuleList($data->entrance_exam_ref_id);
                        $userTestModels[$key + 1]->moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
                    }
                }
            } else {
                $userTestModels[1] = new StudentTestDetail();
            }
            
            //$examlist = DepartmentEntranceExam::getAllEntranceExamsByCountryAndDepartment($studentPreferredCountryIds, $studentPreferredDepartmentIds);
            
            // remove india from country - Anshul said
            //$key = array_search('100', $studentPreferredCountryIds); 
            //unset($studentPreferredCountryIds[$key]);
            
            // show only sat and act for US or Singapor
            $examlist = array();
            if($showTest) {
                $result = EntranceExam::getTestForSignup($studentPreferredCountryIds, $studentPreferredDepartmentIds);
                foreach($result as $key=>$value){
                    $examlist[$value->entrance_id] = $value->entrance_short_name;
                }
            }
            
        if (isset($_POST['StudentSignup'])) {
            $studentSignupModel->attributes = $_POST['StudentSignup'];
            $postData = Yii::app()->request->getPost('StudentSignup');
            $studentTestInfoData = Yii::app()->request->getPost('StudentTestDetail');
            $studentTestModuleData = Yii::app()->request->getPost('StudentTestModuleDetail');
            if (!$studentTestModuleData) {
                $studentTestModuleData = array();
            }
            if (!$studentTestInfoData) {
                $studentTestInfoData = array();
            }
            $customError = '';
            $userTestModels = array();
            $testSubjectArray = $testArray = array();
            foreach ($studentTestInfoData as $key => $data) {
                $userTestModels[$key] = new StudentTestDetail();
                $userTestModels[$key]->attributes = $data;
                if ($userTestModels[$key]->entrance_exam_ref_id != '') {
                    if (in_array($userTestModels[$key]->entrance_exam_ref_id, $testArray)) {
                        $userTestModels[$key]->addError('entrance_exam_ref_id', 'You selected the same test again');
                        $customError = 1;
                    } else {
                        $testArray[] = $userTestModels[$key]->entrance_exam_ref_id;
                    }
                }
                foreach ($studentTestModuleData[$key] as $k => $value) {
                    $userTestModels[$key]->child[$k] = new StudentTestModuleDetail();
                    $userTestModels[$key]->child[$k]->attributes = $value;
                    $userTestModels[$key]->child[$k]->user_entrance_exam_ref_id = $userTestModels[$key]->user_entrance_exam_id;
                    if ($userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id != '' && $userTestModels[$key]->child[$k]->marks != '') {
                        if (in_array($userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id, $testSubjectArray)) {
                            $userTestModels[$key]->child[$k]->addError('entrance_exam_module_entrance_exam_ref_id', 'You selected the same subject again');
                            $customError = 1;
                        } else {
                            $testSubjectArray[] = $userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id;
                        }
                    }
                }
                if ($data['entrance_exam_ref_id']) {
                    $testModulelist = EntranceExamModule::getEntranceModuleList($data['entrance_exam_ref_id']);
                    $userTestModels[$key]->moduleList = CHtml::listData($testModulelist, 'entrance_exam_module_entrance_exam_id', 'module_name');
                }
            }
            foreach ($userTestModels as $key => $data) {
                if ($userTestModels[$key]->entrance_exam_ref_id) {
                    if (!$userTestModels[$key]->validate()) {
                        $customError = 1;
                    }

                  
                }
                foreach ($userTestModels[$key]->child as $k => $value) {
                        if ($userTestModels[$key]->child[$k]->entrance_exam_module_entrance_exam_ref_id) {
                            if (!$userTestModels[$key]->child[$k]->validate()) {
                                $customError = 1;
                            }
                        }
                }
            }
            if ($studentSignupModel->validate() && $customError=='') {
                
                // Saving Test Data
                
                $resultCount = UserEntranceExam::deleteUserAllExamData($this->userId);
                foreach ($userTestModels as $key => $data) {
                    if ($data->entrance_exam_ref_id) {
                        $userEntranceExamModel = new UserEntranceExam();
                        $userEntranceExamModel->user_ref_id = $this->userId;
                        $userEntranceExamModel->attributes = $data->attributes;
                        $userEntranceExamModel->added_by = $this->loginRefId;
                        $userEntranceExamModel->save(false);

                        foreach ($data->child as $k => $value) {
                            if ($value->entrance_exam_module_entrance_exam_ref_id != '' && $value->marks != '') {
                                $userEntranceExamModuleModel = new UserEntranceExamModule();
                                $userEntranceExamModuleModel->attributes = $value->attributes;
                                $userEntranceExamModuleModel->user_entrance_exam_ref_id = $userEntranceExamModel->user_entrance_exam_id;
                                $userEntranceExamModuleModel->added_by = $this->loginRefId;
                                $userEntranceExamModuleModel->save(false);
                            }
                        }
                    }
                }
                
                //todo: Delete existing education information
                //StudentEducation::model()->deleteAll(array("condition" => "user_ref_id = '".$this->userId."'"));
                StudentEducation::deleteStudentEducationDetails($this->userId);
                foreach ($postData as $class => $classData) {
                    if ($class > 0) {
                        LookupSchool::addStudentSchool($classData['school_name']);
                        $studentEducationModel = new StudentEducation();
                        $dbData = array(
                            'user_ref_id' => $this->userId,
                            'board_ref_id' => $classData['board'],
                            'year' => $classData['passout_year'],
                            'month' => $classData['passout_month'],
                            'class_level' => $class,
                            'status' => $classData['status'],
                            'school_name' => $classData['school_name'],
                            'added_on' => date('Y-m-d H:i:s')
                        );
                        if ($classData['overall_type'] == 'points') {
                            $dbData['overall_marks'] = $classData['overall_points'];
                        } elseif ($classData['overall_type'] == 'marks' || $classData['overall_type'] == 'marks-gpa') {
                            $dbData['overall_marks'] = $classData['overall_marks'];
                        }

                        $studentEducationModel->setAttributes($dbData);
                        if($class == '10'){
                            $studentEducationModel->save(false);
                        }elseif($class == '12'){
                            $tblUserMasterModel = TblUserMaster::model()->findByPk($this->userId);
                            $getBoardDetail = LookupBoardEquivalent::getBoardDetailById($studentEducationModel->board_ref_id);
                            $boardRefId = $getBoardDetail['board_ref_id'];
                            if($boardRefId == 1 || $boardRefId == 2 || $boardRefId == 7) {
                               $passoutMonth = 3; 
                            } elseif($boardRefId == 5 || $boardRefId == 6 || $boardRefId == 8) {
                               $passoutMonth = 5; 
                            } else {
                                $passoutMonth = 4;
                            }
                            
                            $tblUserMasterModel->present_board_ref_id = $boardRefId;
                            $tblUserMasterModel->passout_month = $passoutMonth;
                            $tblUserMasterModel->save(false);
                            
                            $dbData['month'] = $passoutMonth;
                            $studentEducationModel->setAttributes($dbData); // override month value
                            $studentEducationModel->save();
                        }
                        $studentEducationId = $studentEducationModel->student_education_id;

                        if ($classData['overall_type'] == 'grades') {
                            foreach ($classData['overall_grade'] as $gradeRefId => $gradeCount) {
                                $studentGradeCount = new StudentGradeCount();
                                $studentGradeCount->student_education_ref_id = $studentEducationId;
                                $studentGradeCount->grade_ref_id = $gradeRefId;
                                $studentGradeCount->grade_count = $gradeCount;
                                $studentGradeCount->added_on = date('Y-m-d H:i:s');
                                //echo "<br>###studentGradeCount";
                                //$this->printr($studentGradeCount->attributes);
                                $studentGradeCount->save();
                            }
                        }

                        //echo "<br>###".$classData['overall_type'];
                        $subjects = $classData['subjects'];
                        $marks = $classData['marks'];
                        $points = $classData['points'];
                        for ($i = 0; $i < count($subjects); $i++) {
                            $studentEducationDetails = new StudentEducationDetail();
                            $studentEducationDetails->student_education_ref_id = $studentEducationId;
                            $flagSubjectSelected = false;
                            $flagMarksSelected = false;
                            if($subjects[$i] != ''){
                                $flagSubjectSelected = true;
                            $studentEducationDetails->student_subject_ref_id = $subjects[$i];
                            }

                            switch($classData['overall_type']){
                                case 'marks-gpa': { // for this "Marks-GPA" subject will store grade and overall marks will store in marks.
                                        if ($marks[$i] != '') {
                                            $flagMarksSelected = true;
                                            $studentEducationDetails->grade_ref_id = $marks[$i];
                                        }
                                        break;
                                    }
                                case 'grades':{
                                    if($marks[$i] != ''){
                                        $flagMarksSelected = true;
                                $studentEducationDetails->grade_ref_id = $marks[$i];
                                    }
                                    break;
                                }
                                case 'points':{
                                    if($points[$i] != ''){
                                        $flagMarksSelected = true;
                                        $studentEducationDetails->marks = $points[$i];
                                        $studentEducationDetails->ib_level = 'HL';
                                    }
                                    break;
                                }
                                case 'marks':{
                                    if($marks[$i] != ''){
                                        $flagMarksSelected = true;
                                        $studentEducationDetails->marks = $marks[$i];
                                    }
                                    break;
                                }
                            }

                            /*if ($classData['overall_type'] == 'grades') {
                                $studentEducationDetails->grade_ref_id = $marks[$i];
                            } else if ($classData['overall_type'] == 'points') {
                                $studentEducationDetails->marks = $points[$i];
                                $studentEducationDetails->ib_level = 'HL';
                            } else {
                                $studentEducationDetails->marks = $marks[$i];
                            }*/

                            if($flagSubjectSelected && $flagMarksSelected){
                            $studentEducationDetails->added_on = date('Y-m-d H:i:s');
                            $studentEducationDetails->save();
                        }
                    }
                }
                }

                $criticalFields = array('edu_study_level' => 1, 'school_name' => 1, 'completion_year' => 1, 'board' => 1);
                TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                CommonUtils::calculateCriticalPercentage($this->userId);

                if(Yii::app()->session->itemAt('studentProfileConfirmationId')){
                    LoginMaster::updateProfileValidationField($this->loginRefId, 'is_class_status_confirmed', 1, $this->userId);
                }

                $urlDetails = LookupUrl::getUrlByModel(
                    array(
                         'model_name' => 'profile',
                         'class_level' => 12,
                         'type_of_field' => 'critical',
                         'label' => 'phone',
                    ),
                1);
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));
                
                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'education details'));
                $this->redirect($urlDetails[0]['url']);
                //$this->redirect(Yii::app()->createUrl('student/signup/aspirationCollege'));
            }
        }else{
            CommonUtils::isSignupStepComplete($this->userId);
        }
        
        
        //$studentSignupModel->board = $data->board_ref_id;
        //print_r($data->attributes);// exit;
        
        
        $this->render('css_education', array('userMasterModel' => $studentSignupModel,'schoolName12'=>$this->userInfo->schoolRef->school_name, 'userTestModels' => $userTestModels, 'examlist' => $examlist, 'urlArr' => $urlArr));
    }

    public function actionGetOverallAndSubjects()
    {
        $classLevel = Yii::app()->request->getQuery('class');
        $boardId = Yii::app()->request->getQuery('boardId');

        $boardDetails = LookupBoardEquivalent::GetBoardDetails($classLevel, $boardId);

        $this->overallMax = $boardDetails['overall_max'];
        $this->subjectMax = $boardDetails['subject_max'];
        $this->overallType = strtolower($boardDetails['overall_type']);
        $this->classLevel = $classLevel;

        $this->userInfo = TblUserMaster::getUserDetails($this->userId);
        
        $presentClassLevel = $this->userInfo->present_class . $this->userInfo->class_status;

        
        $studentPreferredDepartments = $this->userInfo->studentPreferredDepartments;
        $showSubjectFlag = 0;
        if (count($studentPreferredDepartments) > 0) {
            foreach ($studentPreferredDepartments as $deptPref) {
                $departmentId = $deptPref->attributes['main_dept_ref_id'];
                $this->studentPreferredDepartmentIds[] = $departmentId;
                if($departmentId == 74 || $departmentId == 55 || $departmentId == 23) {
                    $showSubjectOfFilterDept[] = $departmentId;
                    $showSubjectFlag = 1;
                }
            }
        }
        $this->studentPreferredDepartmentIds = array_filter($this->studentPreferredDepartmentIds);
        
        if( $classLevel == 10 && $showSubjectFlag ) {
            $this->subjects = LookupStudentSubject::getPreferredSubjectsByDepartment($boardId, $showSubjectOfFilterDept);
        } elseif( $classLevel == 12 && $showSubjectFlag && $presentClassLevel == "12Completed" ){
            $this->subjects = LookupStudentSubject::getPreferredSubjectsByDepartment($boardId, $showSubjectOfFilterDept);
        }
        
        $content['input'] = '<input type="hidden" id="StudentSignup_overall_type" name="StudentSignup[' . $classLevel . '][overall_type]" value="' . $this->overallType . '" rel="' . $classLevel . '"><input type="hidden" id="StudentSignup_overall_max' . $classLevel . '" name="StudentSignup[' . $classLevel . '][overall_max]" value="' . $boardDetails['overall_max'] . '" rel="' . $classLevel . '">';
        $content['hideAddmore'] = count($this->subjects);
        
        switch ($boardDetails['overall_type']) {
            case 'Marks-GPA':
            {
                $placeholder = 'Enter Marks or GPA';
                $this->beginClip('overall');
                $this->renderPartial('_overallMarks', array('placeholder' => $placeholder));
                $this->endClip();
                
                $gradeArray = LookupGrade::getGradeList($boardDetails['board_ref_id']);
                $gradeArray = CHtml::listData($gradeArray, 'grade_id', 'grade_type');
                
                $this->subjectInputMarks = CHtml::dropDownList('StudentSignup[' . $classLevel . '][marks][]', '', $gradeArray, array('empty' => 'Grade', 'id' => 'StudentSignup_' . $this->overallType . '_' . $this->classLevel, 'style' => 'width:200px;' ));
                break;
            }
            case 'Grades':
            {
                $this->beginClip('overall');
                $this->renderPartial('_overallGrades');
                $this->endClip();

                $gradeArray = LookupGrade::getGradeList($boardDetails['board_ref_id']);
                $gradeArray = CHtml::listData($gradeArray, 'grade_id', 'grade_type');
                
                $replacements = array(1 => "A*");
                $gradeArray = array_replace($gradeArray, $replacements);
                
                $this->subjectInputMarks = CHtml::dropDownList('StudentSignup[' . $classLevel . '][marks][]', '', $gradeArray, array("onfocus" => "hideError(this.id);", 'empty' => 'Grade', 'id' => 'StudentSignup_' . $this->overallType . '_' . $this->classLevel, 'style' => 'width:200px;' ));
                break;
            }
            case 'Marks':
            {
                $placeholder = (Yii::app()->request->getQuery('boardId') == '1' && $this->classLevel == '10') ? 'Enter Marks or CGPA' : 'Enter Score (Max: ' . $this->overallMax . ')';
                $this->beginClip('overall');
                $this->renderPartial('_overallMarks', array('placeholder' => $placeholder) );
                $this->endClip();
                
                $placeholder = (Yii::app()->request->getQuery('boardId') == '1' && $this->classLevel == '10')  ? 'Enter Marks or CGPA' : 'Enter Score (Max: '.$this->subjectMax.')';
                $this->subjectInputMarks = CHtml::textField('StudentSignup[' . $classLevel . '][marks][]', '', array("onfocus" => "hideError(this.id);", 'id' => 'StudentSignup_marks_' . $this->classLevel, 'maxlength' => 3, 'placeholder' => ''.$placeholder.'', 'style' => 'width:200px;')); //'<input type="text" value="Enter Score" style="width:200px;"/>';
                break;
            }
            case 'Points':
            {
                $this->beginClip('overall');
                $this->renderPartial('_overallPoints');
                $this->endClip();

                $pointsList = range(1, $this->subjectMax);
                $pointsList = array_combine($pointsList, $pointsList);
                $this->subjectInputMarks = CHtml::dropDownList('StudentSignup[' . $classLevel . '][points][]', '', $pointsList, array("onfocus" => "hideError(this.id);", 'empty' => 'Points', 'id' => 'StudentSignup_points_' . $this->classLevel, 'style' => 'width:230px;'));
                break;
            }
        }
        $content['overall'] = $this->clips['overall'];


        $this->beginClip('subjects');
        $this->renderPartial('_studentSubjects', array('boradType' => $boardDetails['overall_type']));
        $this->endClip();
        $content['subjects'] = $this->clips['subjects'];

        echo json_encode($content);

    }

    public function getStandardExamsByCountry($countryId = 0)
    {
        $standardExams = array();
        $result = DepartmentEntranceExam::getEntranceExamByCountry($countryId);
        foreach ($result as $entranceExam) {
            $standardExams['exam_id'] = $entranceExam->entranceExamRef->attributes['entrance_id'];

            if ($entranceExam->entranceExamRef->attributes['entrance_full_name'] != $entranceExam->entranceExamRef->attributes['entrance_short_name']) {
                $standardExams['exam_name'] = $entranceExam->entranceExamRef->attributes['entrance_full_name'] . '(' . $entranceExam->entranceExamRef->attributes['entrance_short_name'] . ')';
            } else {
                $standardExams['exam_name'] = $entranceExam->entranceExamRef->attributes['entrance_short_name'];
            }
            //

            $standardExams['exam_max_marks'] = $entranceExam->entranceExamRef->attributes['max_marks'];
            foreach ($entranceExam->entranceExamRef->entranceExamModuleEntranceExams as $modules) {
                $standardExams['modules'][$modules->attributes['entrance_exam_module_entrance_exam_id']] = $modules->entranceExamModuleRef->attributes['module_name'];
                $standardExams['module_max_marks'] = (int)($modules->attributes['max_marks']);
            }
            asort($standardExams['modules']);
        }
        return $standardExams;
    }


    public function actionContactInfo()
    { 
        $this->setPageTitle(Yii::app()->name .' - Your contact information');
        $this->getUserSessionInfo();
        $this->userInfo = TblUserMaster::getUserDetails($this->userId);

        $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
        $tabUrls = LookupUrl::getB2BTabUrl();
        foreach($tabUrls as $tabUrl) {
            if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
            } else {
                $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
            }
        }
        
        $this->countryList = TblCountryMaster::getCountryList();
        //$this->stateList = TblState::

        $studentSignupModel = new StudentSignup('cssContactInfo');
        $this->performAjaxValidation($studentSignupModel);
    
        if($this->userId){
            $studentContactInfo = StudentUploadMasterList::model()->find('user_ref_id='.$this->userId);
        }
        if($studentSignupModel){
            $studentSignupModel->alternate_phone_contry_code = $studentContactInfo->country_code;
            $studentSignupModel->alternate_phone = $studentContactInfo->phone_number;
        }
        if (isset($_POST['StudentSignup'])) {
            $studentSignupModel->attributes = $_POST['StudentSignup'];
            $postData = Yii::app()->request->getPost('StudentSignup');
            if ($studentSignupModel->validate()) {
                $studentModel = TblUserMaster::model()->findByPk($this->userId);

                $fields = array(
                    'address1' => $postData['address1'],
                    'address2' => $postData['address2'],
                    'country_ref_id' => $postData['country'],
                    'city_ref_id' => $postData['city'],
                    'post_code' => $postData['zip'],
                );

                if ($postData['country'] == 100) {
                    $fields['state_ref_id'] = $postData['state'];
                } else {
                    $fields['state_ref_id'] = NULL;
                }

                switch ($postData['relation_type']) {
                    case 2:
                    {
                        $fields['father_first_name'] = ucwords(strtolower(trim($postData['parent_first_name'])));
                        $fields['father_last_name'] = ucwords(strtolower(trim($postData['parent_last_name'])));
                        break;
                    }
                    case 3:
                    {
                        $fields['mother_first_name'] = ucwords(strtolower(trim($postData['parent_first_name'])));
                        $fields['mother_last_name'] = ucwords(strtolower(trim($postData['parent_last_name'])));
                        break;
                    }
                    case 4:
                    {
                        $fields['guardian_first_name'] = ucwords(strtolower(trim($postData['parent_first_name'])));
                        $fields['guardian_last_name'] = ucwords(strtolower(trim($postData['parent_last_name'])));
                        break;
                    }
                }

                $studentModel->setAttributes($fields);
                $studentModel->save(false);

                //Storing Student Alternate Email
                StudentAlternateEmail::deleteAlternateEmail($this->loginRefId);//, 1, array(array("field"=>"is_primary = 0", "condition" => "AND"))

                if($postData['username'] != ''){
                    StudentAlternateEmail::addAlternameEmail($this->userInfo->login_ref_id, 1, $postData['username'], $this->userInfo->login_ref_id, false, true);
                }


                //Storing Parent Alternate Email
                /*StudentAlternateEmail::deleteAlternateEmail($this->loginRefId, 2);
                StudentAlternateEmail::deleteAlternateEmail($this->loginRefId, 3);
                StudentAlternateEmail::deleteAlternateEmail($this->loginRefId, 4);*/
                if($postData['parent_email'] != ''){
                StudentAlternateEmail::addAlternameEmail($this->userInfo->login_ref_id, $postData['relation_type'], $postData['parent_email'], $this->userInfo->login_ref_id, false, true);
                }


                //Storing Student Contact Numbers
                StudentContactNumber::deleteContactNumbers($this->userId);
                $contactInfo = array(
                    'user_ref_id' => $this->userId,
                    'contact_type_ref_id' => 1,
                    'country_code' => $postData['alternate_phone_contry_code'],
                    'number' => $postData['alternate_phone'],
                    'is_primary' => 1,
                    'added_by' => $this->userInfo->login_ref_id,
                    'added_on' => date('Y-m-d H:i:s'),
                    'phone_type' => 'Home'
                );
                StudentContactNumber::addContactNumber($contactInfo);

                //Storing Parent Contact Numbers
                /*StudentContactNumber::deleteContactNumbers($this->userId, 2);
                StudentContactNumber::deleteContactNumbers($this->userId, 3);
                StudentContactNumber::deleteContactNumbers($this->userId, 4);*/
                if($postData['parent_phone_country_code'] != '' && $postData['parent_phone']){
                    $contactInfo = array(
                        'user_ref_id' => $this->userId,
                        'contact_type_ref_id' => $postData['relation_type'],
                        'country_code' => $postData['parent_phone_country_code'],
                        'number' => $postData['parent_phone'],
                        'is_primary' => 0,
                        'added_by' => $this->userInfo->login_ref_id,
                        'added_on' => date('Y-m-d H:i:s'),
                        'phone_type' => 'Home'
                    );
                    StudentContactNumber::addContactNumber($contactInfo);
                }


                $criticalFields = array('phone' => 1);
                TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                CommonUtils::calculateCriticalPercentage($this->userId);

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'contact details'));

//                $urlDetails = LookupUrl::getUrlByModel(array(
//                                                            'class_level' => 0,
//                                                            'label' => 'dashboard',
//                                                       ), 1);
//                $redirectUrlRefId = $urlDetails[0]['url_id'];
//                TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));
                //Yii::app()->session['isCompleteSignupNecessarySteps'] = '1'; // if this variable is set then user will get link on each tab
                $urlDetails = LookupUrl::getUrlByModel(array(
                                                            'model_name' => 'profile',
                                                            'class_level' => 12,
                                                            'type_of_field' => 'recommended',
                                                            'label' => 'aspiration_list',
                                                       ), 1);
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));
                
                $this->redirect($urlDetails[0]['url']);

            }
        }else{
            CommonUtils::isSignupStepComplete($this->userId);
        }
        
        // Auto filling data in form
        
        // Get Alternate Contact Details
        $parentContactData = StudentContactNumber::getParentContactNumbers($this->userId, 1);
        if($parentContactData) {
            foreach($parentContactData as $data){
                if($data->contact_type_ref_id == 2) {
                    $studentSignupModel->parent_first_name = $this->userInfo->father_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->father_last_name;
                } elseif($data->contact_type_ref_id == 3) {
                    $studentSignupModel->parent_first_name = $this->userInfo->mother_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->mother_last_name;
                } elseif($data->contact_type_ref_id == 4) {
                    $studentSignupModel->parent_first_name = $this->userInfo->guardian_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->guardian_last_name;
                }
                $studentSignupModel->parent_phone_country_code = $data->country_code;
                $studentSignupModel->parent_phone = $data->number;
                $studentSignupModel->relation_type = $data->contact_type_ref_id;
                $parentEmailData = StudentAlternateEmail::getEmailsOfParent($this->userInfo->login_ref_id, $data->contact_type_ref_id);
                foreach($parentEmailData as $data){
                    $studentSignupModel->parent_email = $data->email_id;
                    break;
                }
                break;
            }
        } else {
            // Get Alternate Email Details
            $parentEmailData = StudentAlternateEmail::getAllParentEmails($this->userInfo->login_ref_id);
            foreach($parentEmailData as $data){
                if($data->contact_type_ref_id == 2) {
                    $studentSignupModel->parent_first_name = $this->userInfo->father_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->father_last_name;
                } elseif($data->contact_type_ref_id == 3) {
                    $studentSignupModel->parent_first_name = $this->userInfo->mother_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->mother_last_name;
                } elseif($data->contact_type_ref_id == 4) {
                    $studentSignupModel->parent_first_name = $this->userInfo->guardian_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->guardian_last_name;
                }
                $studentSignupModel->relation_type = $data->contact_type_ref_id;
                $studentSignupModel->parent_email = $data->email_id;
                break;
            }
        }

        
        
        // Student alternate email
        $studentEmailData = StudentAlternateEmail::getStudentAlternateEmail($this->userInfo->login_ref_id);
        $studentSignupModel->username = $studentEmailData->email_id;


        // Student phone no
        $studentContactData = StudentContactNumber::getFullContactNumbers($this->userId, "1");
        $studentSignupModel->alternate_phone_contry_code = $studentContactData->country_code;
        $studentSignupModel->alternate_phone = $studentContactData->number;

        $stateId = $this->userInfo->state_ref_id;
        $countryId = $this->userInfo->country_ref_id;
        if($stateId > 0){
            $this->cityList = TblCityMaster::getCityListByState($stateId);
        }elseif($countryId > 0){
            $this->cityList = TblCityMaster::getCityListByCountry($countryId);
        }
        
        if($countryId == 100) { // only for india otherwise you will get state for UK and US too.
            $this->stateList = TblState::getStateByCountry($countryId);
        }
        
        
        

        $studentSignupModel->address1 = $this->userInfo->address1;
        $studentSignupModel->address2 = $this->userInfo->address2;
        $studentSignupModel->country = $this->userInfo->country_ref_id;
        $studentSignupModel->state = $this->userInfo->state_ref_id;
        $studentSignupModel->city = $this->userInfo->city_ref_id;
        $studentSignupModel->zip = $this->userInfo->post_code;
        
        $this->render('css_contact', array('userMasterModel' => $studentSignupModel, 'urlArr' => $urlArr));
    }

    public function actionGetStatesList(){
        $countryId = Yii::app()->request->getQuery('countryId');
        $result = TblState::getStateByCountry($countryId);
        echo json_encode($result);
}

    public function actionGetCountryCode(){
        $countryId = Yii::app()->request->getQuery('countryId');
        $result = TblCountryMaster::getPhoneCode($countryId);
        echo $result;
    }

    public function actionGetCityList(){
        $countryId = Yii::app()->request->getQuery('countryId');
        $stateId = Yii::app()->request->getQuery('stateId');
        $result = array();
        if($stateId > 0){
            //$result = TblCityMaster::getCityListByState($stateId);
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND state_ref_id = '".$stateId."'", "order" => "city_name"));
        }else if($countryId > 0){
            //$result = TblCityMaster::getCityListByCountry($countryId);
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND country_id = '".$countryId."'", "order" => "city_name"));
        }
        $cityResults = array();
        foreach($result as $city){
            $cityResults[$city->attributes['city_id']] = $city->attributes['city_name'];
        }
        echo json_encode($cityResults);
    }
    
    function actionValidateTestSubject() {
        $testModuleId = Yii::app()->request->getPost('testModuleId');
        $compositeDetail = EntranceExamModuleEntranceExam::model()->find('entrance_exam_module_entrance_exam_id=' . $testModuleId);
        echo $compositeDetail->max_marks;
    }
    
    function actionValidateTestOverall() {
        $testId = Yii::app()->request->getPost('testId');
        $testDetail =  EntranceExam::model()->find('entrance_id=' . $testId);
        echo $testDetail->max_marks;
    }

    public function actionCountryPreference10() {

        $this->setPageTitle(Yii::app()->name .' - Choose a country preference');
        $studentSignupModel = new StudentSignup('b2cCountryPref10');
        $this->performAjaxValidation($studentSignupModel);

        $userInfo = TblUserMaster::getUserInformation($this->userId);
        $userPresentClass = $userInfo['present_class'] . strtolower($userInfo['class_status'][0]);

        $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
        $tabUrls = LookupUrl::getB2B10TabUrl();
        foreach($tabUrls as $tabUrl) {
            if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
            } else {
                $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
            }
        }
        
        $yearList = array();
        $yearList = UniversityHelper::completeYear($userPresentClass);
        //$yearList = $this->completeYear('10p');
        $this->likelyStartPeriodYear = $yearList[0];
        $yearList = array_combine($yearList, $yearList);

        $model = new LookupLikelyPeriod;
        $data = $model->findAll();

        foreach ($data as $likelyPreferredPeriod) {
            $preferredPeriod = $likelyPreferredPeriod->attributes;
            $rangeArray = range($preferredPeriod['from_month'], $preferredPeriod['to_month']);
            foreach ($rangeArray as $month) {
                $startPeriodMonths[$month] = date('F', strtotime(date('Y-' . $month . '-1')));
                $preferredPeriodMonthRelationArray[$month]['start'] = $preferredPeriod['from_month'];
                $preferredPeriodMonthRelationArray[$month]['end'] = $preferredPeriod['to_month'];
                $preferredPeriodMonthRelationArray[$month]['period_id'] = $preferredPeriod['period_id'];
            }
        }
        $startPeriodMonths = array_unique($startPeriodMonths);

        $preferredYear = UniversityHelper::LikelyStartYearList($userInfo['passout_year']);
        $likelyStartPeriodYear = array_shift(array_values($preferredYear));

        $nextMonthTime = strtotime($likelyStartPeriodYear."-". $userInfo['passout_month'] ."-01");
        $newLikelyPeriod = strtotime(date("Y-m-d", strtotime("+1 month", $nextMonthTime)));

        $studentSignupModel->likely_start_period_month  = (int)date("m", $newLikelyPeriod);
        $studentSignupModel->likely_start_period_year = date("Y", $newLikelyPeriod);

        $countryList = TblCountryMaster::getStudentInterestedCountryList();
        $countryData = CHtml::listData($countryList, 'country_id', 'country_name');

        $allCountryList = TblCountryMaster::getCountryList();
        $uniqueCountryList = array_diff($allCountryList, $countryData);
        $countryData['Others'] = $uniqueCountryList;
        
        $studentPreferredCountryList = StudentPreferredCountry::getStudentPreferredCountryDetails($this->userId);
        foreach ($studentPreferredCountryList as $prefCountry) {
            if ($prefCountry->attributes['not_sure'] == 1) {
                $studentSignupModel->{country_not_sure} = 'Y';
            } else {
                $studentSignupModel->{country_pref . $prefCountry->attributes['preference_order']} = $prefCountry->attributes['country_ref_id'];
            }
        }

        if (isset($_POST['StudentSignup'])) {
            $studentSignupModel->attributes = $_POST['StudentSignup'];
            $postData = Yii::app()->request->getPost('StudentSignup');

            if (count($postData) > 0) {
                for ($i = 1; $i <= 3; $i++) {
                    $countryPrefArr[] = $postData['country_pref' . $i];
                }
                $countryPrefArr = array_values(array_filter($countryPrefArr));
                for ($i = 0; $i < 3; $i++) {
                    $postData['country_pref' . ($i + 1)] = (isset($countryPrefArr[$i])) ? $countryPrefArr[$i] : '';
                }
                foreach ($studentSignupModel->attributes as $key => $value) {
                    $studentSignupModel->{$key} = $postData[$key];
                }
            }

            if ($studentSignupModel->validate()) {
                $studentPreferredPeriodRef = array();
                $prefPeriodRel = array();
                $startPeriodMonth = $postData['likely_start_period_month'];
                $startPeriodYear = $postData['likely_start_period_year'];
                for ($i = $startPeriodMonth; ; $i++) {
                    if (count($studentPreferredPeriodRef) == 3) {
                        break;
                    } else {
                        if (isset($preferredPeriodMonthRelationArray[$i]) && (!in_array($preferredPeriodMonthRelationArray[$i]['period_id'], $studentPreferredPeriodRef))) {
                            $studentPreferredPeriodRef[] = $preferredPeriodMonthRelationArray[$i]['period_id'];
                            $prefPeriodRel[] = array(
                                'from_month' => $preferredPeriodMonthRelationArray[$i]['start'],
                                'to_month' => $preferredPeriodMonthRelationArray[$i]['end'],
                                'year' => $startPeriodYear,
                                'period_ref_id' => $preferredPeriodMonthRelationArray[$i]['period_id'],
                                'user_ref_id' => $this->userId,
                                'added_on' => date('Y-m-d H:i:s'),
                            );
                        }
                    }
                    if ($i == 12) {
                        $i = 0;
                        $startPeriodYear++;
                    }
                }
                StudentPreferredPeriod::model()->deleteAll(array("condition" => "user_ref_id = '" . $this->userId . "'"));
                foreach ($prefPeriodRel as $preferredPeriod) {
                    StudentPreferredPeriod::addStudentPreferences($preferredPeriod);
                }
                $flagCriticalLikelyStartPeriod = 1;

                StudentPreferredCountry::model()->deleteAllByAttributes(array(user_ref_id => $this->userId));
                if ($postData['country_not_sure'] == 1) {
                    $modelPreferedCountry = new StudentPreferredCountry();
                    $modelPreferedCountry->attributes = array('user_ref_id' => $this->userId, 'preference_order' => $i,
                        'added_on' => date('Y-m-d H:i:s'), 'not_sure' => 1
                    );
                    if ($modelPreferedCountry->save(false)) {
                        $criticalFields = array('likely_start_period' => 1);
                        TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                        CommonUtils::calculateCriticalPercentage($this->userId);
                    }
                } else {
                    for ($i = 1; $i <= 3; $i++) {
                        if (isset($postData['country_pref' . $i]) && $postData['country_pref' . $i] != '') {
                            $modelPreferedCountry = new StudentPreferredCountry();
                            $modelPreferedCountry->attributes = array('user_ref_id' => $this->userId,
                                'country_ref_id' => $postData['country_pref' . $i], 'preference_order' => $i,
                                'added_on' => date('Y-m-d H:i:s')
                            );
                            if ($modelPreferedCountry->save(false)) {
                                $criticalFields = array('country' => 1, 'likely_start_period' => 1);
                                TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                                CommonUtils::calculateCriticalPercentage($this->userId);
                            }
                        }
                    }
                }
                    $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'signup',
                        'class_level' => 9,
                        'type_of_field' => 'critical',
                        'label' => 'career_pref',
                    ),
                    1);
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'country preferences'));
                $this->redirect($urlDetails[0]['url']);

            }
        } else {
            CommonUtils::isSignupStepComplete($this->userId);
        }

        $this->render("country_pref10", array('userMasterModel' => $studentSignupModel,
                'year' => $yearList,
                'preferredPeriods' => $preferredPeriods,
                'countryData' => $countryData,
                'preferredMonths' => $startPeriodMonths,
                'preferredYear' => $preferredYear,
                'otherCountryList' => $otherCountryList,
                'urlArr' => $urlArr,
            )
        );
    }

    public function actionCareerPreference() {
        $studentSignupModel = new StudentSignup('CareerPref10');
        $this->performAjaxValidation($studentSignupModel);

        $careerList = LookupCareer::getCareerList();

        $this->userInfo = TblUserMaster::getUserDetails($this->userId);
        
        $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
        $tabUrls = LookupUrl::getB2B10TabUrl();
        foreach($tabUrls as $tabUrl) {
            if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
            } else {
                $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
            }
        }

        $studentPreferredCareer = StudentPreferredCareer::getStudentPreferredCareers($this->userId);
        foreach ($studentPreferredCareer as $prefCareer) {
            if ($prefCareer->attributes['not_sure'] == 1) {
                $studentSignupModel->{career_not_sure} = 'Y';
            } else {
                $studentSignupModel->{career_pref . $prefCareer->attributes['preference']} = $prefCareer->attributes['career_ref_id'];
            }
        }
        
//        $criteria = new CDbCriteria;
//        $criteria->select = 'board_ref_id, board_name';
//        $criteria->condition = "class_level = '10' ";
//        $criteria->order = " board_name asc ";
//        $boards_data = LookupBoardEquivalent::model()->findAll($criteria);
//        $boards = array();
//        foreach ($boards_data as $board_data) {
//            $id = $board_data->board_ref_id;
//            $boards[$id] = $board_data->board_name;
//        }
               
        if (isset($_POST['StudentSignup'])) {
            $studentSignupModel->attributes = $_POST['StudentSignup'];
            $postData = Yii::app()->request->getPost('StudentSignup');
            if ($_POST['StudentSignup']['present_board_ref_id'] != '') {
                $boardDetail10 = LookupBoardEquivalent::getBoardDetailById($_POST['StudentSignup']['present_board_ref_id']);
            }
            if ($studentSignupModel->validate()) {
                $tblUserMasterModel = TblUserMaster::model()->findByPk($this->userId);
                $tblUserMasterModel->present_board_ref_id = $boardDetail10['board_ref_id'];
                $tblUserMasterModel->save(false);

                StudentPreferredCareer::model()->deleteAllByAttributes(array(user_ref_id => $this->userId));
                if ($postData['career_not_sure'] == 1) {
                    $modelPreferedCareer = new StudentPreferredCareer();
                    $modelPreferedCareer->attributes = array('user_ref_id' => $this->userId, 'preference_order' => 1,
                        'added_on' => date('Y-m-d H:i:s'), 'not_sure' => 1
                    );
                    if ($modelPreferedCareer->save(false)) {
                        /*$criticalFields = array('likely_start_period' => 1);
                        TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                        CommonUtils::calculateCriticalPercentage($this->userId); */
                    }
                } else {
                    for ($i = 1; $i <= 3; $i++) {
                        if (isset($postData['career_pref' . $i]) && $postData['career_pref' . $i] != '') {
                            $modelPreferedCareer = new StudentPreferredCareer();
                            $modelPreferedCareer->attributes = array('user_ref_id' => $this->userId,
                                'career_ref_id' => $postData['career_pref' . $i], 'preference' => $i,
                                'added_on' => date('Y-m-d H:i:s')
                            );
                            if ($modelPreferedCareer->save(false)) {
                                /*$criticalFields = array('likely_start_period' => 1);
                        TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                        CommonUtils::calculateCriticalPercentage($this->userId); */
                            }
                        }
                    }
                }

                StudentPreferredSubject::model()->deleteAllByAttributes(array(user_ref_id => $this->userId));
                for ($i = 1; $i <= 3; $i++) {
                    if (isset($postData['subject_pref' . $i]) && $postData['subject_pref' . $i] != '') {
                        $modelPreferedCareer = new StudentPreferredSubject();
                        $modelPreferedCareer->attributes = array('user_ref_id' => $this->userId,
                            'student_subject_ref_id' => $postData['subject_pref' . $i], 'preference' => $i,
                            'added_on' => date('Y-m-d H:i:s')
                        );
                        if ($modelPreferedCareer->save(false)) {
                            /*$criticalFields = array('likely_start_period' => 1);
                    TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                    CommonUtils::calculateCriticalPercentage($this->userId); */
                        }
                    }
                }
            }

            $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'signup',
                    'class_level' => 9,
                    'label' => 'education_pref',
                ),
                1);
            $redirectUrlRefId = $urlDetails[0]['url_id'];
            TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));

            setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'career preferences'));
            $this->redirect($urlDetails[0]['url']);
        } else {
            CommonUtils::isSignupStepComplete($this->userId);
        }
        $boards = array();
        /*
        $userInfo = TblUserMaster::getUserDetails($this->userId);
        if($userInfo->membership_ref_id == 2 || $userInfo->membership_ref_id == 4){
            $instData = TblSiDi::GetInstIdFromSchoolId($userInfo->school_ref_id);
            if ($instData->inst_id) {
                $boardData = TblSiBoard::getSchoolBoardEquivalentList($instData->inst_id, '10');
                $boards = CHtml::listData($boardData, 'board_equivalent_id', 'board_desc');
            } else {
                $boards = CHtml::listData(LookupBoardEquivalent::GetSchoolBoardList('10'), 'board_equivalent_id', 'board_desc');
            }
        }else{ */
//            $criteria = new CDbCriteria;
//            $criteria->select = 'board_equivalent_id, board_name, board_ref_id';
//            $criteria->condition = "class_level = '10' ";
//            $criteria->order = " board_name asc ";
//            $boards_data = LookupBoardEquivalent::model()->findAll($criteria);
            
            $boards_data = LookupBoardEquivalent::getBoardByClassLevel(10);
            foreach ($boards_data as $board_data) {
                $id = $board_data->board_equivalent_id;
                $boards[$id] = $board_data->boardRef->board_desc;
                if ($this->userInfo->present_board_ref_id == $board_data->board_ref_id) {
                    $studentSignupModel->present_board_ref_id = $board_data->board_equivalent_id;
                }
            }
        //}
            $subjectList = array();
            if($studentSignupModel->present_board_ref_id) {
                $subjectList = LookupStudentSubject::getSubjectListByBoard($studentSignupModel->present_board_ref_id);
                $subjectList = CHtml::listData($subjectList,'student_subject_id','subject_name');
            }
            
            $studentPrefSubject = StudentPreferredSubject::getStudentPreferredSubjects($this->userId);
            foreach ($studentPrefSubject as $prefSubject) {
                $studentSignupModel->{subject_pref . $prefSubject->preference} = $prefSubject->student_subject_ref_id;
            }
            

        $this->render("career_preference", array('urlArr' => $urlArr, 'userMasterModel'=>$studentSignupModel, 'careers'=>$careerList, 'boards'=>$boards, 'subjectList' => $subjectList));
    }

    public function actionGetBoardSubjects() {
        $board_id =  $_POST['present_board_ref_id'];
        
        $data = LookupStudentSubject::getSubjectListByBoard($board_id);
        $data = CHtml::listData($data,'student_subject_id','subject_name');

        echo "<option value=''>Select Subject</option>";
        foreach($data as $key=>$value) {
            echo CHtml::tag('option', array('value'=>$key),CHtml::encode($value),true);
        }
    }

    public function actionCareerAutoComplete() {
        $careerList = array();

        /*$criteria = new CDbCriteria;
        $criteria->select = 'career_id, career_name';
        $criteria->condition = "is_active = 1 AND career_name like '%".$_GET['term']."%' ";
        $criteria->order = " career_name asc ";
        $criteria->limit = 5;*/
        $criteria = new CDbCriteria;
        $criteria->select = 't.career_id, t.career_name';
        $criteria->join = " LEFT JOIN `career_country` cc ON cc.career_ref_id = t.career_id ";
        $criteria->addCondition("t.is_active = 1 AND (cc.country_ref_id = '".Yii::app()->user->visitorCountry."' OR cc.career_country_id IS NULL)", "AND");
        $criteria->addCondition("career_name like '%".$_GET['term']."%'", "AND");
        $criteria->group = "t.career_name";
        $criteria->order = "t.career_name ASC";
        $criteria->limit = 5;
        $careers = LookupCareer::model()->findAll($criteria);
        $id = 0;
        foreach ($careers as $career) {
            $careerList[$id]['id'] = $career->career_id;
            $careerList[$id]['value'] = $career->career_name;
            $id++;
        }
        echo  CJSON::encode($careerList);
    }

    public $userParams = array();

    public function actionContact10() {
        $this->setPageTitle(Yii::app()->name .' - Your contact information');
        $this->getUserSessionInfo();

        $this->userInfo = TblUserMaster::getUserDetails($this->userId);

        $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
        $tabUrls = LookupUrl::getB2B10TabUrl();
        foreach($tabUrls as $tabUrl) {
            if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
            } else {
                $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
            }
        }
        
        $this->countryList = TblCountryMaster::getCountryList();

        $studentSignupModel = new StudentSignup('cssContactInfo10');
        $this->performAjaxValidation($studentSignupModel);

        if (isset($_POST['StudentSignup'])) {
            $studentSignupModel->attributes = $_POST['StudentSignup'];
            $postData = Yii::app()->request->getPost('StudentSignup');
            if ($studentSignupModel->validate()) {
                $studentModel = TblUserMaster::model()->findByPk($this->userId);

                $fields = array(
                    'address1' => $postData['address1'],
                    'address2' => $postData['address2'],
                    'country_ref_id' => $postData['country'],
                    'city_ref_id' => $postData['city'],
                    'post_code' => $postData['zip'],
                );

                if ($postData['country'] == 100) {
                    $fields['state_ref_id'] = $postData['state'];
                } else {
                    $fields['state_ref_id'] = NULL;
                }

                switch ($postData['relation_type']) {
                    case 2:
                    {
                        $fields['father_first_name'] = ucwords(strtolower(trim($postData['parent_first_name'])));
                        $fields['father_last_name'] = ucwords(strtolower(trim($postData['parent_last_name'])));
                        break;
                    }
                    case 3:
                    {
                        $fields['mother_first_name'] = ucwords(strtolower(trim($postData['parent_first_name'])));
                        $fields['mother_last_name'] = ucwords(strtolower(trim($postData['parent_last_name'])));
                        break;
                    }
                    case 4:
                    {
                        $fields['guardian_first_name'] = ucwords(strtolower(trim($postData['parent_first_name'])));
                        $fields['guardian_last_name'] = ucwords(strtolower(trim($postData['parent_last_name'])));
                        break;
                    }
                }

                $studentModel->setAttributes($fields);
                $studentModel->save(false);

                StudentAlternateEmail::deleteAlternateEmail($this->loginRefId);//, 1, array(array("field"=>"is_primary = 0", "condition" => "AND"))

                if($postData['username'] != ''){
                    StudentAlternateEmail::addAlternameEmail($this->userInfo->login_ref_id, 1, $postData['username'], $this->userInfo->login_ref_id, false, true);
                }

                if($postData['parent_email'] != ''){
                    StudentAlternateEmail::addAlternameEmail($this->userInfo->login_ref_id, $postData['relation_type'], $postData['parent_email'], $this->userInfo->login_ref_id, false, true);
                }

                StudentContactNumber::deleteContactNumbers($this->userId);
                $postData['alternate_phone_contry_code'] = str_replace('+', '', $postData['alternate_phone_contry_code']);
                $contactInfo = array(
                    'user_ref_id' => $this->userId,
                    'contact_type_ref_id' => 1,
                    'country_code' => $postData['alternate_phone_contry_code'],
                    'number' => $postData['alternate_phone'],
                    'is_primary' => 1,
                    'added_by' => $this->userInfo->login_ref_id,
                    'added_on' => date('Y-m-d H:i:s'),
                    'phone_type' => 'Home'
                );
                StudentContactNumber::addContactNumber($contactInfo);

                if($postData['parent_phone_country_code'] != '' && $postData['parent_phone']){
                    $postData['parent_phone_country_code'] = str_replace('+', '', $postData['parent_phone_country_code']);
                    $contactInfo = array(
                        'user_ref_id' => $this->userId,
                        'contact_type_ref_id' => $postData['relation_type'],
                        'country_code' => $postData['parent_phone_country_code'],
                        'number' => $postData['parent_phone'],
                        'is_primary' => 0,
                        'added_by' => $this->userInfo->login_ref_id,
                        'added_on' => date('Y-m-d H:i:s'),
                        'phone_type' => 'Home'
                    );
                    StudentContactNumber::addContactNumber($contactInfo);
                }

                $criticalFields = array('phone' => 1);
                TblUserProfCriticalCompletion::updateCriticalFields($this->userId, $criticalFields);
                CommonUtils::calculateCriticalPercentage($this->userId);

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'contact details'));

                $urlDetails = LookupUrl::getUrlByModel(array(
                    'class_level' => 0,
                    'label' => 'dashboard',
                ), 1);
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));

                CommonUtils::checkUserRedirection($this->userId, $this->action->Id);

            }
        } else {
            CommonUtils::isSignupStepComplete($this->userId);
        }

        
        // Auto filling data in form
        
        // Get Alternate Contact Details
        $parentContactData = StudentContactNumber::getParentContactNumbers($this->userId, 1);
        if($parentContactData) {
            foreach($parentContactData as $data){
                if($data->contact_type_ref_id == 2) {
                    $studentSignupModel->parent_first_name = $this->userInfo->father_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->father_last_name;
                } elseif($data->contact_type_ref_id == 3) {
                    $studentSignupModel->parent_first_name = $this->userInfo->mother_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->mother_last_name;
                } elseif($data->contact_type_ref_id == 4) {
                    $studentSignupModel->parent_first_name = $this->userInfo->guardian_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->guardian_last_name;
                }
                $studentSignupModel->parent_phone_country_code = $data->country_code;
                $studentSignupModel->parent_phone = $data->number;
                $studentSignupModel->relation_type = $data->contact_type_ref_id;
                $parentEmailData = StudentAlternateEmail::getEmailsOfParent($this->userInfo->login_ref_id, $data->contact_type_ref_id);
                foreach($parentEmailData as $data){
                    $studentSignupModel->parent_email = $data->email_id;
                    break;
                }
                break;
            }
        } else {
            // Get Alternate Email Details
            $parentEmailData = StudentAlternateEmail::getAllParentEmails($this->userInfo->login_ref_id);
            foreach($parentEmailData as $data){
                if($data->contact_type_ref_id == 2) {
                    $studentSignupModel->parent_first_name = $this->userInfo->father_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->father_last_name;
                } elseif($data->contact_type_ref_id == 3) {
                    $studentSignupModel->parent_first_name = $this->userInfo->mother_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->mother_last_name;
                } elseif($data->contact_type_ref_id == 4) {
                    $studentSignupModel->parent_first_name = $this->userInfo->guardian_first_name;
                    $studentSignupModel->parent_last_name = $this->userInfo->guardian_last_name;
                }
                $studentSignupModel->relation_type = $data->contact_type_ref_id;
                $studentSignupModel->parent_email = $data->email_id;
                break;
            }
        }

        
        
        // Student alternate email
        $studentEmailData = StudentAlternateEmail::getStudentAlternateEmail($this->userInfo->login_ref_id);
        $studentSignupModel->username = $studentEmailData->email_id;


        // Student phone no
        $studentContactData = StudentContactNumber::getFullContactNumbers($this->userId, "1");
        $studentSignupModel->alternate_phone_contry_code = $studentContactData->country_code;
        $studentSignupModel->alternate_phone = $studentContactData->number;

        $stateId = $this->userInfo->state_ref_id;
        $countryId = $this->userInfo->country_ref_id;
        if($stateId > 0){
            $this->cityList = TblCityMaster::getCityListByState($stateId);
        }elseif($countryId > 0){
            $this->cityList = TblCityMaster::getCityListByCountry($countryId);
        }
        
        $stateList = TblState::getStateByCountry($countryId);
        
        if(count($stateList) && $countryId == 100) {
            $this->stateList = $stateList;
        }
        
        $studentSignupModel->address1 = $this->userInfo->address1;
        $studentSignupModel->address2 = $this->userInfo->address2;
        $studentSignupModel->country = $this->userInfo->country_ref_id;
        $studentSignupModel->state = $this->userInfo->state_ref_id;
        $studentSignupModel->city = $this->userInfo->city_ref_id;
        $studentSignupModel->zip = $this->userInfo->post_code;
        
        
        $this->render('contact_10', array('urlArr' => $urlArr, 'userMasterModel' => $studentSignupModel));
    }

    public function actionInterests10() {
        $studentSignupModel = new StudentSignup('interests10');
        $this->performAjaxValidation($studentSignupModel);
        
        $obj = TblUserMaster::model()->findByPk($this->userId);
        
        $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
        $tabUrls = LookupUrl::getB2B10TabUrl();
        foreach($tabUrls as $tabUrl) {
            if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
            } else {
                $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
            }
        }
        
        if (!empty($_POST)) {

            $obj->other_activities = $_POST['StudentSignup']['interests'];
            $obj->save(false);
/*
            $tblUserInterestObj = new TblUserInterest();
            $tblUserInterestObj->user_ref_id = $this->userId;
            $tblUserInterestObj->interest_hobbies = $_POST['StudentSignup']['interests'];
            $tblUserInterestObj->save();
*/
            Yii::app()->session['isCompleteSignupNecessarySteps'] = '1'; // if this variable is set then user will get link on each tab
            $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'signup',
                    'class_level' => 9,
                    'label' => 'finish',
                ),
                1);
            $redirectUrlRefId = $urlDetails[0]['url_id'];
            TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));
            
            setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'interests & hobbies'));
            $this->redirect($urlDetails[0]['url']);
        } else {
            CommonUtils::isSignupStepComplete($this->userId);
        }

        $studentSignupModel->interests = $obj->other_activities;
        $this->render("interests10", array('urlArr' => $urlArr, 'userMasterModel'=>$studentSignupModel));
    }

    public function actionEducation10() {

        $studentSignupModel = new StudentSignup('Education10');
        $this->performAjaxValidation($studentSignupModel);
        $userId = $this->userId;

        $tblUserMasterModel = TblUserMaster::model()->findByPk($userId);
        
        $currentRedirectUrlOrder = TblUserMaster::getCurrentRedirectUrlOrder($this->userId);
        $tabUrls = LookupUrl::getB2B10TabUrl();
        foreach($tabUrls as $tabUrl) {
            if(Yii::app()->session->get('isCompleteSignupNecessarySteps') == "1" || $currentRedirectUrlOrder->redirectUrlRef->redirect_order >= $tabUrl->redirect_order ) {
                $urlArr[$tabUrl->label] = array('url' => $tabUrl->url, 'style' => '');
            } else {
                $urlArr[$tabUrl->label] = array('url' => "javascript:void(0);", 'style' => 'cursor:default;');
            }
        }
        
        $school12 = '';
        $si = TblSiStudents::model()->find('user_ref_id = :ID', array(':ID'=>$userId));
        $sms_access = TblSiDi::model()->find('inst_id=:ID ',array(':ID' =>$si->inst_ref_id));
        if ($tblUserMasterModel->schoolRef && ($sms_access->css_access == 1)) {
            $school12 = $tblUserMasterModel->schoolRef->school_name;
        }

        if (!empty($_POST)) {
            $customError = '';
            $studentEducationInfoData = $studentEducationMarksData = array();
            $studentEducationInfoData = Yii::app()->request->getPost('StudentEducationProfile');
            $studentEducationMarksData[10] = $_POST['StudentSignup']['10'];

            $schoolNameFlag = $passoutYearFlag = $boardFlag = $overallMarksFlag = $currentStudyFlag = 0;

            $id = 1;

            if ($_POST['StudentSignup']['present_board_ref_id'] != '') {
                $boardDetail10 = LookupBoardEquivalent::getBoardDetailById($_POST['StudentSignup']['present_board_ref_id']);
            }

            $scenario = '';
            if ($boardDetail10['overall_type'] == 'Marks') {
                $scenario = $boardDetail10['overall_type'];
            } elseif ($boardDetail10['overall_type'] == 'Points') {
                $scenario = $boardDetail10['overall_type'];
            } elseif ($boardDetail10['overall_type'] == 'Grades') {
                $scenario = $boardDetail10['overall_type'];
            } elseif ($boardDetail10['overall_type'] == 'Marks-GPA') {
                $scenario = "Marks-GPA10";
            }

            $studentEducationInfoModel10 = new StudentEducationProfile($scenario);

            $studentEducationInfoModel10->present_class = $tblUserMasterModel->present_class;
            $studentEducationInfoModel10->educationDetail = $tblUserMasterModel->present_class;
            $studentEducationInfoModel10->school_name = $_POST['StudentSignup']['school_name'];
            $studentEducationInfoModel10->board_equivalent_id = $_POST['StudentSignup']['present_board_ref_id'];
            $studentEducationInfoModel10->passout_month = $_POST['StudentSignup']['passout_month'];
            $studentEducationInfoModel10->passout_year = $_POST['StudentSignup']['passout_year'];
            $studentEducationInfoModel10->overall_marks = $_POST['StudentSignup'][10]['overall_marks'];
            $studentEducationInfoModel10->overall_grades_aa = $_POST['StudentSignup'][10]['overall_grade'][1];
            $studentEducationInfoModel10->overall_grades_a = $_POST['StudentSignup'][10]['overall_grade'][2];
            $studentEducationInfoModel10->overall_grades_b = $_POST['StudentSignup'][10]['overall_grade'][3];
            $studentEducationInfoModel10->overall_grades_c = $_POST['StudentSignup'][10]['overall_grade'][4];
            $studentEducationInfoModel10->overall_grades_d = $_POST['StudentSignup'][10]['overall_grade'][5];
            $studentEducationInfoModel10->overall_points = $_POST['StudentSignup'][10]['overall_points'];

            $errorCounter10_1 = 0;
            $errorCounter10_2 = 0;
            if ($customError == "") {
                if ($studentEducationInfoModel10->validate()) {
                    $errorCounter10_1++;
                }
                if ($studentEducationInfoModel10->hasErrors()) {
                    foreach ($studentEducationInfoModel10->getErrors() as $key => $value) {
                        foreach ($value as $errorMsg) {
                            $studentEducationInfoModel10->clearErrors();
                            $studentEducationInfoModel10->addError($key, $errorMsg);
                            $customError = $errorMsg;
                            break 2;
                        }
                    }
                }
            }

            $id = 1;
            $marksDetailModels10 = array();
            $subjectArray = array();
            if($_POST['StudentSignup']['present_board_ref_id'] != '') {
                foreach ($studentEducationMarksData['10'] as $key => $data) {
                    $marksDetailModels10[$id] = new StudentSubjectDetail();
                    $marksDetailModels10[$id]->attributes = $data;
                    $marksDetailModels10[$id]->scenario = $scenario;
                    if ($errorCounter10_1 > 0) {
                        if ($scenario == 'Marks') {
                            $studentMarks = $marksDetailModels10[$id]->marks;
                        } elseif ($scenario == 'Grades') {
                            $studentMarks = $marksDetailModels10[$id]->grade_ref_id;
                            if ($marksDetailModels10[$id]->grade_ref_id) {
                                $lookupGradeDetail = LookupGrade::model()->findByPk($marksDetailModels10[$id]->grade_ref_id);
                                $marksDetailModels10[$id]->grade = strtoupper($lookupGradeDetail->grade_type);
                            }
                        } elseif ($scenario == 'Points') {
                            $studentMarks = $marksDetailModels10[$id]->points;
                        } elseif ($scenario == 'Marks-GPA10') {
                            $studentMarks = $marksDetailModels10[$id]->marks;
                        }
                        if ($customError == "" && $marksDetailModels10[$id]->student_subject_ref_id != '' && $studentMarks != '') {
                            $marksDetailModels10[$id]->insertFlag = 1;
                            if (in_array($marksDetailModels10[$id]->student_subject_ref_id, $subjectArray)) {
                                $marksDetailModels10[$id]->addError('student_subject_ref_id', 'You selected the same subject again');
                                $customError = 'You selected the same subject again';
                                $errorCounter10_unique = 1;
                            } else {
                                $subjectArray[] = $marksDetailModels10[$id]->student_subject_ref_id;
                            }
                        }
                    }
                    $id++;
                }
            }

            foreach ($marksDetailModels10 as $key => $data) {
                if ($customError == "") {
                    if ($marksDetailModels10[$key]->validate()) {
                        $errorCounter10_2++;
                    }
                    if ($marksDetailModels10[$key]->hasErrors()) {
                        foreach ($marksDetailModels10[$key]->getErrors() as $k => $val) {
                            foreach ($val as $errorMsg) {
                                $marksDetailModels10[$key]->clearErrors();
                                $marksDetailModels10[$key]->addError($k, $errorMsg);
                                $customError = $errorMsg;
                                break 3;
                            }
                        }
                    }
                }
            }

            $studentTestInfoData = Yii::app()->request->getPost('StudentTestDetail');
            $studentTestModuleData = Yii::app()->request->getPost('StudentTestModuleDetail');
            if (!$studentTestModuleData) {
                $studentTestModuleData = array();
            }

            if (!$customError) {
                $tblUserModelObj = TblUserMaster::model()->findByPk($userId);

                // saving 10th data
                $studentEducationModel10 = new StudentEducation();
                $studentData10['user_ref_id'] = $userId;
                $studentData10['board_ref_id'] = $studentEducationInfoModel10->board_equivalent_id;
                if ($studentEducationInfoModel10->getScenario() == 'Marks') {
                    $studentData10['overall_marks'] = $studentEducationInfoModel10->overall_marks;
                    $studentData10['overall_points'] = NULL;
                } elseif ($studentEducationInfoModel10->getScenario() == 'Marks-GPA10') {
                    $studentData10['overall_marks'] = $studentEducationInfoModel10->overall_marks;
                    $studentData10['overall_points'] = NULL;
                } elseif ($studentEducationInfoModel10->getScenario() == 'Points') {
                    $studentData10['overall_marks'] = $studentEducationInfoModel10->overall_points;
                    $studentData10['overall_points'] = NULL;
                } elseif ($studentEducationInfoModel10->getScenario() == 'Grades') {
                    $studentData10['overall_points'] = NULL;
                    $studentData10['overall_marks'] = NULL;
                }
                $studentData10['year'] = $studentEducationInfoModel10->passout_year;
                $studentData10['month'] = $studentEducationInfoModel10->passout_month;
                $studentData10['class_level'] = '10';
                $studentData10['status'] = 'Pursuing';
                $studentData10['school_name'] = $studentEducationInfoModel10->school_name;
                $studentEducation10 = StudentEducation::getStudentEducationDetails($userId, '10');

                $studentEducationModel10->attributes = $studentData10;

                $studentEducationModel10->year = $_POST['StudentSignup']['passout_year'];
                $studentEducationModel10->month = $_POST['StudentSignup']['passout_month'];
                if ($_POST['StudentSignup']['change_school_not_sure'] == 1) {
                    $studentEducationModel10->change_school = 'NotSure';
                } else {
                    $studentEducationModel10->change_school = $_POST['StudentSignup']['change_school'];
                }
                if ($_POST['StudentSignup']['interested_stream_not_sure'] == 1) {
                    $studentEducationModel10->interested_stream = 'NotSure';
                } else {
                    $studentEducationModel10->interested_stream = $_POST['StudentSignup']['interested_stream'];
                }

                if ($studentEducation10) { 
                    $obj = StudentEducation::model()->findByPk($studentEducation10->student_education_id);
                    $obj->attributes = $studentEducationModel10->attributes;
                    $obj->interested_stream = $studentEducationModel10->interested_stream;
                   $obj->save();
                } else {
                    $studentEducationModel10->insert();
                }
                $id_det = StudentEducation::model()->find('user_ref_id = '.$userId." AND class_level = '10' ");

                StudentGradeCount::model()->deleteAll('student_education_ref_id=' . $id_det->student_education_id);
                if ($studentEducationInfoModel10->getScenario() == 'Grades') {
                    if ($studentEducationInfoModel10->overall_grades_aa) {
                        StudentGradeCount::setStudentGradeInfo($id_det->student_education_id, 1, $studentEducationInfoModel10->overall_grades_aa);
                    }
                    if ($studentEducationInfoModel10->overall_grades_a) {
                        StudentGradeCount::setStudentGradeInfo($id_det->student_education_id, 2, $studentEducationInfoModel10->overall_grades_a);
                    }
                    if ($studentEducationInfoModel10->overall_grades_b) {
                        StudentGradeCount::setStudentGradeInfo($id_det->student_education_id, 3, $studentEducationInfoModel10->overall_grades_b);
                    }
                    if ($studentEducationInfoModel10->overall_grades_c) {
                        StudentGradeCount::setStudentGradeInfo($id_det->student_education_id, 4, $studentEducationInfoModel10->overall_grades_c);
                    }
                    if ($studentEducationInfoModel10->overall_grades_d) {
                        StudentGradeCount::setStudentGradeInfo($id_det->student_education_id, 5, $studentEducationInfoModel10->overall_grades_d);
                    }
                }

                StudentEducationDetail::model()->deleteAll('student_education_ref_id=' . $id_det->student_education_id);
                foreach ($_POST['StudentSignup'][10]['subjects'] as $key=>$val) {
                    $obj = new StudentEducationDetail();
                    $obj->student_education_ref_id = $id_det->student_education_id;
                    $obj->student_subject_ref_id = $val;

                    if($studentEducationInfoModel10->getScenario()=='Grades'){
                        $obj->grade_ref_id = $_POST['StudentSignup'][10]['marks'][$key];
                    } elseif($studentEducationInfoModel10->getScenario()=='Marks-GPA10') {
                        $obj->grade_ref_id = $_POST['StudentSignup'][10]['marks'][$key];
                    } elseif($studentEducationInfoModel10->getScenario()=='Points') {
                        $obj->marks = $_POST['StudentSignup'][10]['points'][$key];
                    } else {
                        $obj->marks = $_POST['StudentSignup'][10]['marks'][$key];
                    }
                    
                    $obj->added_on = date('Y-m-d H:i:s');
                    if (($obj->grade_ref_id || $obj->marks) && $obj->student_subject_ref_id) {
                        $obj->save(false);
                    }

                }


                $tblUserMasterModel->present_board_ref_id = $boardDetail10['board_ref_id'];
                if($_POST['StudentSignup']['school_name'] != ''){
                    $schoolExistID = LookupSchool::getSchoolID($_POST['StudentSignup']['school_name']);
                    if ($schoolExistID) {
                        $tblUserMasterModel->school_ref_id = $schoolExistID;
                    } else {
                        LookupSchool::addStudentSchool($_POST['StudentSignup']['school_name']);
                        $schoolExistID = LookupSchool::getSchoolID($_POST['StudentSignup']['school_name']);
                        $tblUserMasterModel->school_ref_id = $schoolExistID;
                    }
                }
                $tblUserMasterModel->save();

                $criticalFields = array(
                    'edu_study_level' => $currentStudyFlag,
                    'school_name' => $schoolNameFlag,
                    'completion_year' => $passoutYearFlag,
                    'board' => $boardFlag,
                    'overall_marks' => $overallMarksFlag,
                );
                TblUserProfCriticalCompletion::updateCriticalFields($userId, $criticalFields);


                $urlDetails = LookupUrl::getUrlByModel(array('model_name' => 'signup',
                        'class_level' => 9,
                        'label' => 'interests_pref',
                    ),
                    1);
                $redirectUrlRefId = $urlDetails[0]['url_id'];
                TblUserMaster::updateUserFields($this->userId, array('redirect_url_ref_id' => $redirectUrlRefId));

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated', array('NAME' => 'education information'));
                $this->redirect($urlDetails[0]['url']);
            }
        } else {
            CommonUtils::isSignupStepComplete($this->userId);
        }
        $boards = array();
        /*$userInfo = TblUserMaster::getUserDetails($this->userId);
        if($userInfo->membership_ref_id == 2 || $userInfo->membership_ref_id == 4){
            $instData = TblSiDi::GetInstIdFromSchoolId($userInfo->school_ref_id);
            if ($instData->inst_id) {
                $boardData = TblSiBoard::getSchoolBoardEquivalentList($instData->inst_id, '10');
                $boards = CHtml::listData($boardData, 'board_equivalent_id', 'board_desc');
            } else {
                $boards = CHtml::listData(LookupBoardEquivalent::GetSchoolBoardList('10'), 'board_equivalent_id', 'board_desc');
            }
        }else{ */
            $boards_data = LookupBoardEquivalent::getBoardByClassLevel($tblUserMasterModel->present_class);
            foreach ($boards_data as $board_data) {
                $id = $board_data->board_equivalent_id;
                $boards[$id] = $board_data->boardRef->board_desc;
                if ($tblUserMasterModel->present_board_ref_id == $board_data->board_ref_id) {
                    $studentSignupModel->present_board_ref_id = $board_data->board_equivalent_id;
                }
            }
        //}

        // Auto Populate Data
        $educationDetail10 = StudentEducation::getStudentEducationDetails($userId, $tblUserMasterModel->present_class);
        if($educationDetail10->change_school == "NotSure") {
            $studentSignupModel->change_school_not_sure = $educationDetail10->change_school;
        } else {
            $studentSignupModel->change_school = $educationDetail10->change_school;
        }
        
        if($educationDetail10->change_school == "NotSure") {
            $studentSignupModel->interested_stream_not_sure = $educationDetail10->interested_stream;
        } else {
            $studentSignupModel->interested_stream = $educationDetail10->interested_stream;
        }
        
        if( $educationDetail10 ) {
            $studentSignupModel->passout_month = $educationDetail10->month;
            $studentSignupModel->passout_year = $educationDetail10->year;
            $studentSignupModel->school_name = $educationDetail10->school_name;
            
            $studentClassDetails['board'] = $studentSignupModel->present_board_ref_id;
            $boardDetails = LookupBoardEquivalent::GetBoardDetails($tblUserMasterModel->present_class, $studentSignupModel->present_board_ref_id);

            $studentClassDetails['overallMax'] = $boardDetails['overall_max'];
            $studentClassDetails['subjectMax'] = $boardDetails['subject_max'];
            $studentClassDetails['overallType'] = strtolower($boardDetails['overall_type']);
            $studentClassDetails['lookupBoardId'] = $boardDetails['board_ref_id'];
            $studentClassDetails['classLevel'] = $tblUserMasterModel->present_class;

            if(strtolower($boardDetails['overall_type']) == "grades") {
                $gradeEducation = StudentEducation::getGradeDetail($tblUserMasterModel->present_class, $userId);
                foreach($gradeEducation as $gradeData){
                    foreach($gradeData->studentGradeCounts as $grades) {
                        $gradeMarksArr[$grades->grade_ref_id] = $grades->grade_count;
                    }
                }
                $studentClassDetails['overallMarks'] = $gradeMarksArr;
            } else {
                $studentClassDetails['overallMarks'] = $educationDetail10->overall_marks;
            }

            $studentClassDetails['subjectsList'] = array();
            if($studentSignupModel->present_board_ref_id) {
                $studentClassDetails['subjectsList'] = LookupStudentSubject::getPreferredSubjectsByDepartment($studentSignupModel->present_board_ref_id, $this->studentPreferredDepartmentIds);
            }

            $educationSubjectData = StudentEducation::getSubjectDetail($tblUserMasterModel->present_class, $userId);
            $studentSubjectArr = array();
            foreach($educationSubjectData as $subjectsData) {
                foreach($subjectsData->studentEducationDetails as $subject) {
                    if(strtolower($boardDetails['overall_type']) == "grades" || strtolower($boardDetails['overall_type']) == "marks-gpa") {
                        $studentSubjectArr[$subject->student_subject_ref_id] =  $subject->grade_ref_id;
                    } else {
                        $studentSubjectArr[$subject->student_subject_ref_id] =  $subject->marks;
                    }
                }
            }
            if(count($studentSubjectArr)) {
                $studentClassDetails['subjects'] = $studentSubjectArr;
            }
        }
        //echo "<pre>";
        //print_r($studentClassDetails); exit;
            
        $this->render("education10", array("urlArr" => $urlArr, 'school12'=>$school12, 'boards'=>$boards, 'userMasterModel'=>$studentSignupModel, 'tblUserMasterModel'=>$tblUserMasterModel, 'autoPopulate' => $studentClassDetails ));
    }

    public function checkCssAccess(){

        $domainArray = explode('.', $_SERVER['HTTP_HOST'], 2);
        $subDomain = strtolower($domainArray[0]);
        $this->instId = TblSiDi::isCssSchool($subDomain);
        if($this->instId){
            $this->isCssAccess = TRUE;
            $result = StudentUploadMasterNoEmail::getPendingStudentDetailByClass($this->instId);
            //$this->cssStudentNames = CHtml::listData($result, 'student_upload_master_no_email_id', 'StudentUploadMasterNoEmail.first_name StudentUploadMasterNoEmail.last_name');
            foreach($result as $studentDetails){
                if($studentDetails['first_name'] != ''){
                    $this->cssStudentNames[$studentDetails['student_upload_master_no_email_id']]['first_name'] = $studentDetails['first_name'];
                    $this->cssStudentNames[$studentDetails['student_upload_master_no_email_id']]['last_name'] = $studentDetails['last_name'];
                    $this->cssStudentNamesList[$studentDetails['student_upload_master_no_email_id']] = $studentDetails['first_name'].' '.$studentDetails['last_name'];
                }

            }

        }
        if($subDomain != '' && $subDomain != 'www' && $subDomain != VHOST && !$this->isCssAccess){
            $this->redirect(PROTOCOL.$domainArray[1].'/app/home');
        }
    }

    public function actionFacebook(){		
        if(Yii::app()->user->isGuest){
			Yii::app()->theme = 'new_grid_theme';
			$this->layout = "//layouts/new_grid_signup";
			$this->render('fb_signup');
		}
		else{
			$this->redirect(Yii::app()->params['cbasepath'].'/app/home');			
		}
    }

    public function actionTrackValidation(){
        $email = Yii::app()->request->getQuery('img');
        if(isset($email)){
            $loginRes = LoginMaster::model()->findByAttributes(array('username'=>$email));
            $user = TblUserMaster::model()->findByAttributes(array('login_ref_id'=>$loginRes->login_id));
            $obj = ConfirmationEmailTracker::model()->findByAttributes(array('user_ref_id'=>$user->user_id));
            $obj->opened_on = date('Y-m-d H:i:s');
            $obj->save(false);

            if ($obj->user_ref_id) {
                $user = TblUserMaster::model()->findByPk($obj->user_ref_id);
                if ($user->login_ref_id) {
                    $login_master = LoginMaster::model()->findByPk($user->login_ref_id);
                    if ($login_master->is_email_confirmed == 0) {
                        $login_master->is_email_confirmed = 1;
                        $login_master->save(false);
                    }

                    Yii::import('application.components.profilevalidation.*');
                    $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$user->user_id));
                    if (!$profile_verify) {
                        $obj1 = new ValidateStudent();
                        $obj1->userId=$user->user_id;
                        $obj1->validateProfileAfterSignup();

                        $profile_verify = ProfileVerificationScore::model()->findByAttributes(array('user_ref_id'=>$user->user_id));
                    }

                    $validate = new ValidateStudent();
                    $validate->validate_after_confirmation($profile_verify->profile_verification_score_id, $user);

                }
            }
        }
    }

    public function actionCalculateLikelyStartPeriod() {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', '9600');

        $sql = "SELECT user_id FROM tbl_user_master WHERE passout_year > 2013 AND user_id NOT IN (SELECT DISTINCT user_ref_id FROM student_preferred_period);";
        $command =Yii::app()->db->createCommand($sql);
        $result = $command->queryAll();

        Yii::import('application.components.StudentRegistration.php');
        foreach ($result as $value) {
            $obj = new StudentRegistration();
            $obj->calculateLikelyStartPeriod($value['user_id']);
        }
    }
}

?>