<?php

/*
 * settings controller for student
 * 
 */

class SettingsController extends Controller{

    
    public function beforeAction($action) {
        parent::beforeAction($action);
        if(!Yii::app()->user->id) $this->redirect($this->createUrl('/home'));
        return true;
    }

    public function init()
    {
        parent::init();
        /*  Yii::app()->theme = 'uni_avada';
          $this->layout = "//layouts/inner_page";*/

        Yii::app()->theme = 'new_grid_theme';
         $this->layout = "//layouts/new_grid_inner";
    }

    public function actionIndex() {

        $this->breadcrumbs=array(
            'Home'=>array('/home'),
            'Account Settings',
        );

        $userId = Yii::app()->user->id;
        $user = LoginMaster::model()->findByPk($userId);

        $model = new StudentAlternateEmail('Settings');
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'add-email') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        $modelChangePassword = new ChangePasswordForm();

        if (isset($_POST['ajax']) && $_POST['ajax'] === 'changePassword') {
            echo CActiveForm::validate($modelChangePassword);
            //exit;
            Yii::app()->end();
        }
        $modelContactNumber = new StudentContactNumber('Settings');
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'addPhoneNumber') {
            echo CActiveForm::validate($modelContactNumber);
            Yii::app()->end();
        }

        $countryCodes = TblCountryMaster::getCountryPhoneCodes();
        $countryCodesValPairs = array();
        foreach($countryCodes as $countryCode) {
            $key = $countryCode['country_id'].'-'.$countryCode['phone_code'];
            $countryCodesValPairs[$key] = $countryCode['country_name'];
        }

        if (!empty($_POST)) {
            if ($_POST['StudentAlternateEmail']) {
                $model->email_id = $_POST['StudentAlternateEmail']['email_id'];
                $model->added_by = $_POST['StudentAlternateEmail']['added_by'];
                $model->added_on = date('Y-m-d H:i:s');
                $model->login_ref_id = $_POST['StudentAlternateEmail']['login_ref_id'];
                $model->is_active = 1;
                $model->contact_type_ref_id = 1;
                $model->is_primary = 0;
                if ($model->validate() ) {
                    $id = StudentAlternateEmail::getIdForEmail($_POST['StudentAlternateEmail']['email_id'], $userId);
                    if ($id) {
                        $student_alt_email = StudentAlternateEmail::model()->findByPk($id);
                        $student_alt_email->is_active = 1;
                        if ($student_alt_email->save()) {
                            $student_det = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
                            $this->sendConfirmationEmail($student_det->first_name, $user->username, 'confirmationTemplateMailPrimary', $student_alt_email->email_id, $userId, 'Successful profile update on Univariety');
                            $this->sendConfirmationEmail($student_det->first_name, $student_alt_email->email_id, 'confirmationTemplateMailSecondary', '', $userId, 'Please confirm your email address with Univariety');
                            setFlashMessage('success_notify', 'student_settingscontroller.email_added');
                            ?><script>window.location.href=window.location.href</script><?php
                        }
                    } else {
                        if ($model->save()) {
                            $student_det = TblUserMaster::model()->findByPk(Yii::app()->user->sub_id);
                            $this->sendConfirmationEmail($student_det->first_name, $user->username, 'confirmationTemplateMailPrimary', $model->email_id, $userId, 'Successful profile update on Univariety');
                            $this->sendConfirmationEmail($student_det->first_name, $model->email_id, 'confirmationTemplateMailSecondary', '', $userId, 'Please confirm your email address with Univariety');
                            setFlashMessage('success_notify', 'student_settingscontroller.email_added');
                            ?><script>window.location.href=window.location.href</script><?php
                        }
                    }
                }
            }

            if (isset($_POST['ChangePasswordForm'])) {
                $modelChangePassword->setAttributes($_POST['ChangePasswordForm']);
                if ($modelChangePassword->validate()) {
                    $res = $modelChangePassword->saveNewPassword();
                    setFlashMessage('success_notify', 'student_settingscontroller.password_changed');
                    $modelChangePassword = new ChangePasswordForm();
                }
            }

            if (isset($_POST['StudentContactNumber'])) {
                $modelContactNumber->user_ref_id = Yii::app()->user->sub_id;
                $modelContactNumber->added_by = $userId;
                $country_val_keys = explode('-', $_POST['StudentContactNumber']['country_code']);
                $modelContactNumber->phone_type = 'Mobile';
                $modelContactNumber->number = $_POST['StudentContactNumber']['number'];
                $modelContactNumber->country_code = $country_val_keys[1];
                $modelContactNumber->country_ref_id = $country_val_keys[0];
                $modelContactNumber->contact_type_ref_id = 1;
                $modelContactNumber->added_on = date('Y-m-d H:i:s');
                if ($modelContactNumber->validate() && $modelContactNumber->save()) {
                    setFlashMessage('success_notify', 'student_settingscontroller.phone_added');
                    $modelContactNumber = new StudentContactNumber();
                    $this->redirect($this->createUrl('index'));

                }

            }
        }

        $contact_numbers = StudentContactNumber::getAllContactNumbers(Yii::app()->user->sub_id, 1);
        $primary_numbers = StudentContactNumber::getPrimaryPhoneDetails(Yii::app()->user->sub_id, 1);
        $secondary_numbers = StudentContactNumber::getSecondaryPhoneDetails(Yii::app()->user->sub_id, 1);

        $alternate_emails = StudentAlternateEmail::getStudentAlternateEmail($userId);

       $this->render('index', array('user' => $user, 'alternate'=>$alternate_emails, 'model'=>$model, 'userId'=>$userId, 'modelChangePassword'=>$modelChangePassword,
            'modelContactNumber'=>$modelContactNumber, 'countryCodes'=>$countryCodesValPairs, 'contact_numbers'=>$contact_numbers, 'primary_numbers' => $primary_numbers,'secondary_numbers'=>$secondary_numbers));

    }


    public function actionError()
    {
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

    public function actionSaveEmail() {

    }

    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'StudentAlternateEmail') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (isset($_POST['ajax']) && $_POST['ajax'] === 'ChangePasswordForm') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if (isset($_POST['ajax']) && $_POST['ajax'] === 'StudentContactNumber') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionDeleteEmail()
    {
        if (!empty($_POST) && ($_POST['ajax'] == 'remove-email')) {
            $user_email = StudentAlternateEmail::model()->findByPk($_POST['id']);
            $ajaxOp = array();
            $user_email->is_active = 0;
            $user_email->is_confirmed = 0;
            if ($user_email->update()) {
                $ajaxOp['status'] = 'success';
            } else{
                $ajaxOp['status'] = 'failed';
            }
            echo CJSON::encode($ajaxOp);
        }
    }

    public function actionDeletePhone()
    {
        if (!empty($_POST) && ($_POST['ajax'] == 'remove-phone')) {
            $user_phone = StudentContactNumber::model()->findByPk($_POST['id']);
            $ajaxOp = array();
            if ($user_phone->delete()) {
                $ajaxOp['status'] = 'success';
            } else{
                $ajaxOp['status'] = 'failed';
            }
            echo CJSON::encode($ajaxOp);
        }
    }

    public function actionMarkPrimaryPhone() {
        $new_primary_id = $_POST['id'];
        if (!empty($_POST) && ($_POST['ajax'] == 'mark-phone-primary')) {

            $current_primary_id = StudentContactNumber::getPrimaryPhoneId(Yii::app()->user->sub_id, 1);
            if ($current_primary_id) {
                $current_primary = StudentContactNumber::model()->findByPk($current_primary_id);
                $current_primary->is_primary = 0;
                $current_primary->save();
            }
            $new_primary = StudentContactNumber::model()->findByPk($new_primary_id);
            $new_primary->is_primary = 1;

            $ajaxOp = array();
            if ($new_primary->save()) {
                $ajaxOp['status'] = 'success';
            } else{
                $ajaxOp['status'] = 'failed';
            }
            echo CJSON::encode($ajaxOp);
        }
    }

    public function actionMarkPrimaryEmail() {
        $new_primary_id = $_POST['id'];
        if (!empty($_POST) && ($_POST['ajax'] == 'mark-email-primary')) {
            $new_primary = StudentAlternateEmail::model()->findByPk($new_primary_id);

            $login_masterID = LoginMaster::getIdForEmail($new_primary->email_id);

            if (!$login_masterID) {
                $userId = Yii::app()->user->id;
                $user = LoginMaster::model()->findByPk($userId);
                $primary_email = $user->username;

                $user->username = $new_primary->email_id;

                $new_primary->email_id = $primary_email;

                if ($new_primary->save() && $user->save()) {
                    $ajaxOp['status'] = 'success';
                } else {
                    $ajaxOp['status'] = 'failed';
                }
            } else {
                $ajaxOp['status'] = 'failed';
            }
            echo CJSON::encode($ajaxOp);
        }
    }

    public function sendConfirmationEmail($firstName = false, $email = false, $template = false, $newEmail = fasle, $id = fasle, $subject = false)
    {

        $msg = $this->renderPartial($template,array('firstName'=>$firstName,'email' => $email,'newEmail' => $newEmail, 'id'=>$id,'siteURL'=>Yii::app()->params['cbasepath']),true);

        $params = array();
        $params['EmailMessage']['subject'] = $subject ? $subject : 'Registration Confirmation';
        $params['EmailMessage']['body'] =  $msg;
        $params['EmailMessage']['type'] = 'Signup';
        $params['EmailMessage']['siteUrl'] = '';
        $params['EmailMessage']['cc'] ='';
        $params['EmailMessage']['toName'] = $firstName;
        $params['EmailMessage']['toEmail'] =  $email;
        $params['EmailMessage']['apiKey'] =  Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;
        Yii::app()->user->setState('$_POST', $url);
        $status = Yii::app()->runController("sms/email/addMessage");
        return true;

    }

    public function actionConfirm() {
        if (($_GET['pe'] == 1)  && ($_GET['i'])) {
            $alt_id = StudentAlternateEmail::getIdForEmail(base64_decode($_GET['e']), base64_decode($_GET['i']));

            $alternate_details = StudentAlternateEmail::model()->findByPk($alt_id);
            if (($alternate_details->is_active == 1) && ($alternate_details->is_confirmed == 0)) {
                $alternate_details->is_confirmed = 1;
                $alternate_details->save();

                $loginMaster_det = LoginMaster::model()->findByPk($alternate_details->login_ref_id);
                $loginObj = new LoginMaster;
                $loginObj->skipPassword = true;


                if (Yii::app()->session['sUserUnivariety'] == '') {
                    setFlashMessage('success_notify', 'student_settingscontroller.sec_valid_link');
                    $loginObj->loginWithRedirect($loginMaster_det->username,'','/app/dashboard');
                } else {
                    setFlashMessage('success_notify', 'student_settingscontroller.sec_valid_link');
                    $this->redirect('/app/dashboard');
                }
            } else {
                setFlashMessage('error_notify', 'student_settingscontroller.sec_invalid_link');
                $this->redirect("/app/login");
            }

        } elseif (($_GET['ac'] == 2) && ($_GET['i'])) {
            $alt_id = StudentAlternateEmail::getIdForEmail(base64_decode($_GET['key1']), base64_decode($_GET['i']));
            $alternate_details = StudentAlternateEmail::model()->findByPk($alt_id);

            if (!$alternate_details) {
                $curr_alt_id = StudentAlternateEmail::getIdForEmail(base64_decode($_GET['key']), base64_decode($_GET['i']));
                $curr_alternate_details = StudentAlternateEmail::model()->findByPk($curr_alt_id);

                $curr_pri_id = LoginMaster::getIdForEmail(base64_decode($_GET['key1']));
                $curr_pri_details = LoginMaster::model()->findByPk($curr_pri_id);

                $curr_pri_details->username = base64_decode($_GET['key']);

                $curr_alternate_details->email_id = base64_decode($_GET['key1']);
                $curr_alternate_details->is_active = 0;

                if ($curr_pri_details->save() && $curr_alternate_details->save()) {

                    $loginObj = new LoginMaster;
                    $loginObj->skipPassword = true;

                    setFlashMessage('success_notify', 'student_settingscontroller.pri_confirm');
                    if (Yii::app()->session['sUserUnivariety'] == '') {
                        $loginObj->loginWithRedirect($curr_pri_details->username,'','/app/dashboard');
                    } else {
                        $this->redirect('/app/dashboard');
                    }

                }
            } else {
                $curr_alt_id = StudentAlternateEmail::getIdForEmail(base64_decode($_GET['key1']));
                $curr_alternate_details = StudentAlternateEmail::model()->findByPk($curr_alt_id);
                $curr_alternate_details->is_active = 0;
                $curr_alternate_details->save();

                $loginMaster_det = LoginMaster::model()->findByPk($curr_alternate_details->login_ref_id);
                $loginObj = new LoginMaster;
                $loginObj->skipPassword = true;

                setFlashMessage('success_notify', 'student_settingscontroller.pri_confirm');
                if (Yii::app()->session['sUserUnivariety'] == '') {
                    $loginObj->loginWithRedirect($loginMaster_det->username,'','/app/dashboard');
                } else {
                    $this->redirect('/app/dashboard');
                }
            }
        } elseif ($_GET['ac'] == 1) {

        } else {

            $this->redirect('/app/login');
        }
    }

    public function actionAjaxEmailBlock() {
        $userId = Yii::app()->user->id;
        $user = LoginMaster::model()->findByPk($userId);
        $model = new StudentAlternateEmail('Settings');

        $alternate_emails = StudentAlternateEmail::getStudentAlternateEmail($userId);
        $this->renderPartial('_email', array('user' => $user, 'alternate'=>$alternate_emails, 'model'=>$model, 'userId'=>$userId));
    }

    public function actionAjaxPhoneBlock() {
        $userId = Yii::app()->user->id;
        $user = LoginMaster::model()->findByPk($userId);
        $modelContactNumber = new StudentContactNumber('Settings');
        $countryCodes = TblCountryMaster::getCountryPhoneCodes();
        $countryCodesValPairs = array();
        foreach($countryCodes as $countryCode) {
            $key = $countryCode['country_id'].'-'.$countryCode['phone_code'];
            $countryCodesValPairs[$key] = $countryCode['country_name'];
        }

        $contact_numbers = StudentContactNumber::getAllContactNumbers(Yii::app()->user->sub_id, 1);
        $primary_numbers = StudentContactNumber::getPrimaryPhoneDetails(Yii::app()->user->sub_id, 1);
        $secondary_numbers = StudentContactNumber::getSecondaryPhoneDetails(Yii::app()->user->sub_id, 1);
        $this->renderPartial('_phone', array('user' => $user, 'userId'=>$userId, 'modelContactNumber'=>$modelContactNumber, 'countryCodes'=>$countryCodesValPairs, 'contact_numbers'=>$contact_numbers,'primary_numbers'=>$primary_numbers,'secondary_numbers'=>$secondary_numbers));
    }
    
    
    public function actionsms_alerts(){
        $alert_type = Yii::app()->request->getParam('type');
        if($alert_type) $sms_subscription = $this->_toggle_sms_subscription($alert_type);
        echo json_encode($sms_subscription->attributes);
        Yii::app()->end();
    }
    
    protected function _toggle_sms_subscription($alert_type){
        
        $sms_subscription = SmsSubscription::model()->find('user_ref_id = :user_id AND type_of_service = :alert_type', array(':user_id' => Yii::app()->user->sub_id, 'alert_type' => $alert_type));
        if($sms_subscription){
            $sms_subscription->is_unsubscribed = ($sms_subscription->is_unsubscribed == 'N')?'Y':'N';
            $sms_subscription->added_on = date('Y-m-d H:i:s');
        }else{
            $sms_subscription = new SmsSubscription();
            $sms_subscription->setAttributes(array(
                'user_ref_id' => Yii::app()->user->sub_id,
                'type_of_service' => $alert_type,
                'is_unsubscribed' => 'Y',
                'added_on' => date('Y-m-d H:i:s')
            ), false);
        }
        
        $student_contact_number = StudentContactNumber::model()->find('user_ref_id = :user_id AND is_primary = 1', array(':user_id' => Yii::app()->user->sub_id));
        if($student_contact_number) $sms_subscription->student_contact_ref_id = $student_contact_number->student_contact_number_id;
        $sms_subscription->save(FALSE);
        return $sms_subscription;
    }
    
}

