<?php
class ProfileController extends Controller
{
    public $userId = 0;
    public $loginRefId = 0;
    public $userData;

    public $rbacRole = '';
    public $_hasEdit = false;
    public $_isDI = false;

    public $defaultUserData = array('M' => array('gender' => 'Male', 'defaultImage' => 'user_img_male.jpg'), 'F' => array('gender' => 'Female', 'defaultImage' => 'user_img_female.jpg'));
    public $userImage = '';
    public $isUserImageAvailable = false;
    public $isUploading = false;
    public $imageUploadErrorMessage = '';
    public $userParams = array();
    public $schoolName = '';
    public $courseLevel = array();
    public $countryList = array();
    public $departments = array();
    public $subDeptList = array();
    public $subjectList = array();
    public $moduleList = array();
    public $likelyperiod = array();

    public $fldSportsArr = array();
    public $fldSportsLevelArr = array();
    public $fldMusicArr = array();
    public $fldMusicLevelArr = array();
    public $fldVoiceArr = array();
    public $fldVoiceLevelArr = array();
    public $fldVisualartArr = array();
    public $fldVisualartLevelArr = array();
    public $fldPerformingArtsArr = array();
    public $fldPerformingArtsLevelArr = array();
    public $studentEntranceexamArr = array();
    public $entranceExammoduleArr = array();
    public $studentClassDetails = array();
    public $yearlist = array();
    public $boardArr = array();
    public $schoolArr = array();
    public $overallArr = array();
    public $classLevelArr = array();
    public $entranceExammoduleID = array();
    public $entranceExammodulemarks = array();

    public $studenteducationArr = array();
    public $subjectArr = array();
    public $subjectmarksArr = array();
    public $yearArr = array();
    public $monthArr = array();
    public $entranceexamID = array();
    public $entranceexamstatus = array();
    public $entranceexamappear = array();
    public $entranceexamoverall = array();

    public $currentStudyLevelArray = array(
        '12c' => 'Completed - 12th or equivalent',
        '12p' => 'Pursuing - 12th or equivalent',
        '11p' => 'Pursuing - 11th or equivalent',
        //'10p' => 'Pursuing - 10th or equivalent',
        //'9p' => 'Pursuing - 9th or equivalent',
    );
    public $currentStudyLevelDbValuesArray = array(
        '12c' => array('12', 'Completed'),
        '12p' => array('12', 'Pursuing'),
        '11p' => array('11', 'Pursuing'),
        //'10p' => array('10', 'Pursuing'),
        //'9p' => array('9', 'Pursuing'),
    );
    public $profileValidationAccess = false;


    public function filters(){
        return array(
            'rights',
        );
    }
    /*public function accessRules()
    {
        return array(
            array('allow',
                  'users' => array('*'),
            ),
        );
    }*/

    public function init()
    {
        parent::init();
        $cs = Yii::app()->clientScript;
        $cs->scriptMap['main.js'] = false;
        Yii::app()->theme = 'uni_avada';
        //$this->layout = "//layouts/inner_page";
        $this->layout = "//layouts/profile";
        $this->pageTitle = 'Univariety - Edit Profile';

        $this->userId = CommonUtils::getSessionValue('sUserUnivariety', 'UserId');
        $this->loginRefId = Yii::app()->session['loginID'];
        $this->rbacRole = CommonUtils::getRbacUserRole(Yii::app()->user->id);


        if ($this->userId < 1 && Yii::app()->request->getParam('uid') > 0 && ($this->rbacRole == 'SI' || $this->rbacRole == 'HeadAdvisor' || $this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin' || $this->rbacRole == 'DI')) {
            $this->userId = Yii::app()->request->getQuery('uid');
        }

        if ($this->rbacRole == 'Student' || $this->rbacRole == 'SI' || $this->rbacRole == 'HeadAdvisor' || $this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin') {
            $this->_hasEdit = true;
        }



        if ($this->rbacRole == 'DI') {
            $this->_isDI = true;
			$this->_hasEdit = false;
        }

        if($this->rbacRole != 'Student'){
            $this->userParams = array('uid' => $this->userId);
        }

        if($this->userId == '' || $this->userId <= 0){
            $this->redirect(Yii::app()->createUrl('login'));
        }

        $this->userData = TblUserMaster::getUserDetails($this->userId);

        if($this->userData->present_class == 9 || $this->userData->present_class == 10){
            $this->_hasEdit = false;
        }

        if($this->rbacRole == 'HeadAdvisor' || $this->rbacRole == 'SuperAdmin' || $this->rbacRole == 'Advisor' || $this->rbacRole == 'Admin'){
            $this->profileValidationAccess = true;
        }
        //$this->printr($_SESSION);
    }

    public function printr($array = array())
    {
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }

    protected function performAjaxValidation($model)
    {
        if (isset($_POST['ajax']) && $_POST['ajax'] === 'postRegistration') {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }

    public function actionIndex()
    {
        if ($this->rbacRole == 'Student') {
            $this->breadcrumbs=array(
                'Home'=>array('/dashboard'),
                'My Profile',
            );
        }

        $this->userData->gender = ($this->userData->gender != '') ? $this->userData->gender : 'M';
        if ($this->userData->user_photo != '') {
            if (file_exists($userImagePath . $this->userData->user_photo)) {
                $this->userImage = $userImagePath . $this->userData->user_photo;
                $this->isUserImageAvailable = true;
            }else{
                $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
            }
        }
        if ($this->userImage == '') {
            $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
        }

        $this->render("index");
    }

    public function actionEditBasicInfo()
    {
        $this->breadcrumbs=array(
            'Home'=>array('/home'),
            'My Profile'=>array('/student/profile'),
            'Edit Profile',
        );

        $editProfileModel = new EditProfile('basicInfo');
        $this->performAjaxValidation($editProfileModel);

        $this->pageTitle = 'Univariety - Edit Basic Info';

        //$editProfileModel->setAttributes($this->userData);
        foreach ($editProfileModel->attributes as $key => $value) {
            $editProfileModel->{$key} = $this->userData->attributes[$key];
        }

        $dob = explode('-', $this->userData->attributes['dob']);
        $editProfileModel->dob_date = $dob[2];
        $editProfileModel->dob_month = $dob[1];
        $editProfileModel->dob_year = $dob[0];
        $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
        $this->userData->gender = ($this->userData->gender != '') ? $this->userData->gender : 'M';

        $this->schoolName = LookupSchool::getPresentSchoolName($this->userData->school_ref_id);

        if ($this->userData->user_photo != '') {
            if (file_exists($userImagePath . $this->userData->user_photo)) {
                $this->userImage = $userImagePath . $this->userData->user_photo;
                $this->isUserImageAvailable = true;
            }else{
                $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
            }
        }
        if ($this->userImage == '') {
            $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
        }

        $editProfileModel->email_address = $this->userData->loginRef->username;

        $studentContactNumber = StudentContactNumber::getFullContactNumbers($this->userData->attributes['user_id'], 1);
        $editProfileModel->phone_num = $studentContactNumber->attributes['number'];
        $editProfileModel->country_code = $studentContactNumber->attributes['country_code'];

        $fatherEmail = StudentAlternateEmail::getFatherEmail($this->userData->attributes['login_ref_id']);
        $fatherContactNumber = StudentContactNumber::getContactNumbers($this->userData->attributes['user_id'], 2);
        $motherEmail = StudentAlternateEmail::getMotherEmail($this->userData->attributes['login_ref_id']);
        $motherContactNumber = StudentContactNumber::getContactNumbers($this->userData->attributes['user_id'], 3);

        if($fatherEmail !='' || $fatherContactNumber !='') {
            $parentType = 2;
            $parentfirstName = $this->userData->attributes['father_first_name'];
            $parentlastName = $this->userData->attributes['father_last_name'];
            $Email = $fatherEmail;
            $fatherContactNumber = StudentContactNumber::getFullContactNumbers($this->userData->attributes['user_id'], 2);
            $editProfileModel->parent_phone_num = $fatherContactNumber->attributes['number'];
            $editProfileModel->parent_country_code = $fatherContactNumber->attributes['country_code'];
        } else if($motherEmail !='' || $motherContactNumber !=''){
            $parentType = 3;
            $parentfirstName = $this->userData->attributes['mother_first_name'];
            $parentlastName = $this->userData->attributes['mother_last_name'];
            $Email = $motherEmail;
            $motherContactNumber = StudentContactNumber::getFullContactNumbers($this->userData->attributes['user_id'], 3);
            $editProfileModel->parent_phone_num = $motherContactNumber->attributes['number'];
            $editProfileModel->parent_country_code = $motherContactNumber->attributes['country_code'];
        } else {
            $parentType = 4;
            $parentfirstName = $this->userData->attributes['guardian_first_name'];
            $parentlastName = $this->userData->attributes['guardian_last_name'];
            $Email = StudentAlternateEmail::getGuardEmail($this->userData->attributes['login_ref_id']);
            $ContactNumber = StudentContactNumber::getFullContactNumbers($this->userData->attributes['user_id'], 4);
            $editProfileModel->parent_phone_num = $ContactNumber->attributes['number'];
            $editProfileModel->parent_country_code = $ContactNumber->attributes['country_code'];
        }

        $editProfileModel->parent_first_name = $parentfirstName;
        $editProfileModel->parent_last_name = $parentlastName;
        $editProfileModel->contact_type = $parentType;
        $editProfileModel->parent_email_address = $Email;

        if (isset($_POST['EditProfile'])) {
            $editProfileModel->attributes = $_POST['EditProfile'];
            $postData = Yii::app()->request->getPost('EditProfile');
            $this->userData->attributes = $postData;
            //$this->printr($postData);
            if ($editProfileModel->validate()) {
                if($postData['contact_type'] == 2) {
                    $this->userData->{father_first_name} = $postData['parent_first_name'];
                    $this->userData->{father_last_name} = $postData['parent_last_name'];
                } else if($postData['contact_type'] == 3) {
                    $this->userData->{mother_first_name} = $postData['parent_first_name'];
                    $this->userData->{mother_last_name} = $postData['parent_last_name'];
                } else if($postData['contact_type'] == 4) {
                    $this->userData->{guardian_first_name} = $postData['parent_first_name'];
                    $this->userData->{guardian_last_name} = $postData['parent_last_name'];
                }
                $this->userData->{dob} = $postData['dob_year']."-".$postData['dob_month']."-".$postData['dob_date'];
                $schoolExistID = LookupSchool::getSchoolID($postData['present_school']);
                if($schoolExistID) {
                   $this->userData->{school_ref_id} = $schoolExistID;
                } else {
                    LookupSchool::addStudentSchool($postData['present_school']);
                    $schoolExistID = LookupSchool::getSchoolID($postData['present_school']);
                    $this->userData->{school_ref_id} = $schoolExistID;
                }
                if(!empty($this->userData->attributes['login_ref_id']))
                {
                    //$this->__setAlternateEmail(1,$postData['email_address']);
                    $this->__setAlternateEmail($postData['contact_type'],$postData['parent_email_address']);
                    $this->__setContactNumber(1,$postData['country_code'],$postData['phone_num']);
                    $this->__setContactNumber($postData['contact_type'],$postData['parent_country_code'],$postData['parent_phone_num']);
                }

                $this->userData->save(false);

                if($postData['phone_num']!= "") {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET phone='1' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                } else {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET phone='0' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                }

                if($postData['citizenship_ref_id']!= "") {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET citizenship='1' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                } else {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET citizenship='0' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                }

                $criticalFields = array('name' => 1, 'dob' => 1, 'gender' => 1);
                $modelCriticalFields = TblUserProfCriticalCompletion::model()->find(array("condition" => "user_ref_id = ".$this->userId));
                $modelCriticalFields->setAttributes($criticalFields);
                $modelCriticalFields->save(false);

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated',array('NAME' => 'Basic Information'));
                CommonUtils::calculateCriticalPercentage($this->userId);
                $this->redirect(Yii::app()->createUrl('student/Profile/EditEducation', $this->userParams));
            }
        }

        $this->render("editBasicInfo", array('editProfileModel' => $editProfileModel));
    }

    public function __setAlternateEmail($contactType,$emailStudent) {
        $criteria = new CDbCriteria;
        $criteria->condition = "login_ref_id = '".$this->userData->attributes['login_ref_id']."' AND contact_type_ref_id <> '1'";
        $studentEmail = StudentAlternateEmail::model()->findAll($criteria);
        //$studentEmailID = $studentEmail->attributes['student_alternate_email_id'];
        foreach($studentEmail as $studentEmails) {
            StudentAlternateEmail::model()->deleteByPk($studentEmails->attributes['student_alternate_email_id']);
        }

        $studentAlternateEmail = new StudentAlternateEmail;
        $studentAlternateEmail->{email_id} = $emailStudent;
        $studentAlternateEmail->{contact_type_ref_id} = $contactType;
        $studentAlternateEmail->{login_ref_id} = $this->userData->attributes['login_ref_id'];
        $studentAlternateEmail->{added_by} = $this->userData->attributes['login_ref_id'];
        $studentAlternateEmail->save();
    }

    public function __setContactNumber($contactType, $phonecode, $phonenum) {
        $criteria = new CDbCriteria;
        if($contactType == 1) {
            $criteria->condition = "user_ref_id = '".$this->userData->attributes['user_id']."' AND contact_type_ref_id = '1'";
            $criteria->addCondition(" is_primary = 1");
            $studentContact = StudentContactNumber::model()->find($criteria);
            $studentContactID = $studentContact->attributes['student_contact_number_id'];
            $studentContactNumber = $studentContactID > 0 ? StudentContactNumber::model()->findByPk($studentContactID) : new StudentContactNumber;
        } else {
            $criteria->condition = "user_ref_id = '".$this->userData->attributes['user_id']."' AND contact_type_ref_id <> '1'";
            $studentContact = StudentContactNumber::model()->findAll($criteria);
            foreach($studentContact as $studentContacts) {
                StudentContactNumber::model()->deleteByPk($studentContacts->attributes['student_contact_number_id']);
            }
            $studentContactNumber = new StudentContactNumber;
        }

        $studentContactNumber->{country_code} = $phonecode;
        $studentContactNumber->{number} = $phonenum;
        $studentContactNumber->{contact_type_ref_id} = $contactType;
        $studentContactNumber->{user_ref_id} = $this->userData->attributes['user_id'];
        $studentContactNumber->{added_by} = $this->userData->attributes['login_ref_id'];
        if($contactType == 1) {
            $studentContactNumber->{is_primary} = 1;
        }
        $studentContactNumber->save();
    }

    public function actionGetStatesList(){
        $countryId = Yii::app()->request->getQuery('countryId');
        $result = TblState::getStateByCountry($countryId);
        echo json_encode($result);
    }

    public function actionGetCountryCode(){
        $countryId = Yii::app()->request->getQuery('countryId');
        $result = TblCountryMaster::getPhoneCode($countryId);
        echo $result;
    }

    public function actionGetCityList(){
        $countryId = Yii::app()->request->getQuery('countryId');
        $stateId = Yii::app()->request->getQuery('stateId');
        $result = array();
        if($stateId > 0){
            //$result = TblCityMaster::getCityListByState($stateId);
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND state_ref_id = '".$stateId."'", "order" => "city_name"));
        }else if($countryId > 0){
            //$result = TblCityMaster::getCityListByCountry($countryId);
            $result = TblCityMaster::model()->findAll(array("condition" => "is_active = 1 AND country_id = '".$countryId."'", "order" => "city_name"));
        }
        $cityResults = array();
        foreach($result as $city){
            $cityResults[$city->attributes['city_id']] = $city->attributes['city_name'];
        }
        echo json_encode($cityResults);
    }

    public function actionUploadUserImage()
    {
        $latestUrlForRedirection = CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');
        $this->isUserImageAvailable = false;

        $path = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
        $valid_formats = array(".jpg", ".png", ".gif");
        if (isset($_POST) and $_SERVER['REQUEST_METHOD'] == "POST") {
            $name = $_FILES['photoimg']['name'];
            $size = $_FILES['photoimg']['size'];

            if (strlen($name)) {
                //list($txt, $ext) = strrchr($name, '.');//explode(".", $name);
                $ext = strrchr($name, '.');
                $ext = strtolower($ext);
                if (in_array($ext, $valid_formats)) {
                    if ($size < (1024 * 1024)) {
                        $actual_image_name = 'img_U_'.time() . $ext; //time() . substr(str_replace(" ", "_", $txt), 5) . "." . $ext;
                        $tmp = $_FILES['photoimg']['tmp_name'];
                        if (move_uploaded_file($tmp, $path . $actual_image_name)) {
                            $this->actionDeleteUserImage(false);
                            $this->isUserImageAvailable = true;
                            $this->userImage = $actual_image_name;

                            $studentModel = TblUserMaster::model()->findByPk($this->userId);
                            $studentModel->setAttributes(array('user_photo' => $this->userImage));
                            $studentModel->save(false);

                        } else{
                            $this->isUploading = true;
                            $this->imageUploadErrorMessage = "Image upload failed";
                        }

                    } else{
                        $this->isUploading = true;
                        $this->imageUploadErrorMessage = "Image file size max 1 MB";
                    }
                } else{
                    $this->isUploading = true;
                    $this->imageUploadErrorMessage = "Invalid file format..";
                }
            } else{
                $this->isUploading = true;
                $this->imageUploadErrorMessage = "Please select image..!";
            }

            $this->userData = TblUserMaster::getUserDetails($this->userId);
            $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
            if ($this->userData->user_photo != '') {
                if (file_exists($userImagePath . $this->userData->user_photo)) {
                    $this->isUserImageAvailable = true;
                    $this->userImage = $userImagePath . $this->userData->user_photo;
                }else{
                    $this->isUserImageAvailable = false;
                    $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
                }
            }else{
                $this->isUserImageAvailable = false;
                $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
            }
            $this->renderPartial('_studentImage');
            exit;
        }
    }

    public function actionDeleteUserImage($useSubView = true)
    {
        $this->isUserImageAvailable = false;
        $latestUrlForRedirection = CommonUtils::getSessionValue('sPartnersSlug', 'latestUrlForRedirection');

        $this->userData = TblUserMaster::getUserDetails($this->userId);
        //$studentModel = TblUserMaster::model()->find()
        $userImagePath = Yii::app()->params['docRootPath'] . '/uploads/user/thumb/';
        if ($this->userData->user_photo != '') {
            if (file_exists($userImagePath . $this->userData->user_photo)) {
                if (unlink($userImagePath . $this->userData->user_photo)) {
                    $this->isUserImageAvailable = false;
                    $studentModel = TblUserMaster::model()->findByPk($this->userId);
                    $studentModel->setAttributes(array('user_photo' => ''));
                    $studentModel->save(false);
                    $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
                } else {
                    $this->userImage = $userImagePath . $this->userData->user_photo;
                    $this->isUserImageAvailable = true;
                }
            }
        } else {
            $this->userImage = $userImagePath . $this->defaultUserData[$this->userData->gender]['defaultImage'];
        }
        if($useSubView){
            $this->renderPartial('_studentImage');
        }
    }

    public function actionEditEducation(){
        $this->breadcrumbs=array(
            'Home'=>array('/home'),
            'My Profile'=>array('/student/profile'),
            'Edit Profile',
        );

        $editEducationModel = new EditProfile('EducationInfo');
        $this->performAjaxValidation($editEducationModel);
        $this->pageTitle = 'Univariety - Edit Education Details';
        $presentClass = $this->userData->present_class;
        $presentClassStatus = $this->userData->class_status;
        if($_POST['EditProfile']['present_studylevel']) {
            $ClassLevel = $_POST['EditProfile']['present_studylevel'];
            $ClassLevel = $this->currentStudyLevelDbValuesArray[$ClassLevel];
            $presentClass = $ClassLevel[0];
            $presentClassStatus = $ClassLevel[1];
            $presentClassLevel = $ClassLevel[0].$ClassLevel[1];
        } else
            $presentClassLevel = $this->userData->present_class.$this->userData->class_status;

        if($presentClassStatus == "Completed")
            $presentClassStatus1 = 'c';
        else
            $presentClassStatus1 = 'p';

        $editEducationModel->{present_studylevel} = $presentClass.$presentClassStatus1;

        switch($presentClassLevel){
            case '12Completed':{
                $this->studentClassDetails[12]['label'] = '12th Completed';
                $this->studentClassDetails[10]['label'] = '10th Completed ';
                break;
            }
            case '12Pursuing':{
                $this->studentClassDetails[12]['label'] = '12th Expected';
                $this->studentClassDetails[10]['label'] = '10th Completed';
                break;
            }
            case '11Pursuing':{
                $this->studentClassDetails[12]['label'] = '12th Expected';
                $this->studentClassDetails[10]['label'] = '10th Completed';
                break;
            }
            case '10Pursuing':{
                $this->studentClassDetails[10]['label'] = '10th Expected';
                break;
            }
            case '9Pursuing':{
                $this->studentClassDetails[10]['label'] = '10th Expected';
                break;
            }
        }

        foreach($this->studentClassDetails as $class => $classDetails){
            $studentEducationDetails = StudentEducation::getStudentEducationDetails($this->userId, $class);
            $this->studenteducationArr[$class][] = count($studentEducationDetails->studentEducationDetails);
            $this->boardArr[$class] = $studentEducationDetails->attributes['board_ref_id'];
            $this->yearArr[$class] = $studentEducationDetails->attributes['year'];
            $this->monthArr[$class] = $studentEducationDetails->attributes['month'];
            $this->schoolArr[$class] = $studentEducationDetails->attributes['school_name'];
            $this->overallArr[$class] = $studentEducationDetails->attributes['overall_marks'];

            for($i=0;$i<$this->studenteducationArr[$class][0];$i++) {
                if($this->boardArr[$class] == '11' || $this->boardArr[$class] == '13' || $this->boardArr[$class] == '14'
                    || $this->boardArr[$class] == '17' || $this->boardArr[$class] == '1' || $this->boardArr[$class] == '2'
                    || $this->boardArr[$class] == '4' || $this->boardArr[$class] == '15') {
                    $this->subjectArr[$class][] = $studentEducationDetails->studentEducationDetails[$i]->attributes['student_subject_ref_id'];
                    $this->subjectmarksArr[$class][] = $studentEducationDetails->studentEducationDetails[$i]->attributes['marks'];
                }

                else if($this->boardArr[$class] == '10' || $this->boardArr[$class] == '20' || $this->boardArr[$class] == '3'
                    || $this->boardArr[$class] == '18') {
                    $this->subjectArr[$class][] = $studentEducationDetails->studentEducationDetails[$i]->attributes['student_subject_ref_id'];
                    $this->subjectmarksArr[$class][] = $studentEducationDetails->studentEducationDetails[$i]->attributes['grade_ref_id'];
                }

                else if($this->boardArr[$class] == '12' || $this->boardArr[$class] == '27') {
                    $this->subjectArr[$class][] = $studentEducationDetails->studentEducationDetails[$i]->attributes['student_subject_ref_id'];
                    $this->subjectmarksArr[$class][] = $studentEducationDetails->studentEducationDetails[$i]->attributes['marks'];
                }

            }
        }

        $criteria = new CDbCriteria();
        $criteria->condition = "user_ref_id = ".$this->userId;
        $entranceUserList = UserEntranceExam::model()->findAll($criteria);
        $this->studentEntranceexamArr = count($entranceUserList);
        foreach($entranceUserList as $entranceUserLists) {
            $this->entranceexamID[] = $entranceUserLists['entrance_exam_ref_id'];
            $this->entranceexamstatus[] = $entranceUserLists['exam_status'];
            $this->entranceexamappear[] = $entranceUserLists['exam_year'];
            $this->entranceexamoverall[] = $entranceUserLists['overall_marks'];
            $userEntrancelist = UserEntranceExamModule::getUserEntranceexamList($entranceUserLists['user_entrance_exam_id']);
            $this->entranceExammoduleArr[] = count($userEntrancelist);
            foreach($userEntrancelist as $userEntrancelists) {
                 $this->entranceExammoduleID[$entranceUserLists['entrance_exam_ref_id']][] = $userEntrancelists['entrance_exam_module_entrance_exam_ref_id'];
                 $this->entranceExammodulemarks[$entranceUserLists['entrance_exam_ref_id']][] = $userEntrancelists['marks'];
            }
        }

        if (isset($_POST['EditProfile'])) {
            $editEducationModel->attributes = $_POST['EditProfile'];
            $postData = Yii::app()->request->getPost('EditProfile');

            //$this->printr($postData);
            $this->subjectArr = array();
            $this->subjectmarksArr = array();
            $this->studenteducationArr = array();
            $this->boardArr = array();
            $this->yearArr = array();
            $this->monthArr = array();
            $this->schoolArr = array();
            $this->overallArr = array();
            foreach($this->studentClassDetails as $class => $classDetails){
                $this->boardArr[$class] = $postData['board'.$class][0];
                $this->schoolArr[$class] = $postData['present_school'.$class][0];
                $this->yearArr[$class] = $postData['passout_year'.$class][0];
                $this->monthArr[$class] = $postData['passout_month'.$class][0];
                if($this->boardArr[$class] == '11' || $this->boardArr[$class] == '13' || $this->boardArr[$class] == '14'
                    || $this->boardArr[$class] == '17' || $this->boardArr[$class] == '1' || $this->boardArr[$class] == '2'
                    || $this->boardArr[$class] == '4' || $this->boardArr[$class] == '15') {
                    $subject_class = array();
                    $subject_score = array();
                    $this->overallArr[$class] = $postData['overall_score_'.$class][0];
                    for($i=0;$i<count($postData['subject_'.$class]);$i++) {
                        if($postData['subject_'.$class][$i] != 0){
                            $subject_class[] = $postData['subject_'.$class][$i];
                            $subject_score[] = $postData['subject_score_'.$class][$i];
                        }
                    }
                } else if($this->boardArr[$class] == '12' || $this->boardArr[$class] == '27') {
                    $subject_class = array();
                    $subject_score = array();
                    $this->overallArr[$class] = $postData['overall_score_'.$class][1];
                    for($i=0;$i<count($postData['subjectpoints_'.$class]);$i++) {
                        if($postData['subjectpoints_'.$class][$i] != 0){
                            $subject_class[] = $postData['subjectpoints_'.$class][$i];
                            $subject_score[] = $postData['subject_points_'.$class][$i];
                        }
                    }
                } else if($this->boardArr[$class] == '10' || $this->boardArr[$class] == '20' || $this->boardArr[$class] == '3' || $this->boardArr[$class] == '18') {
                    $subject_class = array();
                    $subject_score = array();
                    for($i=0;$i<count($postData['subjectgrades_'.$class]);$i++) {
                        if($postData['subjectgrades_'.$class][$i] != 0){
                            $subject_class[] = $postData['subjectgrades_'.$class][$i];
                            $subject_score[] = $postData['subject_grades_'.$class][$i];
                        }
                    }
                }

                //$this->subjectArr = array();
                //$this->subjectmarksArr = array();
               // $this->studenteducationArr = array();

                for($i=0; $i<count($subject_class); $i++){
                    if($subject_class[$i] != ""){
                        $this->subjectArr[$class][]			= $subject_class[$i];
                        $this->subjectmarksArr[$class][]	= $subject_score[$i];
                    }
                }
                $this->studenteducationArr[$class][] = count($this->subjectArr[$class]);
            }

            $this->studentEntranceexamArr = array();
            $this->entranceexamID = array();
            $this->entranceexamstatus = array();
            $this->entranceexamappear = array();
            $this->entranceexamoverall = array();
            $this->entranceExammoduleArr = array();
            $this->entranceExammoduleID = array();
            $this->entranceExammodulemarks = array();

            for($km=0;$km<count($postData['entrance_exam']);$km++) {
                $this->studentEntranceexamArr = count($postData['entrance_exam'])-1;
                $randVal = $postData['hidModuleRandIds'][$km];

                if($postData['entrance_exam'][$km] != 0){
                   $this->entranceexamID[] = $postData['entrance_exam'][$km];
                   $this->entranceexamstatus[] = $postData['entrance_exam_status'][$km];
                   $this->entranceexamappear[] = $postData['entrance_exam_appear'][$km];
                   $this->entranceexamoverall[] = $postData['entrance_overall_score'][$km];

                    if($randVal !="inputRandId") {
                        for($j=0;$j<count($postData['entrance_exam_module'][$randVal]);$j++) {
                            if($postData['entrance_exam_module'][$randVal][$j] !=0) {
                                $this->entranceExammoduleID[$postData['entrance_exam'][$km]][] = $postData['entrance_exam_module'][$randVal][$j];
                                $this->entranceExammodulemarks[$postData['entrance_exam'][$km]][] = $postData['entrance_module_score'][$randVal][$j];
                            }
                        }
                        $this->entranceExammoduleArr[] = count($this->entranceExammoduleID[$postData['entrance_exam'][$km]]);
                    }
                }
            }

            if ($editEducationModel->validate()) {
                if(!empty($this->userData->attributes['user_id']))
                {
                    $criteria = new CDbCriteria;
                    $criteria->condition = "user_ref_id = '".$this->userData->attributes['user_id']."'";
                    $studenteducation = StudentEducation::model()->findAll($criteria);
                    foreach($studenteducation as $studenteducations) {
                        $criteria1 = new CDbCriteria;
                        $criteria1->condition = "student_education_ref_id = '".$studenteducations['student_education_id']."'";
                        $grademodule = StudentGradeCount::model()->findAll($criteria1);
                        foreach($grademodule as $grademodules) {
                            StudentGradeCount::model()->deleteByPk($grademodules->attributes['student_grade_count_id']);
                        }
                        $educationmodule = StudentEducationDetail::model()->findAll($criteria1);

                        foreach($educationmodule as $educationmodules) {
                            StudentEducationDetail::model()->deleteByPk($educationmodules->attributes['student_education_detail_id']);
                        }
                        StudentEducation::model()->deleteByPk($studenteducations->attributes['student_education_id']);
                    }

                    foreach($this->studentClassDetails as $class => $classDetails){
                        $obj = new StudentEducation();
                        $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                        $obj->{board_ref_id} = $postData['board'.$class][0];
                        $obj->{overall_marks} = $this->overallArr[$class];
                        $obj->{year} = $postData['passout_year'.$class][0];
                        $obj->{month} = $postData['passout_month'.$class][0];
                        $obj->{class_level} = $class;
                        $obj->{status} = $ClassLevel[1];
                        $obj->{school_name} = $postData['present_school'.$class][0];
                        $obj->save();

                        if($postData['board'.$class][0] == '11' || $postData['board'.$class][0] == '13' || $postData['board'.$class][0] == '14'
                            || $postData['board'.$class][0] == '17' || $postData['board'.$class][0] == '1' || $postData['board'.$class][0] == '2'
                            || $postData['board'.$class][0] == '4' || $postData['board'.$class][0] == '15') {
                            $subject_class = array();
                            $subject_score = array();
                            for($i=0;$i<count($postData['subject_'.$class]);$i++) {
                                if($postData['subject_'.$class][$i] != 0){
                                    $subject_class[] = $postData['subject_'.$class][$i];
                                    $subject_score[] = $postData['subject_score_'.$class][$i];
                                }
                            }

                            for($j=0; $j<count($subject_class); $j++){
                                $obj_edu_detail = new StudentEducationDetail();
                                $obj_edu_detail->{student_education_ref_id} = $obj->getPrimaryKey();
                                $obj_edu_detail->{student_subject_ref_id} = $subject_class[$j];
                                $obj_edu_detail->{marks} = $subject_score[$j];
                                $obj_edu_detail->save();
                            }
                        }  else if($this->boardArr[$class] == '12' || $this->boardArr[$class] == '27') {
                            $subject_class = array();
                            $subject_score = array();
                            for($i=0;$i<count($postData['subjectpoints_'.$class]);$i++) {
                                if($postData['subjectpoints_'.$class][$i] != 0){
                                    $subject_class[] = $postData['subjectpoints_'.$class][$i];
                                    $subject_score[] = $postData['subject_points_'.$class][$i];
                                }
                            }

                            for($j=0; $j<count($subject_class); $j++){
                                $obj_edu_detail = new StudentEducationDetail();
                                $obj_edu_detail->{student_education_ref_id} = $obj->getPrimaryKey();
                                $obj_edu_detail->{student_subject_ref_id} = $subject_class[$j];
                                $obj_edu_detail->{marks} = $subject_score[$j];
                                $obj_edu_detail->save();
                            }
                        } else if($this->boardArr[$class] == '10' || $this->boardArr[$class] == '20' || $this->boardArr[$class] == '3' || $this->boardArr[$class] == '18') {
                            $subject_class = array();
                            $subject_score = array();
                            for($i=0;$i<count($postData['subjectgrades_'.$class]);$i++) {
                                if($postData['subjectgrades_'.$class][$i] != 0){
                                    $subject_class[] = $postData['subjectgrades_'.$class][$i];
                                    $subject_score[] = $postData['subject_grades_'.$class][$i];
                                }
                            }
                           $grademodule = LookupGrade::model()->findAll();
                           foreach($grademodule as $grademodules) {
                               $gradeval = $postData['overall_marks_'.$grademodules['grade_type'].'_'.$class][0];
                               $obj_grade_detail = new StudentGradeCount();
                               $obj_grade_detail->{student_education_ref_id} = $obj->getPrimaryKey();
                               $obj_grade_detail->{grade_count} = $gradeval;
                               $obj_grade_detail->{grade_ref_id} = $grademodules['grade_id'];
                               $obj_grade_detail->save();
                           }

                            for($j=0; $j<count($subject_class); $j++){
                                $obj_edu_detail = new StudentEducationDetail();
                                $obj_edu_detail->{student_education_ref_id} = $obj->getPrimaryKey();
                                $obj_edu_detail->{student_subject_ref_id} = $subject_class[$j];
                                $obj_edu_detail->{grade_ref_id} = $subject_score[$j];
                                $obj_edu_detail->save();
                            }
                        }
                    }

                    $studentUserExam = UserEntranceExam::model()->findAll($criteria);
                    foreach($studentUserExam as $studentUserExams) {
                        $criteria = new CDbCriteria;
                        $criteria->condition = "user_entrance_exam_ref_id = '".$studentUserExams['user_entrance_exam_id']."'";
                        $studentmodule = UserEntranceExamModule::model()->findAll($criteria);
                        foreach($studentmodule as $studentmodulelist) {
                            UserEntranceExamModule::model()->deleteByPk($studentmodulelist->attributes['user_entrance_exam_module_id']);
                        }
                        UserEntranceExam::model()->deleteByPk($studentUserExams->attributes['user_entrance_exam_id']);
                    }
                }

                for($i=0; $i<count($postData['entrance_exam']); $i++){
                    $randVal = $postData['hidModuleRandIds'][$i];
                    if($postData['entrance_exam'][$i] != "") {
                        $obj = new UserEntranceExam();
                        $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                        $obj->{entrance_exam_ref_id} = $postData['entrance_exam'][$i];
                        $obj->{exam_status} = $postData['entrance_exam_status'][$i];
                        $obj->{exam_year} = $postData['entrance_exam_appear'][$i];
                        $obj->{overall_marks} = $postData['entrance_overall_score'][$i];
                        $obj->{added_by} = $this->userData->attributes['login_ref_id'];
                        $obj->save();

                        for($j=0;$j<count($postData['entrance_exam_module'][$randVal]);$j++) {
                            $obj_user = new UserEntranceExamModule();
                            $obj_user->{user_entrance_exam_ref_id} = $obj->getPrimaryKey();
                            $obj_user->{entrance_exam_module_entrance_exam_ref_id} = $postData['entrance_exam_module'][$randVal][$j];
                            $obj_user->{marks} = $postData['entrance_module_score'][$randVal][$j];
                            $obj_user->{added_by} = $this->userData->attributes['login_ref_id'];
                            $obj_user->save();
                        }

                    }
                }

                if($postData['board12'][0] != "") {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET board='1' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                } else {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET board='0' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                }

                if($postData['passout_year12'][0] != "") {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET completion_year='1' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                } else {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET completion_year='0' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                }

                if($postData['present_school12'][0] != "") {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET school_name='1' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                } else {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET school_name='0' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                }


                $criticalFields = array('edu_study_level' => 1);
                $modelCriticalFields = TblUserProfCriticalCompletion::model()->find(array("condition" => "user_ref_id = ".$this->userId));
                $modelCriticalFields->setAttributes($criticalFields);
                $modelCriticalFields->save(false);

                $fields = array('present_class' => $presentClass, 'class_status' => $presentClassStatus);
                TblUserMaster::updateUserFields($this->userId, $fields);

                /*if($this->userData->save(false)) {

                }*/
                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated',array('NAME' => 'Education Information'));
                $shortList = new ShortListEngine();
                $shortList->profileUpdated();
                CommonUtils::calculateCriticalPercentage($this->userId);
                $this->redirect(Yii::app()->createUrl('student/Profile/EditPreferences', $this->userParams));
            }
        }
        $this->render('editEducation',array('editEducationModel' => $editEducationModel));
    }

    public function completeYear($class)
    {
        $classNumeric = substr($class, 0, $class == '9p' ? 1 : 2);
        switch ($class) {
            case '9p':
            case '10p':
            case '11p':
            case '12p':
                $startLimit = date("Y") + (12 - $classNumeric);
                $endLimit = $startLimit + 3;
                $arr = range($startLimit, $endLimit);
                break;
            case '12c':
                $startLimit = date("Y");
                $endLimit = $startLimit - 2;
                $arr = range($startLimit, $endLimit);
                break;
            default:
                $startLimit = date("Y");
                $endLimit = $startLimit - 2;
                $arr = range($startLimit, $endLimit);
                break;
        }
        return $arr;
    }

    public function actionEditPreferences(){
        $this->breadcrumbs=array(
            'Home'=>array('/home'),
            'My Profile'=>array('/student/profile'),
            'Edit Profile',
        );

        $editPreferencesModel = new EditProfile('PreferencesInfo');
        $this->performAjaxValidation($editPreferencesModel);
        $this->pageTitle = 'Univariety - Edit Preferences';
        $this->courseLevel = LookupCourseLevel::getParentCourseLevel(array(14));
        $this->courseLevel = CHtml::listData($this->courseLevel,'level_id', 'course_level');

        $this->countryList = TblCountryMaster::getStudentInterestedCountryList();
        $this->countryList = CHtml::listData($this->countryList,'country_id', 'country_name');

        $this->departments = LookupDepartment::getMainDepartmentList();
        $this->likelyperiod = LookupLikelyPeriod::model()->findAll();
        $this->likelyperiod = CHtml::listData($this->likelyperiod,'period_id', 'months');

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '".$this->userData->attributes['user_id']."'";
        $studentPreferredStudyLevel = StudentPreferredStudyLevel::model()->find($criteria);
        $levelID = LookupCourseLevel::getParentID($studentPreferredStudyLevel->attributes['course_level_ref_id']);
        $editPreferencesModel->{levelOfStudy} = $levelID;

        $studentPreferredCountries = StudentPreferredCountry::getStudentPreferredCountryDetails($this->userId);
        foreach($studentPreferredCountries as $studentPreferredCountry) {
            if($studentPreferredCountry['preference_order'] == 1)
                $editPreferencesModel->{countryPref1} = $studentPreferredCountry['country_ref_id'];
            else if($studentPreferredCountry['preference_order'] == 2)
                $editPreferencesModel->{countryPref2} = $studentPreferredCountry['country_ref_id'];
            else
                $editPreferencesModel->{countryPref3} = $studentPreferredCountry['country_ref_id'];
        }

        $studentPreferredDepartments = StudentPreferredDepartment::getStudentPreferredDepartmentDetails($this->userId);
        $i=0;
        foreach($studentPreferredDepartments as $studentPreferredDept) {
            $i++;
            if($i <= 3) {
               $editPreferencesModel->{targetCourse.$i} = $studentPreferredDept['main_dept_ref_id'];
               $editPreferencesModel->{subCourse.$i} = $studentPreferredDept['sub_dept_ref_id'];
            }
        }

        $studentPreferredLikelyPeriods = StudentPreferredPeriod::getStudentPreferredPeriods($this->userId);
        $i=0;
        foreach($studentPreferredLikelyPeriods as $studentPreferredLikelyPeriod) {
            $i++;
            $editPreferencesModel->{likely_session.$i} = $studentPreferredLikelyPeriod['period_ref_id'];
            $editPreferencesModel->{session_year.$i} = $studentPreferredLikelyPeriod['year'];
        }

        if (isset($_POST['EditProfile'])) {
            $editPreferencesModel->attributes = $_POST['EditProfile'];
            $postData = Yii::app()->request->getPost('EditProfile');

            $editPreferencesModel->{levelOfStudy} = $postData['levelOfStudy'];
            $editPreferencesModel->{countryPref1} = $postData['countryPref1'];
            $editPreferencesModel->{countryPref2} = $postData['countryPref2'];
            $editPreferencesModel->{countryPref3} = $postData['countryPref3'];
            $editPreferencesModel->{targetCourse1} = $postData['targetCourse1'];
            $editPreferencesModel->{subCourse1} = $postData['subCourse1'];
            $editPreferencesModel->{targetCourse2} = $postData['targetCourse2'];
            $editPreferencesModel->{subCourse2} = $postData['subCourse2'];
            $editPreferencesModel->{targetCourse3} = $postData['targetCourse3'];
            $editPreferencesModel->{subCourse3} = $postData['subCourse3'];
            $editPreferencesModel->{likely_session1} = $postData['likely_session1'];
            $editPreferencesModel->{session_year1} = $postData['session_year1'];
            $editPreferencesModel->{likely_session2} = $postData['likely_session2'];
            $editPreferencesModel->{session_year2} = $postData['session_year2'];
            $editPreferencesModel->{likely_session3} = $postData['likely_session3'];
            $editPreferencesModel->{session_year3} = $postData['session_year3'];

            if ($editPreferencesModel->validate()) {
                if(!empty($this->userData->attributes['user_id']))
                {
                    $criteria = new CDbCriteria;
                    $criteria->condition = "user_ref_id = '".$this->userData->attributes['user_id']."'";
                    StudentPreferredCountry::model()->deleteAll($criteria);
                }
                if($postData['countryPref1']!= ""){
                    $obj = new StudentPreferredCountry();
                    $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                    $obj->{country_ref_id} = $postData['countryPref1'];
                    $obj->{preference_order} = 1;
                    $obj->save();
                }

                if($postData['countryPref2']!= ""){
                    $obj = new StudentPreferredCountry();
                    $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                    $obj->{country_ref_id} = $postData['countryPref2'];
                    $obj->{preference_order} = 2;
                    $obj->save();
                }

                if($postData['countryPref3']!= ""){
                    $obj = new StudentPreferredCountry();
                    $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                    $obj->{country_ref_id} = $postData['countryPref3'];
                    $obj->{preference_order} = 3;
                    $obj->save();
                }

                if($postData['countryPref1']!= "" || $postData['countryPref2']!= "" || $postData['countryPref3']!= "") {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET country='1' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                } else {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET country='0' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                }

                $criteria = new CDbCriteria;
                $criteria->condition = "user_ref_id = '".$this->userData->attributes['user_id']."'";
                StudentPreferredDepartment::model()->deleteAll($criteria);
                if($postData['targetCourse1']!= ""){
                    $obj = new StudentPreferredDepartment();
                    $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                    $obj->{main_dept_ref_id} = $postData['targetCourse1'];
                    $obj->{sub_dept_ref_id} = $postData['subCourse1'];
                    $obj->save();
                }
                if($postData['targetCourse2']!= ""){
                    $obj = new StudentPreferredDepartment();
                    $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                    $obj->{main_dept_ref_id} = $postData['targetCourse2'];
                    $obj->{sub_dept_ref_id} = $postData['subCourse2'];
                    $obj->save();
                }
                if($postData['targetCourse3']!= ""){
                    $obj = new StudentPreferredDepartment();
                    $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                    $obj->{main_dept_ref_id} = $postData['targetCourse3'];
                    $obj->{sub_dept_ref_id} = $postData['subCourse3'];
                    $obj->save();
                }

                if($postData['targetCourse1']!= "" || $postData['targetCourse2']!= "" || $postData['targetCourse3']!= "") {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET intended_subjects='1' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                } else {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET intended_subjects='0' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                }

                $criteria = new CDbCriteria;
                $criteria->condition = "user_ref_id = '".$this->userData->attributes['user_id']."'";
                StudentPreferredPeriod::model()->deleteAll($criteria);
                if($postData['likely_session1']!= ""){
                    $criteria = new CDbCriteria;
                    $criteria->condition = "period_id = '".$postData['likely_session1']."'";
                    $likelyVal = LookupLikelyPeriod::model()->find($criteria);

                    $obj = new StudentPreferredPeriod();
                    $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                    $obj->{period_ref_id} = $postData['likely_session1'];
                    $obj->{from_month} = $likelyVal['from_month'];
                    $obj->{to_month} = $likelyVal['to_month'];
                    $obj->{year} = $postData['session_year1'];
                    $obj->save();
                }

                if($postData['likely_session2']!= ""){
                    $criteria = new CDbCriteria;
                    $criteria->condition = "period_id = '".$postData['likely_session2']."'";
                    $likelyVal = LookupLikelyPeriod::model()->find($criteria);

                    $obj = new StudentPreferredPeriod();
                    $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                    $obj->{period_ref_id} = $postData['likely_session2'];
                    $obj->{from_month} = $likelyVal['from_month'];
                    $obj->{to_month} = $likelyVal['to_month'];
                    $obj->{year} = $postData['session_year2'];
                    $obj->save();
                }

                if($postData['likely_session3']!= ""){
                    $criteria = new CDbCriteria;
                    $criteria->condition = "period_id = '".$postData['likely_session3']."'";
                    $likelyVal = LookupLikelyPeriod::model()->find($criteria);

                    $obj = new StudentPreferredPeriod();
                    $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                    $obj->{period_ref_id} = $postData['likely_session3'];
                    $obj->{from_month} = $likelyVal['from_month'];
                    $obj->{to_month} = $likelyVal['to_month'];
                    $obj->{year} = $postData['session_year3'];
                    $obj->save();
                }

                if($postData['likely_session1']!= "" || $postData['likely_session2']!= "" || $postData['likely_session3']!= "") {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET likely_start_period='1' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                } else {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET likely_start_period='0' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                }

                $criteria = new CDbCriteria;
                $criteria->condition = "user_ref_id = '".$this->userData->attributes['user_id']."'";
                StudentPreferredStudyLevel::model()->deleteAll($criteria);
                if($postData['levelOfStudy']!= ""){
                    $obj = new StudentPreferredStudyLevel();
                    $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                    $obj->{course_level_ref_id} = $postData['levelOfStudy'];
                    $obj->save();
                    $sql = "UPDATE tbl_user_prof_critical_completion SET study_level='1' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                } else {
                    $sql = "UPDATE tbl_user_prof_critical_completion SET study_level='0' WHERE user_ref_id='$this->userId'";
                    $command =Yii::app()->db->createCommand($sql);
                    $command->query();
                }

                $shortList = new ShortListEngine();
                $shortList->profileUpdated();
                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated',array('NAME' => 'Preferences Information'));
                CommonUtils::calculateCriticalPercentage($this->userId);
                $this->redirect(Yii::app()->createUrl('student/Profile/EditCurricularActivities', $this->userParams));
            }
        }

        $this->render('editPreferences', array('editPreferencesModel' => $editPreferencesModel));
    }

    public function actionGetSubDeptList(){
        $deptId = Yii::app()->request->getQuery('deptId');
        $modelSubDept = LookupDepartment::getSubDepartmentsList($deptId);
        $this->subDeptList = CHtml::listData($modelSubDept,'department_id', 'department_name');
        echo json_encode($this->subDeptList);
    }

    public function actionGetSubjectsList(){
        $boardId = Yii::app()->request->getQuery('boardId');
        $modelSubjects = LookupSubjectMaster::getSubjectsList($boardId);
        $this->subjectList = CHtml::listData($modelSubjects, 'student_subject_id', 'subject_name');
        echo json_encode($this->subjectList);
    }

    public function actionGetModulesList(){
        $entranceId = Yii::app()->request->getQuery('entranceId');
        $moduleList = EntranceExamModule::getEntranceModuleList($entranceId);
        $this->moduleList = CHtml::listData($moduleList,'entrance_exam_module_entrance_exam_id','module_name');
        echo json_encode($this->moduleList);
    }

    public function actionGetModuleHtml(){
        $editEducationModel = new EditProfile('EducationInfo');
        $this->performAjaxValidation($editEducationModel);
        $randomId = Yii::app()->request->getQuery('randomId');
        $this->renderPartial("ModuleHtml", array('randomId' => $randomId, 'editEducationModel' => $editEducationModel));
    }

    public function actionEditCurricularActivities(){
        $this->breadcrumbs=array(
            'Home'=>array('/home'),
            'My Profile'=>array('/student/profile'),
            'Edit Profile',
        );

        $editCurricularModel = new EditProfile('CurricularInfo');
        $this->performAjaxValidation($editCurricularModel);
        $this->pageTitle = 'Univariety - Edit Curricular Activites';

        $result = TblUserInterest::getUserInterests($this->userId);
        foreach($result as $results) {
            if($results['interest'] == "Sports") {
                $this->fldSportsArr[]			= $results['user_interest_type_ref_id'];
                $this->fldSportsLevelArr[]	= $results['user_interest_level_ref_id'];
            }

            if($results['interest'] == "Music") {
                $this->fldMusicArr[]			= $results['user_interest_type_ref_id'];
                $this->fldMusicLevelArr[]	= $results['user_interest_level_ref_id'];
            }

            if($results['interest'] == "Voice") {
                $this->fldVoiceArr[]			= $results['user_interest_type_ref_id'];
                $this->fldVoiceLevelArr[]	= $results['user_interest_level_ref_id'];
            }

            if($results['interest'] == "Visual Art") {
                $this->fldVisualartArr[]			= $results['user_interest_type_ref_id'];
                $this->fldVisualartLevelArr[]	= $results['user_interest_level_ref_id'];
            }

            if($results['interest'] == "Performing Art") {
                $this->fldPerformingArtsArr[]			= $results['user_interest_type_ref_id'];
                $this->fldPerformingArtsLevelArr[]	= $results['user_interest_level_ref_id'];
            }

        }

        $editCurricularModel->{leadership_activity} = $this->userData->attributes['ps_leadership'];
        $editCurricularModel->{other_activity} = $this->userData->attributes['other_activities'];

        if (isset($_POST['EditProfile'])) {
            $editCurricularModel->attributes = $_POST['EditProfile'];
            $postData = Yii::app()->request->getPost('EditProfile');

            $this->fldSportsArr = array();
            $this->fldSportsLevelArr = array();
            $this->fldMusicArr = array();
            $this->fldMusicLevelArr = array();
            $this->fldVoiceArr = array();
            $this->fldVoiceLevelArr = array();
            $this->fldVisualartArr = array();
            $this->fldVisualartLevelArr = array();
            $this->fldPerformingArtsArr = array();
            $this->fldPerformingArtsLevelArr = array();

            for($i=0; $i<count($postData['selSports']); $i++){
                if($postData['selSports'][$i] != ""){
                    $this->fldSportsArr[]			= $postData['selSports'][$i];
                    $this->fldSportsLevelArr[]	= $postData["selSportsLevel"][$i];
                }
            }

            for($i=0; $i<count($postData['selMusic']); $i++){
                if($postData['selMusic'][$i] != 0){
                    $this->fldMusicArr[]			= $postData['selMusic'][$i];
                    $this->fldMusicLevelArr[]	= $postData["selMusicLevel"][$i];
                }
            }

            for($i=0; $i<count($postData['selVoice']); $i++){
                if($postData['selVoice'][$i] != 0){
                    $this->fldVoiceArr[]			= $postData['selVoice'][$i];
                    $this->fldVoiceLevelArr[]	= $postData["selVoiceLevel"][$i];
                }
            }

            for($i=0; $i<count($postData['selVisualArt']); $i++){
                if($postData['selVisualArt'][$i] != 0){
                    $this->fldVisualartArr[]			= $postData['selVisualArt'][$i];
                    $this->fldVisualartLevelArr[]	= $postData["selVisualLevel"][$i];
                }
            }

            for($i=0; $i<count($postData['selPerform']); $i++){
                if($postData['selPerform'][$i] != ""){
                    $this->fldPerformingArtsArr[]		= $postData['selPerform'][$i];
                    $this->fldPerformingArtsLevelArr[]	= $postData["selPerformLevel"][$i];
                }
            }

            $editCurricularModel->{leadership_activity} = $postData['leadership_activity'];
            $editCurricularModel->{other_activity} = $postData['other_activity'];

            if ($editCurricularModel->validate()) {
                if(!empty($this->userData->attributes['user_id']))
                {
                    $criteria = new CDbCriteria;
                    $criteria->condition = "user_ref_id = '".$this->userData->attributes['user_id']."'";
                    TblUserInterest::model()->deleteAll($criteria);
                }
                for($i=0; $i<count($postData['selSports']); $i++){
                    if($postData['selSports'][$i] != "") {
                        $obj = new TblUserInterest;
                        $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                        $obj->{user_interest_ref_id} = 1;
                        $obj->{user_interest_type_ref_id} = $postData['selSports'][$i];
                        $obj->{user_interest_level_ref_id} = $postData['selSportsLevel'][$i];
                        $obj->save();
                    }
                }

                for($i=0; $i<count($postData['selMusic']); $i++){
                    if($postData['selMusic'][$i] != "") {
                        $obj = new TblUserInterest;
                        $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                        $obj->{user_interest_ref_id} = 2;
                        $obj->{user_interest_type_ref_id} = $postData['selMusic'][$i];
                        $obj->{user_interest_level_ref_id} = $postData['selMusicLevel'][$i];
                        $obj->save();
                    }
                }

                for($i=0; $i<count($postData['selVoice']); $i++){
                    if($postData['selVoice'][$i] != "") {
                        $obj = new TblUserInterest;
                        $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                        $obj->{user_interest_ref_id} = 3;
                        $obj->{user_interest_type_ref_id} = $postData['selVoice'][$i];
                        $obj->{user_interest_level_ref_id} = $postData['selVoiceLevel'][$i];
                        $obj->save();
                    }

                }

                for($i=0; $i<count($postData['selVisualArt']); $i++){
                    if($postData['selVisualArt'][$i] != "") {
                        $obj = new TblUserInterest;
                        $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                        $obj->{user_interest_ref_id} = 4;
                        $obj->{user_interest_type_ref_id} = $postData['selVisualArt'][$i];
                        $obj->{user_interest_level_ref_id} = $postData['selVisualLevel'][$i];
                        $obj->save();
                    }
                }

                for($i=0; $i<count($postData['selPerform']); $i++){
                    if($postData['selPerform'][$i] != "") {
                        $obj = new TblUserInterest;
                        $obj->{user_ref_id} = $this->userData->attributes['user_id'];
                        $obj->{user_interest_ref_id} = 5;
                        $obj->{user_interest_type_ref_id} = $postData['selPerform'][$i];
                        $obj->{user_interest_level_ref_id} = $postData['selPerformLevel'][$i];
                        $obj->save();
                    }
                }

                $studentdetails = $this->userData->attributes['user_id'] > 0 ? TblUserMaster::model()->findByPk($this->userData->attributes['user_id']) : new TblUserMaster;
                $studentdetails->{ps_leadership} = $postData['leadership_activity'];
                $studentdetails->{other_activities} = $postData['other_activity'];
                $studentdetails->save();

                setFlashMessage('success_notify', 'globalnotifications.profile_info_updated',array('NAME' => 'Extra Curricular'));
                CommonUtils::calculateCriticalPercentage($this->userId);
            }
        }

        $this->render('editCurricularActivities',array('editCurricularModel' => $editCurricularModel));
    }
}