<?php
class DownloadDiBoughtProfilesController extends Controller
{

    /*public function filters(){
        return array(
            'rights',
        );
    }*/

    public function getStudentPrefCountriesNDepartments($userID = 0){

        $prefCountrySql = "SELECT GROUP_CONCAT(tcm.country_name) AS countries FROM student_preferred_country t
        JOIN tbl_country_master tcm ON tcm.country_id=t.country_ref_id WHERE t.user_ref_id='".$userID."' ORDER BY t.preference_order ASC";
        $prefCountries = Yii::app()->db->createCommand($prefCountrySql)->queryScalar();

        $prefDeptSql = "SELECT GROUP_CONCAT(ld.department_name) AS depts FROM student_preferred_department t
        JOIN lookup_department ld ON ld.department_id=t.main_dept_ref_id WHERE t.user_ref_id='".$userID."' ORDER BY t.preference_order ASC";
        $prefDepartments = Yii::app()->db->createCommand($prefDeptSql)->queryScalar();

        $prefList =  array($prefCountries, $prefDepartments);
        return $prefList;
    }

    public function actionIndex()
    {

        $origin = Yii::app()->request->getParam('origin', false);
        $sUsers = Yii::app()->request->getParam('users', false);
        $diID  = Yii::app()->user->di_id;

        $usersDetails = StudentProfilesDownload::downloadDiBoughtProfiles($diID, $origin, $sUsers);
        //$header = array();
        $studentDetails    = array();
        $studentDetails[1] = array(
            'Name',
            'Email',
            'Student Contact Number',

            'Student Pref. Countries',
            'Student Pref. Departments',

            'Class 10 Status',
            'Class 10 PassOut Month',
            'Class 10 PassOut Year',
            'Class 10 Board',
            'Class 10 Overall',
            'Class 10 School',

            'Class 12 Status',
            'Class 12 PassOut Month',
            'Class 12 PassOut Year',
            'Class 12 Board',
            'Class 12 Overall',
            'Class 12 School',

            'Gender',
            'DOB',
            'Address',
            'Ethnicity',
            'Citizenship',


            'Father Name',
            'Father Contact Number',
            'Father Email',

            'Mother Name',
            'Mother Contact Number',
            'Mother Email',

            'Guardian Name',
            'Guardian Contact Number',
            'Guardian Email',



            'Entrance Exam 1',
            'Status',
            'Year of Appearing',
            'Overall Score',
            'Section 1',
            'Section 2',
            'Section 3',
            'Section 4',

            'Entrance Exam 2',
            'Status',
            'Year of Appearing',
            'Overall Score',
            'Section 1',
            'Section 2',
            'Section 3',
            'Section 4',

            'Entrance Exam 3',
            'Status',
            'Year of Appearing',
            'Overall Score',
            'Section 1',
            'Section 2',
            'Section 3',
            'Section 4',
        );

        $i = 2;
        foreach ($usersDetails as $userDetails) {
            $studentDetails[$i]['Name']        = $userDetails['student_name'];
            $studentDetails[$i]['Email']       = $userDetails['username'];

            //Student's Contact Numbers
            $studentDetails[$i]['contact_number'] = StudentContactNumber::getAllContactNumbersByType($userDetails['user_id'], 1);

            // student pref. countries and departments
            list($countries, $departments) = $this->getStudentPrefCountriesNDepartments($userDetails['user_id']);
            $studentDetails[$i]['countries'] = $countries;
            $studentDetails[$i]['departments'] = $departments;

            //Student Education details
            $studentEducationDetails = StudentEducation::getStudentEducationDetails($userDetails['user_id'], 10);
            $studentDetails[$i]['Class 10 Status'] = $studentEducationDetails->status;
            $studentDetails[$i]['Class 10 PassOut Month'] = ($studentEducationDetails->month != '') ? date('F', strtotime('2013-'.$studentEducationDetails->month.'-01')) : '';
            $studentDetails[$i]['Class 10 PassOut Year'] = $studentEducationDetails->year;
            $studentDetails[$i]['Class 10 Board'] = $studentEducationDetails->boardEquivalentRef->boardRef->board_desc;
            if($studentEducationDetails->boardEquivalentRef->overall_type == 'Grades'){
                $gradeInfo = StudentGradeCount::getStudentAllGradeDetails($studentEducationDetails->student_education_id);
                $gradeDetails = array();
                foreach($gradeInfo as $gd){
                    if($gd->grade_count > 0){
                        $str = strtoupper($gd->gradeRef->grade_type.'-'.$gd->grade_count);
                        $str = str_replace('AA', 'A*', $str);
                        $gradeDetails[] = $str;
                    }
                }
                $studentDetails[$i]['Class 10 Overall'] = implode(', ', $gradeDetails);
            }else{
                $studentDetails[$i]['Class 10 Overall'] = (int)$studentEducationDetails->overall_marks;
            }
            $studentDetails[$i]['Class 10 School'] = $studentEducationDetails->school_name;

            $studentEducationDetails = StudentEducation::getStudentEducationDetails($userDetails['user_id'], 12);
            $studentDetails[$i]['Class 12 Status'] = $studentEducationDetails->status;
            $studentDetails[$i]['Class 12 PassOut Month'] = ($studentEducationDetails->month != '') ? date('F', strtotime('2013-'.$studentEducationDetails->month.'-01')) : '';
            $studentDetails[$i]['Class 12 PassOut Year'] = $studentEducationDetails->year;
            $studentDetails[$i]['Class 12 Board'] = $studentEducationDetails->boardEquivalentRef->boardRef->board_desc;
            if($studentEducationDetails->boardEquivalentRef->overall_type == 'Grades'){
                $gradeInfo = StudentGradeCount::getStudentAllGradeDetails($studentEducationDetails->student_education_id);
                $gradeDetails = array();
                foreach($gradeInfo as $gd){
                    if($gd->grade_count > 0){
                        $str = strtoupper($gd->gradeRef->grade_type.'-'.$gd->grade_count);
                        $str = str_replace('AA', 'A*', $str);
                        $gradeDetails[] = $str;
                    }
                }
                $studentDetails[$i]['Class 12 Overall'] = implode(', ', $gradeDetails);
            }else{
                $studentDetails[$i]['Class 12 Overall'] = (int)$studentEducationDetails->overall_marks;
            }
            $studentDetails[$i]['Class 12 School'] = $studentEducationDetails->school_name;

            $studentDetails[$i]['Gender']      = $userDetails['gender'];
            $studentDetails[$i]['DOB']         = $userDetails['dob'];
            $studentDetails[$i]['Address']     = implode(', ', array_filter(array($userDetails['address1'], $userDetails['address2'], $userDetails['city_name'], $userDetails['post_code'], $userDetails['state_name'], $userDetails['country_name'])));
            $studentDetails[$i]['Ethnicity']   = $userDetails['ethnicity_name'];

            $studentDetails[$i]['Citizenship'] = StudentCitizenship::getStudentCitizenshipAsString($userDetails['user_id']);



            $studentDetails[$i]['Father Name'] = $userDetails['father_name'];
            //Student's Father's Contact Numbers & Email
            $studentDetails[$i]['Father Contact Number'] = StudentContactNumber::getAllContactNumbersByType($userDetails['user_id'], 2);
            $studentDetails[$i]['Father Email'] = StudentAlternateEmail::getAllEmailsByType($userDetails['login_ref_id'], 2);

            $studentDetails[$i]['Mother Name'] = $userDetails['mother_name'];
            //Student's Mother's Contact Numbers & Email
            $studentDetails[$i]['Mother Contact Number'] = StudentContactNumber::getAllContactNumbersByType($userDetails['user_id'], 3);
            $studentDetails[$i]['Mother Email'] = StudentAlternateEmail::getAllEmailsByType($userDetails['login_ref_id'], 3);

            $studentDetails[$i]['Guardian Name'] = $userDetails['guardian_name'];
            //Student's Guardian's Contact Numbers & Email
            $studentDetails[$i]['Guardian Contact Number'] = StudentContactNumber::getAllContactNumbersByType($userDetails['user_id'], 4);
            $studentDetails[$i]['Guardian Email'] = StudentAlternateEmail::getAllEmailsByType($userDetails['login_ref_id'], 4);



            //Entrance Exam
            $userEntranceExamDetails = UserEntranceExam::getUserEntranceExamDetails($userDetails['user_id']);
            $j=1;
            foreach($userEntranceExamDetails as $userEntranceExam){
                $studentDetails[$i]['Entrance Exam '.$j] = $userEntranceExam->entranceExamRef->entrance_short_name;
                $studentDetails[$i]['Status '.$j] = ($userEntranceExam->exam_status == 'Completed') ? 'Taken' : $userEntranceExam->exam_status;
                $studentDetails[$i]['Year of Appearing '.$j] = $userEntranceExam->exam_year;
                $studentDetails[$i]['Overall Score '.$j] = (int)($userEntranceExam->overall_marks);
                $k=1;
                $userEntranceExamModuleDetails = UserEntranceExamModule::getUserEntranceexamList($userEntranceExam->user_entrance_exam_id);
                foreach($userEntranceExamModuleDetails as $userEntranceExamModule){
                    $studentDetails[$i]['Section 1 '.$j.$k] = $userEntranceExamModule->entranceExamModuleEntranceExamRef->entranceExamModuleRef->module_name.'-'.((int)$userEntranceExamModule->marks);
                    $k++;
                }
                /*if($k<5){
                    for($temp2=$k; $temp2<5; $temp2++){
                        $studentDetails[$i]['Section 1 '.$temp2] = '';
                    }
                }*/
                $j++;
            }
            for($temp1 = $j; $temp1<4; $temp1++){
                $studentDetails[$i]['Entrance Exam '.$temp1] = '';
                $studentDetails[$i]['Status '.$temp1] = '';
                $studentDetails[$i]['Year of Appearing '.$temp1] = '';
                $studentDetails[$i]['Overall Score '.$temp1] = '';

                if($k<5){
                    for($temp2=$k; $temp2<5; $temp2++){
                        $studentDetails[$i]['Section 1 '.$temp1.$temp2] = '';
                    }
                }
            }


            $i++;
            /*if($i>2){
                echo '<pre>';
                die(print_r($studentDetails));
            }*/
        }
        //$studentDetails1[1] = $header;
        //, $studentDetails);
        //echo '<pre>';
        //die(print_r($studentDetails));
        Yii::import('application.extensions.PHPExcel.JPhpExcel');
        $xls = new JPhpExcel('UTF-8', false, 'attendanceSummary');
        $xls->addArray($studentDetails);
        $xls->generateXML('BoughtProfiles');
    }
}