<?php

class AccomplishmentsController extends Controller {

    public function init() {
        parent::init();
        Yii::app()->theme = 'new_grid_theme';
        $this->layout = "//layouts/new_grid_inner";
    }
    
    public function filters() {
        return array(
        );
    }

    public function beforeAction($action) {
        parent::beforeAction($action);
        Yii::import('application.modules.managewebinar.models.*');
        
        if(!Yii::app()->user->id && Yii::app()->request->getParam('ref') && Yii::app()->request->getParam('event')){
            $user = $this->_get_username_by_tracking_key();
            $event = urldecode(Yii::app()->request->getParam('event'));
            
            if($user){
                $login_master = new LoginMaster();
                $login_master->skipPassword = true;
                $login_master->loginWithRedirect($user['username'], null, $this->createUrl('webinars',array('event' => $event)));
            }
        }
        if(!Yii::app()->user->id) $this->redirect($this->createUrl('/home'));
        return true;
    }
    
    public function beforeRender($view) {
        parent::beforeRender($view);
        return true;
    }
    
    public function actionIndex() {
        
        $this->redirect($this->createUrl('webinars'));
    }

    public function actionWebinars(){
        
        if(Yii::app()->request->isAjaxRequest){
            parse_str(Yii::app()->request->queryString,$filters);;
            $webinars_data = WebinarEvent::student_attended_webinars($filters);
            $this->renderPartial('_webinar_accomplishments', compact('webinars_data'), false, false);
            Yii::app()->end();
        }
        
        $webinars_data = WebinarEvent::student_attended_webinars();
        $this->render('webinar_accomplishments',compact('webinars_data'));
    }
    
    public function actiondownload_certificate(){
        
        $event_key = Yii::app()->request->getParam('event','0');
        
        $event = Yii::app()->db->createCommand()
                ->select('TblUserMaster.first_name, TblUserMaster.last_name, EventAttendees.event_ref_id, EventAttendees.attendance_time_seconds, TIMESTAMPDIFF(SECOND, WebinarEvent.event_start_time, WebinarEvent.event_end_time) AS event_time_in_seconds, WebinarEvent.*')
                ->from(EventAttendees::model()->tableSchema->name.' EventAttendees')
                ->join(WebinarEvent::model()->tableSchema->name. ' WebinarEvent', 'WebinarEvent.event_id = EventAttendees.event_ref_id AND WebinarEvent.is_attendees_copied = "1" AND WebinarEvent.is_active = "Y"')
                ->join(TblUserMaster::model()->tableSchema->name.' TblUserMaster', 'TblUserMaster.user_id = EventAttendees.user_ref_id')
                ->where('EventAttendees.user_ref_id = '. Yii::app()->user->sub_id.' AND WebinarEvent.webinar_key = :event_key')
                ->bindValues(array(':event_key' => (string)$event_key))
                ->having('attendance_time_seconds >= ((70/100) * event_time_in_seconds)')
                ->queryRow();
        if(!$event) throw new CHttpException(404);
        
        $file_name = preg_replace('!\s+!i', '_', $event['event_title']).'.pdf';

        $certificate_html = $this->renderPartial('certificate', compact('event'), true);
        //echo $certificate_html; exit;
        require_once(Yii::app()->params['docRootPath']."/html2pdf/html2pdf.class.php");
        
        ob_start();
        $html2pdf = new HTML2PDF('P', 'B5', 'en', true, 'UTF-8', array(10,12));
        $html2pdf->writeHTML($certificate_html);
        $html2pdf->Output($file_name, 'D');
        
        Yii::app()->end();
        
    }
    
    public function actionpsychometric_career_test(){
        
    }
    
    protected function _get_username_by_tracking_key($tracking_key = NULL){
        if(!$tracking_key) $tracking_key = Yii::app()->request->getParam('ref');
        if($tracking_key){
            return Yii::app()->db->createCommand()
                    ->select('LoginMaster.username')
                    ->from(TblEmailEvents::model()->tableSchema->name.' TblEmailEvents')
                    ->join(TblEventEmail::model()->tableSchema->name.' TblEventEmail', 'TblEmailEvents.tbl_event_email_ref_id = TblEventEmail.tbl_event_email_id')
                    ->join(TblUserMaster::model()->tableSchema->name.' TblUserMaster', 'TblEventEmail.user_ref_id = TblUserMaster.user_id')
                    ->join(LoginMaster::model()->tableSchema->name.' LoginMaster', 'TblUserMaster.login_ref_id = LoginMaster.login_id')
                    ->where('TblEmailEvents.tracking_key = :tkey', array(':tkey' => $tracking_key))
                    ->queryRow();
        }
        
        return false;
    }
    
    
}
