<?php
$this->layout = '//layouts/admin';

$criteria = new CDbCriteria();
$criteria->condition = "status != '" . UserMilestone::STATUS_INVALIDATED . "'";
$criteria->compare('user_ref_id', $student->user_id);
$criteria->compare('milestone_id', 63);
$milestone = UserMilestone::model()->find($criteria);
?>
<div class="mainContent">
	<div class="contentSegment">
		<!-- Navigation starts -->
		<div>
		<?php
		$this->renderPartial('_milestoneNavigator', array(
    	    	'currentMilestone' => 6,
    	        'student' => $student,
		));
		?>
		</div>
		<!-- Navigation ends -->
		<div>
		<?php 
		    $msId = 63;
		    for($i = 61; $i < 64; ++$i):
		?>
			<a class="alertbutton<?php echo ($msId == $i) ? ' on': ''; ?>" href="<?php echo Yii::app()->createUrl('sms/milestone/ms' . $i . 'Helper', array('studentId' => $student->user_id)); ?>">Step <?php echo $i - 60; ?></a>
		<?php 
		    endfor;
		?>
		</div>
		<div class="clear">&nbsp;</div>
		<?php
           if(empty($milestone) || $milestone->status == UserMilestone::STATUS_INPROGRESS):
		?>
		<div>
		Student did not finish this milestone yet.
		</div>
		<?php
		    else:
		?>
		
		
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="adminform" >
          <tr>
            <th scope="col" width="50%">Confirmed date - <?php echo date('d-m-Y h:s',strtotime($milestone->added_on)); ?></th>
            <th scope="col" width="50%" style="text-align:right;">
				  <?php
						/*echo CHtml::ajaxButton(
							"Invalidate", 
							Yii::app()->createUrl('sms/milestone/invalidateMilestone'),
							array ( 
								'type' => 'POST',
								'data' => 'ajax=invalidate-milestone&id=' . $milestone->user_milestone_id ,
								'dataType' => 'json',
								'success' => 'js: function(data){ $("#invalidate-button").attr("value", "Milestone Invalidated").attr("disabled", "disabled"); }',
								'beforeSend' => 'js:  function(){ }',
								'complete' => 'js:  function(){ }',
							),
							array(
								'id' => 'invalidate-button',
								'class' =>'alertbutton on' 
							)
						);
						*/
						
					?>          
            </th>
          </tr>
        </table>  
        <div class="clear">&nbsp;</div>
		 <div class="datagrid3">
		 
		 <?php
            $joinedUniversity = $student->joinedUniversity;
        ?>
		 <table width="100%" border="0" cellspacing="1" cellpadding="0" >
		 <tr>
		 	<th>Joined University:</th>
		 	<td>
		 		<?php echo $joinedUniversity->uni_ref_id ? $joinedUniversity->university->uni_name: $joinedUniversity->uni_name; ?>
		 	</td>
		 	<th>Apprx Fees:</th>
		 	<td>
		 		<?php echo $joinedUniversity->feesCurrency->currency_code; ?>
                <?php echo $joinedUniversity->fees; ?>
		 	</td>
		 </tr>
		 <?php if($joinedUniversity->hasLoan()): ?>
		 <tr>
		 	<th>Loan</th>
		 	<td><?php echo $joinedUniversity->loanCurrency->currency_code; ?> <?php echo $joinedUniversity->loan_amount; ?></td>
		 	<th>Loan Source</th>
		 	<td><?php echo $joinedUniversity->loan_source; ?> (<?php echo $joinedUniversity->bank_name; ?>)</td>
		 	
		 </tr>
		 <?php else: ?>
		 <tr>
		 	<th>Loan</th>
		 	<td colspan="3"><?php echo $joinedUniversity->has_loan ? 'Yes' : 'No'; ?></td>
		 </tr>
		 	<?php endif; ?>
		 	
		 <?php
            $scholarships = $joinedUniversity->scholarships;
            if(count($scholarships) == 0):
        ?>
        <tr>
        	<th>Scholarships</th>
        	<td colspan="3"><?php echo $joinedUniversity->has_scholarship ? 'Yes' : 'No'; ?></td>
        </tr>
        <?php 
            else:
        ?>
        	<tr>
        		<th>Scholarships</th>
        		<th>Type</th>
        		<th>Amount/percentage</th>
        		<th>Source</th>
        	</tr>
        	<?php
        	    
                $scholarshipTypes = StudentOutplacementUniversityScholarship::getTypes();
                foreach ($scholarships as $scholarship):
            ?>
        	<tr>
        		<td>&nbsp;</td>
            	<td><?php echo $scholarshipTypes[$scholarship->scholarship_type]; ?></td>
            	<td><?php echo ($scholarship->scholarship_percent > 0) ? $scholarship->scholarship_percent . '%' : $scholarship->currency->currency_code . ' ' . $scholarship->scholarship_amount; ?></td>
            	<td><?php echo $scholarship->scholarship_provider; ?></td>
        	</tr>
        	<?php 
        	    endforeach;
        	?>
        <?php 
            endif;
        ?>
		 </table>
		</div>
		<?php 
		endif;
		?>
	</div>
</div>


