<?php
$this->layout = '//layouts/admin';

$criteria = new CDbCriteria();
$criteria->condition = "status != '" . UserMilestone::STATUS_INVALIDATED . "'";
$criteria->compare('user_ref_id', $student->user_id);
$criteria->compare('milestone_id', 3);
$milestone = UserMilestone::model()->find($criteria);

$milestones = UserMilestone::getMilestones();
?>
<div class="mainContent">
	<div class="contentSegment">
		<!-- Navigation starts -->
		<div>
		<?php
		$this->renderPartial('_milestoneNavigator', array(
    	    	'currentMilestone' => 3,
    	        'student' => $student,
		));
		?>
		</div>
		<!-- Navigation ends -->


		<?php
		if(empty($milestone) || $milestone->status == UserMilestone::STATUS_INPROGRESS):
		?>
		<div>Student did not finish this milestone yet.</div>
		<?php
		else:
		?>
		<table width="100%" border="0" cellspacing="0" cellpadding="0"
			class="adminform">
			<tr>
				<th scope="col" width="50%">Confirmed date - <?php echo date('d-m-Y h:s',strtotime($milestone->added_on)); ?>
				</th>
				<th scope="col" width="50%" style="text-align: right;"><?php
				echo CHtml::ajaxButton(
						"Invalidate", 
				Yii::app()->createUrl('sms/milestone/invalidateMilestone'),
				array (
							'type' => 'POST',
							'data' => 'ajax=invalidate-milestone&id=' . $milestone->user_milestone_id ,
							'dataType' => 'json',
							'success' => 'js: function(data){ $("#invalidate-button").attr("value", "Milestone Invalidated").attr("disabled", "disabled"); }',
							'beforeSend' => 'js:  function(){ }',
							'complete' => 'js:  function(){ }',
				),
				array(
							'id' => 'invalidate-button',
							'class' =>'alertbutton on'
							)
							);


							?></th>
			</tr>
		</table>
		<div style="width: 100%;">
		<?php
		$departments = $student->studentPreferredDepartments;
		foreach($departments as $department):
		    $departmentId = $department->subDeptRef->department_id;

    		//$studentChosenBranches = $student->studentEntranceExamVendorBranches();
    		$studentChosenBranches = StudentEntranceExamVendorBranch::model()->findAllByAttributes(array(
                'user_ref_id' => $student->user_id,
                'sub_dept_ref_id' => $departmentId
    		));
    		$entranceExams = array();
    		foreach($studentChosenBranches as $entranceBranch){
    		    $entranceExams[$entranceBranch->entrance_exam_ref_id][$entranceBranch->vendorBranch->vendor_ref_id][] = $entranceBranch;
    
    		}
    		$notsure = StudentEntranceExamVendorBranch::isNotSure($student->user_id, $departmentId);
		?>
			<div style="width: 48%; float: left;">

				<h3>
					Chosen Vendors for
					<?php echo $department->subDeptRef->department_name; ?>
				</h3>
				<div class="datagrid3">

				<?php
				if($notsure):
				?>
					<div class="pad_5" style="padding: 10px;">
						Student marked
						<?php echo $milestones[3]; ?>
						as "Not Sure".
					</div>
					<?php
					else:
					foreach($entranceExams as $entranceExamId => $studentChosenBranches):
        	            $entranceExam = EntranceExam::model()->findByPk($entranceExamId);
					?>
					<table width="100%" border="0" cellspacing="0" cellpadding="0"
						style="margin-bottom: 10px">
						<tr>
							<th scope="col" colspan=""><?php echo $entranceExam->entrance_short_name; ?>
							</th>
						</tr>

						<?php
							
						foreach($studentChosenBranches as $vendorId => $studentVendorBranches):
		                    $vendor = Vendor::model()->findByPk($vendorId);
						?>
						<tr>
							<td>
							<span style="font-weight: bold;"><?php echo $vendor->name; ?></span><br />
						<?php 
							    foreach($studentVendorBranches as $studentVendorBranch):
							    ?>
							    <div class="pad_5">
        		<span><?php echo $studentVendorBranch->vendorBranch->branch_name; ?>, <?php echo $studentVendorBranch->vendorBranch->city->city_name; ?></span>
        	</div>
        	<?php 
        	    endforeach;
        	?>
							
							
							</td>
						</tr>
						<?php
						endforeach;
						?>


					</table>
					<?php
					endforeach;
					endif;
					?>

				</div>
			</div>
			<?php
			endforeach;
			?>
			<div class="clear">&nbsp;</div>
		</div>
		<?php
		endif;    //finish of student completed milestone or not if
		?>
	</div>
</div>


</div>


