<?php
$this->layout = '//layouts/admin';

$criteria = new CDbCriteria();
$criteria->condition = "status != '" . UserMilestone::STATUS_INVALIDATED . "'";
$criteria->compare('user_ref_id', $student->user_id);
$criteria->compare('milestone_id', 2);
$milestone = UserMilestone::model()->find($criteria);
?>
<div class="mainContent">
	<div class="contentSegment">
		<!-- Navigation starts -->
		<div>
		<?php
		$this->renderPartial('_milestoneNavigator', array(
    	    	'currentMilestone' => 2,
    	        'student' => $student,
		));
		?>
		</div>
		<!-- Navigation ends -->

		
		<?php
           if(empty($milestone) || $milestone->status == UserMilestone::STATUS_INPROGRESS):
		?>
		<div>
		Student did not finish this milestone yet.
		</div>
		<?php
		    else:
		?>
		
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="adminform" >
          <tr>
            <th scope="col" width="50%">Confirmed date - <?php echo date('d-m-Y h:s',strtotime($milestone->added_on)); ?></th>
            <th scope="col" width="50%" style="text-align:right;">
				  <?php
						echo CHtml::ajaxButton(
							"Invalidate", 
							Yii::app()->createUrl('sms/milestone/invalidateMilestone'),
							array ( 
								'type' => 'POST',
								'data' => 'ajax=invalidate-milestone&id=' . $milestone->user_milestone_id ,
								'dataType' => 'json',
								'success' => 'js: function(data){ $("#invalidate-button").attr("value", "Milestone Invalidated").attr("disabled", "disabled"); }',
								'beforeSend' => 'js:  function(){ }',
								'complete' => 'js:  function(){ }',
							),
							array(
								'id' => 'invalidate-button',
								'class' =>'alertbutton on' 
							)
						);
						
						
					?>          
            </th>
          </tr>
        </table>  
        <div class="clear">&nbsp;</div>
		 <div class="datagrid3">
        <table width="100%" border="0" cellspacing="1" cellpadding="0" >
          <tr>
            <th scope="col" width="30%">Countries</th>
            <th scope="col" width="30%">Departments</th>
          </tr>
          <tr>
            <td scope="col" width="30%">
            	<ul>
					<?php
                    $countries = $student->studentPreferredCountries();
                    foreach($countries as $preferredCountry):
                    $country = TblCountryMaster::model()->findByPk($preferredCountry->country_ref_id);
                    ?>
                        <li style="padding:5px;"><?php echo $country->country_name; ?></li>
                        <?php
                        endforeach;
                        ?>
                </ul>
            </td>
            <td scope="col" width="30%">
            	<ul>
					<?php
                    $departments = $student->studentPreferredDepartments;
                    foreach($departments as $preferredDepartment):
                    $department = LookupDepartment::model()->findByPk($preferredDepartment->sub_dept_ref_id);
                    ?>
                        <li style="padding:5px;"><?php echo $department->department_name; ?></li>
                        <?php
                        endforeach;
                        ?>
               	</ul>
            </td>
          </tr>
        </table>
        </div>
		
		<?php 
		endif;    //finish of student completed milestone or not if
		?>

	</div>
</div>


