<?php
$this->layout = '//layouts/admin';

$criteria = new CDbCriteria();
$criteria->condition = "status != '" . UserMilestone::STATUS_INVALIDATED . "'";
$criteria->compare('user_ref_id', $student->user_id);
$criteria->compare('milestone_id', 4);
$milestone = UserMilestone::model()->find($criteria);

//$showInput = $studentIdealList->status == StudentIdealList::STATUS_STARTED;
$showInput = true;

$typeLabels = StudentIdealList::getTypeLabels();

?>
<div class="mainContent">
	<div class="contentSegment">
		<!-- Navigation starts -->
		<div>
		<?php
		$this->renderPartial('_milestoneNavigator', array(
    	    	'currentMilestone' => 4,
    	        'student' => $student,
		));
		?>
		</div>
		<!-- Navigation ends -->
		
		<?php
           if(empty($milestone) || $milestone->status == UserMilestone::STATUS_INPROGRESS):
		?>
		<div>
		Student did not finish this milestone yet.
		</div>
		<div class="clear">&nbsp;</div>
		<?php
		    else:
		?>
		
		<div class="searchoptions_admin">
        <div class="padding" >
		<strong>Confirmed date:</strong> <span><?php echo date('d-m-Y h:s',strtotime($milestone->added_on)); ?></span>
		
		<span style="float:right;" >
		<?php
		    echo CHtml::ajaxButton(
		    	"Invalidate", 
		        Yii::app()->createUrl('sms/milestone/invalidateMilestone'),
		        array ( 
                    'type' => 'POST',
                    'data' => 'ajax=invalidate-milestone&id=' . $milestone->user_milestone_id ,
                    'dataType' => 'json',
                    'success' => 'js: function(data){ $("#invalidate-button").attr("value", "Milestone Invalidated").attr("disabled", "disabled"); }',
                    'beforeSend' => 'js:  function(){ }',
                    'complete' => 'js:  function(){ }',
                ),
                array(
                    'id' => 'invalidate-button',
					'class' =>'button'
                )
		    );
		    
		    
		?>
		</span>
        </div>
        </div>
        <div class="clear">&nbsp;</div>
        <?php 
        	endif;
        ?>

		<div class="tabs">
			
				<?php
				 
				/**  code to highlight the selected link */
				$alertOn = "";				
				if($idealType == StudentIdealList::TYPE_ASPIRATIONAL)
				    $aOn = 'on';
				else if($idealType == StudentIdealList::TYPE_BEST_FIT)
				    $bOn = 'on';
				else if($idealType == StudentIdealList::TYPE_SAFE)
				    $sOn = 'on';
				 
				echo CHtml::link($typeLabels[StudentIdealList::TYPE_ASPIRATIONAL], 
				Yii::app()->createUrl('sms/milestone/Ms4Helper', array(
			            'studentId' => $student->user_id,
			            'type' => StudentIdealList::TYPE_ASPIRATIONAL,
			            'departmentId' => $departmentId,
				)),
				array(
							'class' => 'alertbutton '.$aOn,
	            )
				);
				?>
				<?php 
				echo CHtml::link($typeLabels[StudentIdealList::TYPE_BEST_FIT], 
				Yii::app()->createUrl('sms/milestone/Ms4Helper', array(
			            'studentId' => $student->user_id,
			            'type' => StudentIdealList::TYPE_BEST_FIT,
			            'departmentId' => $departmentId,
				)),
				array(
							  'class' => 'alertbutton '.$bOn,
	            )
				);
				?>
				<?php 
				echo CHtml::link($typeLabels[StudentIdealList::TYPE_SAFE], 
				Yii::app()->createUrl('sms/milestone/Ms4Helper', array(
			            'studentId' => $student->user_id,
			            'type' => StudentIdealList::TYPE_SAFE,
			            'departmentId' => $departmentId,
				)),
				array(
							  'class' => 'alertbutton '.$sOn,
	            )
				);
				?>
				
		</div>
		<div class="clear"></div>
		<div id="<?php echo $idealType; ?>Container" style="background:#fff; padding:3px 8px; border:1px solid #eee; margin-top:5px; ">
       <div class="clear">&nbsp;</div>
        <div>
			
			<?php
			$departments = $student->studentPreferredDepartments;
			foreach($departments as $department):
				if($department->subDeptRef->department_id == $departmentId)
				 $alertOn = 'on';
				else
				 $alertOn = ''; 
				echo CHtml::link($department->subDeptRef->department_name,
				Yii::app()->createUrl('sms/milestone/Ms4Helper', array(
                		    'studentId' => $student->user_id,
        			        'type' => $idealType,
                		    'departmentId' => $department->subDeptRef->department_id,
				)),
				array(
							  'class' => 'alertbutton '.$alertOn,
	            )
				);
				?>				
				<?php
				endforeach;
				?>
			
		</div>
			<div class="form">
				<h3><?php echo $typeLabels[$idealType]; ?> List</h3>
				<div class="searchoptions_admin">
                <div class="padding">
                <span id="<?php echo $idealType; ?>Input" style="display:<?php echo $showInput? 'inline' : 'none;'; ?>">
				<?php
				$this->widget('zii.widgets.jui.CJuiAutoComplete', array(
            'name'=> $idealType . 'di',
		    'sourceUrl' => Yii::app()->createUrl('sms/milestone/CollegeListSuggest', array(
		        'student' => $studentIdealList->student->user_id,
		        'department'=> $studentIdealList->department_ref_id
				)),
				// additional javascript options for the autocomplete plugin
            'options'=>array(
            	'minLength'=>'1',
				'select' => 'js:function(event, ui){ $("#' . $idealType . 'diNewId").attr("value", ui.item.id); }',
				),
            'htmlOptions'=>array(
                'style'=>'width:300px; padding:5px;'
                ),
                ));
                ?>
					<input type="hidden" id="<?php echo $idealType; ?>diNewId" value="" />
					<input type="button" class="button border_radius2" name="button1" onclick="addUniversity(this, '<?php echo $idealType; ?>');" value="Add To List" />
					<span class="pad_5 left ajax-loader" style="display:none;">
				    	<img src="<?php echo Yii::app()->params['cbasepath']; ?>/images/9.gif" alt="loading" />
				    </span>
			</span>
					
					
					<span style="float:right;">
						<?php
						switch($studentIdealList->status){
						    case StudentIdealList::STATUS_UNIDONE: $label = 'Visible to student'; $disabled = 'disabled'; break;
						    case StudentIdealList::STATUS_STARTED: $label = 'Show to student'; $disabled = ''; break;
						    case StudentIdealList::STATUS_CONFIRMED: $label = 'Confirmed'; $disabled = 'disabled'; break;
						    case StudentIdealList::STATUS_INVALID: $label = 'Invalidated'; $disabled = 'disabled'; break;
						}
						    echo CHtml::ajaxButton($label, 
	                      Yii::app()->createUrl('sms/milestone/unidoneList'),
	                      array ( 
	                          'type' => 'POST',
	                          'data' => 'ajax=unidone-list&list=' . $studentIdealList->student_ideal_list_id,
	                          'dataType' => 'json',
	                          'success' => 'js: function(data){ if(data.status == "success"){ $("#unidone-button").attr("value", "Visible to student").attr("disabled", "disabled"); } window.location.reload(); }',
	                      ),
	                      array(
	                          'id' => 'unidone-button',
	                          'live' => false,
	                          'disabled' => $disabled,
	                      )
	                      
	    );
						?>
					</span>
					<div class="clear"></div>
                </div>
				</div>
				<div id="<?php echo $idealType; ?>Errors" style="color: #f00;"></div>
				<div id="<?php echo $idealType; ?>List" class=" padding border_radius2 filters" >
				<ol id="<?php echo $idealType; ?>Colleges" class="sortable">
				<?php
				$universities = $studentIdealList->collegeList;
				$i = 0;
				foreach($universities as $university){
				    $this->renderPartial('_ms4HelperCollegeRow', array(
                		'university' => $university, 
                		'hideRecord' => (++$i > 5),
                	    'idealType' => $idealType,
                	));
				}
				?>
				</ol>
				</div>
                <div class="float_rt">
                <?php
                    if($studentIdealList->status != StudentIdealList::STATUS_CONFIRMED):
                ?>
                <input type="button" class="button border_radius2 save-order" value="Save Preference Order" class="save-order" />
                <span id="order-message" style=" color: #999; display: none;"></span>
                <?php
                    endif;
                ?>
                </div>
                <div class="clear">&nbsp;</div>
			</div>
		</div>

		
	</div>
</div>
<script>

function addUniversity(ele, type){
	var universityId = $("#" + type + "diNewId").attr("value");
	$.ajax({
		type:"POST",
		dataType: "json",
		data: "ajax=add-university&type=" + type + "&universityId=" + universityId,
		beforeSend: function(){
			$(ele).next(".ajax-loader").show();
		},
		success: function(data){
			handleRowUpdation(type, "#" + type + "Colleges", data, "append");
			$(ele).next(".ajax-loader").hide();
		}
	});
	$("#" + type + "di").attr("value", "");
	$("#" + type + "diNewId").attr("value", "");
}

function handleRowUpdation(type, target, data, targetAction){
	$("#" + type + "Errors").html("").hide();
    if(data.status == 'success'){
        switch(targetAction){
            case "append": 
                $(data.html).appendTo(target); 
                break;
            case "replace": 
                $(target).replaceWith(data.html); 
                break;
            case "remove": 
                $(target).fadeOut("slow", function(){
					$(this).remove();
                });
                $("#" + type + "List").find(".university-show").click();
                break;
        }
        
		/*if(data.disableInput)
			$("#" + type + "Input").hide();
		else
		    $("#" + type + "Input").show();*/
		if(data.enableSubmit)
		    $("#" + type + "Submit").show();
		else
		    $("#" + type + "Submit").hide();
	}
	if(data.status == 'failed'){
		var html = "<ul>";
		for(i in data.error){
			html += "<li>" + data.error[i] + "</li>";
		}
		html += "</ul>";
		$(html).appendTo("#" + type + "Errors");
		$("#" + type + "Errors").show();
	}
}


function addListAjaxResponse(type, data){
	$("#" + type + "Errors").html("").hide();
	if(data.status == 'success'){
		$("#" + type + "List").html(data.html);
	}
	if(data.status == 'failed'){
		for(i in data.error){
			$("<div>" + data.error[i] + "</div>").appendTo("#" + type + "Errors");
		}
		$("#" + type + "Errors").show();
	}
}
function handleConfirm(type, data){
	$("#" + type + "Errors").html("").hide();
	if(data.status == 'success'){
		$("#" + type + "Container").html(data.html);
	}
	if(data.status == 'failed'){
		for(i in data.error){
			$("<div>" + data.error[i] + "</div>").appendTo("#" + type + "Errors");
		}
		$("#" + type + "Errors").show();
	}
}


jQuery(function($){
	$('body').on('click', '.review-link', function(e){
		e.preventDefault();
		$(this).next('.review-box').slideToggle().find('.focus').focus();
	});
	//
	$('body').on('click', '.review-cancel', function(e){
		e.preventDefault();
		$(this).parents('li').find('.review-box').slideUp();
	});
	$('body').on('click', '.save-order', function(e){
		e.preventDefault();
		var listId = <?php echo $studentIdealList->student_ideal_list_id; ?>;
		//console.log($(".preference-order").serialize());
		jQuery.ajax({
			'type': 'POST',
			'url': "<?php echo Yii::app()->createUrl('sms/milestone/saveUniversityOrder'); ?>",
			'cache':false,
			'data': 'ajax=save-order&' + $(".preference-order").serialize(),
			'dataType': 'json',
			'success': function(data){
				console.log(data);
				$("#<?php echo $idealType; ?>Errors").html("").hide();
				if(data.status == 'success'){
					$("#order-message").html("Preference order saved successfully.").show();
				}
				if(data.status == 'failed'){
					for(i in data.error){
						$("<div>" + data.error[i] + "</div>").appendTo("#<?php echo $idealType; ?>Errors");
					}
					$("#<?php echo $idealType; ?>Errors").show();
				}
			}
		});
	});
	$(".sortable").sortable();
	$(".sortable").disableSelection();
});

function addReview(form, data, hasError){
	if(hasError){
		return false;
	}
	var id = $(form).find("#StudentIdealListCollege_student_ideal_list_college_id").attr("value");
	jQuery.ajax({
		'type': $(form).attr("method"),
		'url': $(form).attr("action"),
		'cache':false,
		'data':$(form).serialize(),
		'dataType': 'json',
		'success': function(data){
		    handleRowUpdation("<?php echo $idealType; ?>", "#<?php echo $idealType; ?>-university-" + id, data, "replace");
		}
	});
	return false;
}

</script>

